<?php
/**
 * Template for displaying instructor of single course.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/single-course/instructor.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course = LP_Global::course();
if ( ! $course ) {
	return;
}

$user_id = get_the_author_meta( 'ID' );
$user = learn_press_get_user( $user_id );

// profile url
$url =  "/our_team/" . $user->get_first_name();
if($user->get_last_name()){
	$url .= "-" . $user->get_last_name();
}
$url = strtolower($url);

?>

<div class="course-author">
	<?php echo $course->get_instructor()->get_profile_picture(); ?>
    <div class="author-contain">
        <label itemprop="jobTitle"><?php esc_html_e( 'Instructor', 'eduma' ); ?></label>

        <div class="value" itemprop="name">
            <a href="<?= esc_url($url) ?>"><?php echo $user->get_display_name() ?></a>

			<?php //echo $course->get_instructor_html(); ?>
        </div>
    </div>
</div>