<?php

/**
 * Template for displaying courses tab in user profile page.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/tabs/courses.php.
 *
 * @author  ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.10
 */

defined('ABSPATH') || exit();

if (
	!isset($user) || !isset($tab_active) || !isset($courses_enrolled_tab) ||
	!isset($courses_created_tab) || !isset($courses_enrolled_tab_active) ||
	!isset($args_query_user_courses_attend) || !isset($args_query_user_courses_created) ||
	!isset($args_query_user_courses_statistic)
) {
	return;
}
?>

<div class="learn-press-subtab-content">
	<div class="learn-press-profile-course__statistic">
		<?php lp_skeleton_animation_html(4, 'random', 'height: 30px;border-radius:4px;'); ?>
		<input type="hidden" name="args_query_user_courses_statistic" value="<?php echo htmlentities(wp_json_encode($args_query_user_courses_statistic)); ?>">
	</div>

	<div class="learn-press-profile-course__tab">
		<ul class="learn-press-profile-course__tab__inner">
			<li>
				<a class="<?php echo $tab_active === 'enrolled' ? 'active' : ''; ?>" data-tab="enrolled">
					<?php esc_html_e('Enrolled', 'learnpress'); ?>
				</a>
			</li>

			<?php if (learn_press_user_maybe_is_a_teacher()) : ?>
				<li>
					<a class="<?php echo $tab_active === 'created' ? 'active' : ''; ?>" data-tab="created">
						<?php esc_html_e('Created', 'learnpress'); ?>
					</a>
				</li>
			<?php endif; ?>
		</ul>

		<div class="learn-press-course-tab-enrolled learn-press-course-tab-filters" data-tab="enrolled" style="<?php echo $tab_active !== 'enrolled' ? 'display: none;' : ''; ?>">
			<ul class="learn-press-filters">
				<?php foreach ($courses_enrolled_tab as $key => $enrolled) : ?>
					<li>
						<a class="<?php echo $key === $courses_enrolled_tab_active ? 'active' : ''; ?>" data-tab="<?php echo $key === '' ? 'all' : $key; ?>">
							<?php echo esc_html($enrolled); ?>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>

			<div class="learn-press-profile-course__progress">
				<?php foreach ($courses_enrolled_tab as $key => $enrolled) : ?>
					<div class="learn-press-course-tab__filter__content" data-tab="<?php echo $key === '' ? 'all' : $key; ?>" style="<?php echo $key !== $courses_enrolled_tab_active ? 'display: none' : ''; ?>"> <?php // phpcs:ignore 
																																																					?>
						<?php lp_skeleton_animation_html(4, 'random', 'height: 30px;border-radius:4px;'); ?>
					</div>
				<?php endforeach; ?>
				<input class="lp_profile_tab_input_param" type="hidden" name="args_query_user_courses_attend" value="<?php echo htmlentities(wp_json_encode($args_query_user_courses_attend)); ?>">
			</div>
		</div>

		<?php if (learn_press_user_maybe_is_a_teacher()) : ?>
			<div class="learn-press-course-tab-created learn-press-course-tab-filters" data-tab="created" style="<?php echo $tab_active !== 'created' ? 'display: none;' : ''; ?>">
				<ul class="learn-press-filters">
					<?php foreach ($courses_created_tab as $key => $created) : ?>
						<li>
							<a class="<?php echo $key === '' ? 'active' : ''; ?>" data-tab="<?php echo $key === '' ? 'all' : $key; ?>">
								<?php echo esc_html($created); ?>
							</a>
						</li>
					<?php endforeach; ?>
				</ul>

				<div class="learn-press-profile-course__progress">
					<?php foreach ($courses_created_tab as $key => $created) : ?>
						<div class="learn-press-course-tab__filter__content" data-tab="<?php echo $key === '' ? 'all' : $key; ?>" style="<?php echo $key !== '' ? 'display: none' : ''; ?>"> <?php // phpcs:ignore 
																																																?>
							<?php lp_skeleton_animation_html(4, 'random', 'height: 30px;border-radius:4px;'); ?>
						</div>
					<?php endforeach; ?>
					<input class="lp_profile_tab_input_param" type="hidden" name="args_query_user_courses_created" value="<?php echo htmlentities(wp_json_encode($args_query_user_courses_created)); ?>">
				</div>
			</div>
		<?php endif; ?>
	</div>
</div>


<?php $isMember = pmpro_hasMembershipLevel(); ?>

<?php if ($isMember) : ?>
	<div class="unlimited-access-dashboard">
		<h4>Unlimited Access</h4>
		<p>You have unlimited access to all courses</p>

		<div class="thim-course-grid">
			<div>

				<?php
				$posts = get_posts([
					'post_type' => 'lp_course',
					'post_status' => 'publish',
					'numberposts' => -1,
					'has_password'   => FALSE
					// 'order'    => 'ASC'
				]);

				$thumb_w = 450;
				$thumb_h = 180;

				$columns = 4;
				$hidden_author = "yes";

				$user_id = get_current_user_id();
				$user = learn_press_get_user($user_id);


				foreach ($posts as $post) { ?>
					<?php
					$course_id = $post->ID;
					$course_rate = '';
					$course      = learn_press_get_course($course_id);
					$enrolled = $user->has_enrolled_course($course_id);
					$finished = $user->has_finished_course($course_id);

					if (class_exists('LP_Addon_Course_Review')) {
						$course_rate = learn_press_get_course_rate($course_id);
					}
					?>
					<div class="lpr_course <?php echo 'course-grid-' . $columns; ?>">
						<div class="course-item">
							<div class="course-thumbnail">
								<a href="<?php echo esc_url(get_the_permalink($course_id)); ?>">
									<?php echo thim_get_feature_image(get_post_thumbnail_id($course_id), 'full', $thumb_w, $thumb_h, get_the_title($post)); ?>
								</a>

								<?php
								do_action('thim_inner_thumbnail_course');
								// only button read more
								do_action('thim-lp-course-button-read-more');
								?>
								
							</div>

							<div class="thim-course-content">
								<?php
								if ($hidden_author == 'no') {
									learn_press_courses_loop_item_instructor();
								}?>

								<h2 class="course-title"><a href="" rel="bookmark"><?= get_the_title($post) ?></a></h2>

								<?php if (class_exists('LP_Addon_Coming_Soon_Courses') && learn_press_is_coming_soon(get_the_ID())) : ?>
									<div class="message message-warning learn-press-message coming-soon-message">
										<?php esc_html_e('Coming soon', 'eduma') ?>
									</div>
								<?php else : ?>
									<div class="course-meta">
										<a class="button btn btn-primary" href="<?php echo esc_url(get_the_permalink($course_id)); ?>">
											
											<?php if($enrolled) :?>
												Continue
											<?php elseif($finished): ?>
												Certificate
											<?php else: ?>
												Enroll now
											<?php endif ?>
										</a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php
				}
				?>
			</div>
		</div>
	</div>
<?php endif; ?>