<?php
/**
 * Template for displaying instructor of course within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/loop/course/instructor.php.
 *
 * @author  ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course  = LP_Global::course();

$user_id = get_the_author_meta( 'ID' );
$user = learn_press_get_user( $user_id );

// profile url
$url =  "/our_team/" . $user->get_first_name();
if($user->get_last_name()){
	$url .= "-" . $user->get_last_name();
}
$url = strtolower($url);
?>

<div class="course-author" itemscope itemtype="http://schema.org/Person">
	<?php echo get_avatar( $user_id, 50 ); ?>
	<div class="author-contain">
		<div class="value" itemprop="name">
			<a href="<?= esc_url($url) ?>"><?php echo $user->get_display_name() ?></a>
			<?php
			/* if($course){
				echo $course->get_instructor_html();
			} */
			?>
		</div>
	</div>
</div>