<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$user = LP_Global::user();

$theme_options_data         = get_theme_mods();
$course_item_excerpt_length = intval( get_theme_mod( 'thim_learnpress_excerpt_length', 25 ) );


$class = isset( $theme_options_data['thim_learnpress_cate_grid_column'] ) && $theme_options_data['thim_learnpress_cate_grid_column'] ? 'course-grid-' . $theme_options_data['thim_learnpress_cate_grid_column'] : 'course-grid-3';
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$class .= ' lpr_course';

// edit by tuanta
$thim_show_course_meta = apply_filters( 'thim_show_course_meta', true );
$cl_coming_soon        = '';
if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
	$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
	if ( $instance_addon->is_coming_soon( get_the_ID() ) ) {
		$thim_show_course_meta = false;
		$cl_coming_soon        = ' archive_coming_soon';
	}
}

?>

<div id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>

	<?php
	// @deprecated
	do_action( 'learn_press_before_courses_loop_item' );
	?>

	<div class="course-item">

		<?php
		// @since 4.0.0
		//do_action( 'learn-press/before-courses-loop-item' );
		?>

		<?php
		// @thim
		//do_action( 'thim_courses_loop_item_thumb' );


		$course                      = LP_Global::course();
		$course_thumbnail_dimensions = learn_press_get_course_thumbnail_dimensions();
		$with_thumbnail              = 412;
		$height_thumbnail            = 308;
		$course_id = $course->get_id();

		if ( $course ) {
			echo '<div class="course-thumbnail">';
			echo '<a class="thumb" href="' . esc_url( get_the_permalink( $course->get_id() ) ) . '" >';
			echo thim_get_feature_image( get_post_thumbnail_id( $course->get_id() ), 'full', $with_thumbnail, $height_thumbnail, $course->get_title() );
			if(get_theme_mod( 'thim_layout_content_page', 'normal' ) =='layout_style_2'){
				learn_press_courses_loop_item_price();
			}

			/* if ( $course_item_excerpt_length ): ?>
				<div class="course-description course-description-overlay ">
					<?php $course_duration_text = get_post_meta( $course_id, 'thim_course_duration', true ) ?>
					<?php if($course_duration_text != '') :?>
					<p>Time to complete: <br><?php echo $course_duration_text ?>
					</p>
					<?php endif; ?>
					<?php
					do_action( 'learn_press_before_course_content' );
					echo get_the_excerpt();
					do_action( 'learn_press_after_course_content' );
					?></p>
				</div>
			<?php endif; */

			echo '</a>';
			do_action( 'thim_inner_thumbnail_course' );

			// only button read more
			do_action ('thim-lp-course-button-read-more');
			 echo '</div>';
		}

		?>

		<div class="thim-course-content<?php echo $cl_coming_soon; ?>">
			<?php
			if ( get_theme_mod( 'thim_layout_content_page', 'normal' ) == 'layout_style_2' ) {
				echo list_item_course_cat( get_the_ID() );
				the_title( sprintf( '<h2 class="course-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			} else {
				learn_press_courses_loop_item_instructor();
				the_title( sprintf( '<h2 class="course-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			}
			?>
			<?php
			if ( $thim_show_course_meta ) {
				echo '<div class="course-meta">';
				//learn_press_courses_loop_item_instructor();
				thim_course_ratings();
				//learn_press_get_template( 'loop/course/students.php' );
				//thim_course_ratings_count();
				//learn_press_courses_loop_item_price();
				do_action( 'thim_single_course_payment' );
				if ( class_exists( 'LP_Addon_Wishlist' )) LP_Addon_Wishlist::instance()->wishlist_button();
				echo '</div>';
			} else {
				echo '<div class="message message-warning learn-press-message coming-soon-message">' . esc_html__( 'Coming soon', 'eduma' ) . '</div>';
			}

			//learn_press_courses_loop_item_price();

			if ( get_theme_mod( 'thim_layout_content_page', 'normal' ) == 'normal' ) {
				do_action( 'thim-lp-course-button-read-more' );
			}
			?>
		</div>

		<?php
		// @since 4.0.0
		//do_action( 'learn-press/after-courses-loop-item' );
		?>


<?php if ( has_excerpt() ): ?>
			<div class="course-info-overlay course-short-info" style="display : none;">
			 	<?php // learn_press_courses_loop_item_instructor(); ?>
					<div class="course-description">
						<?php
						do_action( 'learn_press_before_course_content' );
						echo get_the_excerpt();
						do_action( 'learn_press_after_course_content' );
						?>
					</div>
				
			</div>
	<?php endif; ?>

	</div>

	<?php
	// @deprecated
	do_action( 'learn_press_after_courses_loop_item' );
	?>
	

</div>