<?php
 
/**
 * Adds Foo_Widget widget.
 */
class LP_Widget_Course_Cta extends WP_Widget {
 
    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
            'course_cta', // Base ID
            'Course_CTA', // Name
            array( 'description' => __( 'A Foo Widget CTA', 'text_domain' ), ) // Args
        );
    }
 
    /**s
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {

		if(!is_single()) return;

		// hide cta if password protection
		if ( post_password_required() ) {
			//echo get_the_password_form(); // WPCS: XSS ok.
			return;
		}

		$course_id = get_queried_object_id();
		$course = learn_press_get_course( $course_id );

		if(!$course) return;



		echo '<div class="learn-press learn-press-4">';
        extract( $args );
        // $title = apply_filters( 'widget_title', $instance['title'] );
 
        echo $before_widget;
        /* if ( ! empty( $title ) ) {
            echo $before_title . $title . $after_title;
        } */


		//echo $course->get_title();

		//$user_id = get_current_user_id();
		//$user = learn_press_get_user($user_id);
		//$enrolled = $user->has_enrolled_course($id);
		//$finished = $user->has_finished_course($id);
		$media_intro = get_post_meta( $course_id, 'thim_course_media_intro', true );

		?>

		<div class="course-thumbnail">
			<?php if ( !empty( $media_intro ) ) { ?>
				<div class="media-intro">
					<?php
					if ( wp_oembed_get( $media_intro ) ) {
						echo '<div class="responsive-iframe">' . wp_oembed_get( $media_intro ) . '</div>';
					} else {
						echo str_replace(
							array( "<iframe", "</iframe>" ), array(
							'<div class="responsive-iframe"><iframe',
							"</iframe></div>"
						), do_shortcode( $media_intro )
						);
					}
				?>
				</div>
			<?php } else { ?>
				<div class="thumbnail-preview">
					<div class="thumbnail">
						<div class="centered">
							<?php echo $course->get_image( 'course_thumbnail' ); ?>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
		<div class="mobile-entry-title"><h2><?php echo $course->get_title(); ?></h2></div>
		<div class="course-payment">
		 	<?php do_action( 'thim_single_course_payment' ); ?>

			 <?php
				if ( class_exists( 'LP_Addon_Wishlist' ) && is_user_logged_in() ) {
					LP_Addon_Wishlist::instance()->wishlist_button( $course_id );
				}
			?>

		</div>

		<div class="thim-course-info">
			<h3 class="title"><?php echo esc_html__( 'Course Features', 'eduma' ) ?> </h3>

		<ul>
				<li class="lectures-feature">
					<i class="fa fa-files-o"></i>
					<span class="label"><?php esc_html_e( 'Webinar', 'eduma' ); ?></span>
					<span
						class="value">1</span>
				</li>
				<li class="quizzes-feature">
					<i class="fa fa-puzzle-piece"></i>
					<span class="label"><?php esc_html_e( 'Post-Test', 'eduma' ); ?></span>
					<span
						class="value"><?php echo $course->get_curriculum_items( 'lp_quiz' ) ? (count( $course->get_curriculum_items( 'lp_quiz' ) ) - 1) : 0; ?></span>
				</li>
				<?php if ( ! empty( $course_duration ) ): ?>
					<li class="duration-feature">
						<i class="fa fa-clock-o"></i>
						<span class="label"><?php esc_html_e( 'Duration', 'eduma' ); ?></span>
						<span
							class="value"><?php echo thim_get_post_translated_duration( $course_duration, esc_html__( 'Lifetime access', 'learnpress' ) ); ?></span>
					</li>
				<?php endif; ?>

				<?php if ( ! empty( $course_skill_level ) ): ?>
					<li class="skill-feature">
						<i class="fa fa-level-up"></i>

						<span class="label"><?php esc_html_e( 'Skill level', 'eduma' ); ?></span>
						<span class="value"><?php echo esc_html( $course_skill_level ); ?></span>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $course_language ) ): ?>
					<li class="language-feature">
						<i class="fa fa-language"></i>
						<span class="label"><?php esc_html_e( 'Language', 'eduma' ); ?></span>
						<span class="value"><?php echo esc_html( $course_language ); ?></span>
					</li>
				<?php endif; ?>
				<li class="students-feature">
					<i class="fa fa-users"></i>
					<span class="label"><?php esc_html_e( 'Students', 'eduma' ); ?></span>
					<?php $user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0; ?>
					<span class="value"><?php echo esc_html( $user_count ); ?></span>
				</li>
				<?php $course_ceu = get_post_meta( $course_id, 'thim_course_ceu', true ); ?>
				<?php if ( ! empty( $course_ceu ) ): ?>
					<li class="skill-feature">
						<i class="fa fa-level-up"></i>

						<span class="label"><?php esc_html_e( 'CEUs earned', 'eduma' ); ?></span>
						<span class="value"><?php echo esc_html( $course_ceu ); ?></span>
					</li>
				<?php endif; ?>
				<?php thim_course_certificate( $course_id ); ?>

				<?php $downloads =  lpd_get_files() ?>
				<li class="donwloads-feature">
					<i class="fa fa-file-download"></i>
					<span class="label"><?php esc_html_e( 'Course Materials', 'eduma' ); ?></span>
					<span
						class="value"><?php echo count( $downloads ) ? count( $downloads ) : 0; ?></span>
				</li>
			</ul>
		</div>
			<?php


		echo '</div>';

        echo $after_widget;
    }
 
    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'text_domain' );
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
         </p>
    <?php
    }
 
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
 
        return $instance;
    }
 
} // class Foo_Widget
 
?>