<?php

function learndo_scripts() {
    //wp_enqueue_style('eduma.min', get_stylesheet_directory_uri() . '/css/eduma.min.css', array(), filemtime(get_stylesheet_directory_uri() . '/css/eduma.min.css'), false);
    wp_enqueue_style('eduma.min', get_stylesheet_directory_uri() . '/assets/css/style.css', array(), '5.9.1_2', false);
    //wp_enqueue_script( 'script-name', get_stylesheet_directory_uri() . '/js/example.js', array(), '1.0.0', true );

}
add_action( 'wp_enqueue_scripts', 'learndo_scripts' );

// move coupon to bottom
remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );
add_action( 'woocommerce_after_checkout_form', 'woocommerce_checkout_coupon_form', 10 );


add_action('wp_enqueue_scripts', 'learndo_override_js', 1);
function learndo_override_js()
{
    //wp_dequeue_script('thim-custom-script');
    //wp_enqueue_script('thim-custom-script', get_stylesheet_directory_uri().'/assets/js/custom-script-v2.min.js', array('jquery'), '', true);
	wp_enqueue_script('thim-custom-script', get_stylesheet_directory_uri().'/assets/js/custom-script-v2.js', array('jquery'), '', true);
	wp_enqueue_script('thim-course-filter-v2', get_stylesheet_directory_uri().'/assets/js/thim-course-filter-v2.min.js', array('jquery'), '', true);
	//wp_enqueue_script('thim-course-filter-v2', get_stylesheet_directory_uri().'/assets/js/thim-course-filter-v2.js', array('jquery'), '', true);

	//wp_enqueue_script('smooth-scroll', get_stylesheet_directory_uri().'/assets/js/smooth_scroll.min.js', array('jquery'), '', true);

}

// Add js to header
add_action('wp_head', 'learndo_header_code');
function learndo_header_code(){
?>
<script type='text/javascript'>
window.__lo_site_id = 326098;

(function() {
var wa = document.createElement('script'); wa.type = 'text/javascript'; wa.async = true;
wa.src = 'https://d10lpsik1i8c69.cloudfront.net/w.js';
var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(wa, s);
 })();
</script>
<?php
};

// register widgets
require_once dirname( __FILE__ ) . '/inc/widgets/course-cta.php';

add_action(
	'widgets_init',
	function() {
		register_widget( 'LP_Widget_Course_Cta' );
	}
);

/**
 * Register our sidebars and widgetized areas.
 *
 */
function learndo_widgets_init() {

	register_sidebar( array(
		'name'          => 'Sticky side',
		'id'            => 'sticky_side',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	) );

	register_sidebar( array(
		'name'          => 'Chatbot',
		'id'            => 'chatbot',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	) );

	register_sidebar( array(
		'name'          => 'TopBanner',
		'id'            => 'topbanner',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	) );

}

function sticky_side() {
    echo '<div class="sticky-side">';
    dynamic_sidebar( 'sticky_side' );
    echo '</div>';
}
function chatbot() {
    echo '<div class="chatbot" style="display:none"><i class="close far fa fa-close" onClick="jQuery(\'.chatbot\').hide()"></i>';
    dynamic_sidebar( 'chatbot' );
    echo '</div>';
}

function topbanner() {
    dynamic_sidebar( 'topbanner' );
}
add_action( 'widgets_init', 'learndo_widgets_init' );
add_action( 'thim_end_wrapper_container', 'sticky_side' );
add_action( 'thim_end_wrapper_container', 'chatbot' );
add_action( 'learndo_topbanner', 'topbanner' );


add_action( 'learn-press/user-profile-account', 'learndo_user_name', 11 );


// sidbar profile 
function learndo_user_name(){
	$profile = LP_Profile::instance();
	$user    = $profile->get_user();
	echo '<div class="lp-profile-username">';
	echo $user->get_first_name() . ' ' . $user->get_last_name();
	echo '</div>';
}


// add related as cross sell
add_action( 'woocommerce_cart_collaterals', 'learndo_related_courses' );

/**
 * Display related courses
 */
if ( ! function_exists( 'learndo_related_courses' ) ) {
	function learndo_related_courses() {
		$related_courses    = thim_get_related_courses( 5 );
		$theme_options_data = get_theme_mods();
		$style_content      = isset( $theme_options_data['thim_layout_content_page'] ) ? $theme_options_data['thim_layout_content_page'] : 'normal';

		if ( $related_courses ) {
			$layout_grid = get_theme_mod( 'thim_learnpress_cate_layout_grid', '' );
			$cls_layout  = ( $layout_grid != '' && $layout_grid != 'layout_courses_1' ) ? ' cls_courses_2' : ' ';
			?>
			<div class="thim-ralated-course <?php echo $cls_layout; ?>">

				<?php if ( $style_content == 'new-1' ) { ?>
					<div class="sc_heading clone_title  text-left">
						<h2 class="title"><?php esc_html_e( 'You May Like', 'eduma' ); ?></h2>
						<div class="clone"><?php esc_html_e( 'You May Like', 'eduma' ); ?></div>
					</div>
				<?php } else { ?>
					<h3 class="related-title">
						<?php esc_html_e( 'You May Like', 'eduma' ); ?>
					</h3>
				<?php } ?>

				<div class="thim-course-grid">
					<div class="thim-carousel-wrapper" data-visible="3" data-itemtablet="2" data-itemmobile="1"
						 data-pagination="1">
						<?php foreach ( $related_courses as $course_item ) : ?>
							<?php
							$course                     = learn_press_get_course( $course_item->ID );
							$is_required                = $course->is_required_enroll();
							$course_des                 = get_post_meta( $course_item->ID, '_lp_coming_soon_msg', true );
							$course_item_excerpt_length = get_theme_mod( 'thim_learnpress_excerpt_length', 25 );
							$html_price                 = '';
							if ( $price = $course->get_price_html() ) {
								$origin_price = $course->get_origin_price_html();
								$sale_price   = $course->get_sale_price();
								$sale_price   = isset( $sale_price ) ? $sale_price : '';
								$class        = '';
								if ( $course->is_free() || ! $is_required ) {
									$class .= ' free-course';
									$price = esc_html__( 'Free', 'eduma' );
								}
								$html_price .= '<div class="course-price">';
								$html_price .= '<div class="value ' . $class . '">';
								if ( $sale_price ) {
									$html_price .= '<span class="course-origin-price">' . $origin_price . '</span>';
								}
								$html_price .= $price;
								$html_price .= '</div></div>';
							}

							?>
							<article class="lpr_course">
								<div class="course-item">
									<div class="course-thumbnail">
										<a class="thumb" href="<?php echo get_the_permalink( $course_item->ID ); ?>">
											<?php
											if ( $layout_grid != '' && $layout_grid != 'layout_courses_1' ) {
												echo thim_get_feature_image( get_post_thumbnail_id( $course_item->ID ), 'full', 500, 400, get_the_title( $course_item->ID ) );
											} else {
												echo thim_get_feature_image( get_post_thumbnail_id( $course_item->ID ), 'full', 450, 450, get_the_title( $course_item->ID ) );
											}
											if ( get_theme_mod( 'thim_layout_content_page', 'normal' ) == 'layout_style_2' ) {
												echo '<i class="lnr icon-arrow-right"></i>';
											}
											?>
										</a>
										<?php
										if ( class_exists( 'LP_Addon_Wishlist' ) && is_user_logged_in() ) {
											LP_Addon_Wishlist::instance()->wishlist_button( $course_item->ID );
										}
										?>

									</div>
									<div class="thim-course-content">
										<?php
										if ( get_theme_mod( 'thim_layout_content_page', 'normal' ) == 'layout_style_2' ) {
											echo $html_price;
											echo list_item_course_cat( get_the_ID() );
											?>
											<h2 class="course-title">
												<a rel="bookmark"
												   href="<?php echo get_the_permalink( $course_item->ID ); ?>"><?php echo esc_html( $course_item->post_title ); ?></a>
											</h2> <!-- .entry-header -->
											<div class="course-author">
												<?php echo get_avatar( $course_item->post_author, 50 ); ?>
												<div class="author-contain">
													<div class="value">
														<?php // profile url
															$user = learn_press_get_user( $course_item->post_author );
															$url =  "/our_team/" . $user->get_first_name();
															if($user->get_last_name()){
																$url .= "-" . $user->get_last_name();
															}
															$url = strtolower($url); ?>
														<a href="<?php echo esc_url( $url ); ?>">
															<?php echo get_the_author_meta( 'display_name', $course_item->post_author ); ?>
														</a>
													</div>
												</div>
											</div>
										<?php } else { ?>
											<div class="course-author">
												<?php echo get_avatar( $course_item->post_author, 50 ); ?>
												<div class="author-contain">
													<div class="value">
														<a href="<?php echo esc_url( learn_press_user_profile_link( $course_item->post_author ) ); ?>">
															<?php echo get_the_author_meta( 'display_name', $course_item->post_author ); ?>
														</a>
													</div>
												</div>
											</div>
											<h2 class="course-title">
												<a rel="bookmark"
												   href="<?php echo get_the_permalink( $course_item->ID ); ?>"><?php echo esc_html( $course_item->post_title ); ?></a>
											</h2> <!-- .entry-header -->
										<?php } ?>
										<?php if ( class_exists( 'LP_Addon_Coming_Soon_Courses_Preload' ) && learn_press_is_coming_soon( $course_item->ID ) ): ?>
											<?php if ( intval( $course_item_excerpt_length ) && $course_des ): ?>
												<div class="course-description">
													<?php echo wp_trim_words( $course_des, $course_item_excerpt_length ); ?>
												</div>
											<?php endif; ?>

											<div
												class="message message-warning learn-press-message coming-soon-message">
												<?php esc_html_e( 'Coming soon', 'eduma' ) ?>
											</div>
										<?php else: ?>
											<div class="course-meta">
												<?php
												$count_student = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0;
												?>
												<div class="course-students">
													<label><?php esc_html_e( 'Students', 'eduma' ); ?></label>
													<?php do_action( 'learn_press_begin_course_students' ); ?>

													<div class="value"><i class="fa fa-group"></i>
														<?php echo esc_html( $count_student ); ?>
													</div>
													<?php do_action( 'learn_press_end_course_students' ); ?>

												</div>
												<?php thim_course_ratings_count( $course_item->ID ); ?>
												<?php
												if ( get_theme_mod( 'thim_layout_content_page', 'normal' ) == 'layout_style_2' ) {
													thim_course_ratings();
												} else {
													echo $html_price;
												} ?>
											</div>

										<?php endif; ?>
									</div>
								</div>
							</article>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
			<?php
		}
	}
}


// add cusom field for course
if ( ! function_exists( 'learndo_add_custom_field_course' ) ) {
	function learndo_add_custom_field_course() {
		lp_meta_box_text_input_field(
			array(
				'id'          => 'thim_course_ceu',
				'label'       => esc_html__( 'CEU', 'eduma' ),
				'description' => esc_html__( 'Display CEU', 'eduma' ),
				'default'     => ''
			)
		);
	}
}

add_action( 'learnpress/course-settings/after-general', 'learndo_add_custom_field_course' );

function learndo_save_meta_box( $post_id ) {
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if ( $parent_id = wp_is_post_revision( $post_id ) ) {
        $post_id = $parent_id;
    }
    $fields = [
        'thim_course_ceu'
    ];
    foreach ( $fields as $field ) {
        if ( array_key_exists( $field, $_POST ) ) {
            update_post_meta( $post_id, $field, sanitize_text_field( $_POST[$field] ) );
        }
     }
}
add_action( 'save_post', 'learndo_save_meta_box' );

// ---  DISABLE SEND WELCOME MAIL
function xx_disable_new_user_notifications() {
	//Remove original use created emails
	remove_action( 'register_new_user', 'wp_send_new_user_notifications' );
	remove_action( 'edit_user_created_user', 'wp_send_new_user_notifications', 10, 2 );
	remove_action( 'send_password_change_email', 'wp_send_new_user_notifications', 10, 2 );
	
}
add_action( 'init', 'xx_disable_new_user_notifications' );
add_filter( 'send_password_change_email', '__return_false' );

// disable admin notification of new users
add_filter( 'wp_send_new_user_notification_to_admin', '__return_false' ); 

// custom welcome mail
add_filter(
	'wp_new_user_notification_email',
	'learndo_newuser_email',
	9999999,
	2
);

function learndo_newuser_email ($objectEmail = array(), $user = ""){
	$key = get_password_reset_key( $user );
	$objectEmail['message'] = learndo_welcome_email_message("", $key,  $user->user_login, $user);
}

// TODO enable disable in backend
add_filter( 'retrieve_password_message', 'learndo_welcome_email_message', 9999999, 4 );

	 use MailPoet\Config\Renderer;

	function learndo_welcome_email_message ($message, $key, $user_login, $user_data){
		//$key = get_password_reset_key( $user );

		$reset_link = add_query_arg(
			array(
				'action' => 'rp',
				'key'    => $key,
				'login'  => rawurlencode( $user_login )
			), thim_get_login_page_url()
		);
		$loginUrl = get_bloginfo('url') . "/login";
		$username  = $user_login;

		$user = get_user_by( 'login', $user_login );
		$user_id = $user->ID;
		update_user_meta( $user_id, 'welcome_not_send', 0 );

		$message = '
		<!-- Welcome to Learn.Do by Psyched Services! We are so excited for you to experience what our Learn.Do subscription has to offer. Follow the steps below to get started now! -->
		<table border="0" width="100%" cellspacing="0" cellpadding="0" bgcolor="#ffffff">
		<tbody>
		<tr>
		<td class="container-outer" style="padding: 30px 0 30px 0;" align="center" valign="top"><!-- Container 700px -->
		<table class="container" style="width: 700px;" border="0" width="700" cellspacing="0" cellpadding="0" bgcolor="#ffffff">
		<tbody>
		<tr>
		<td><!-- Container 700px -->
		<table class="container" style="width: 700px;" border="0" width="700" cellspacing="0" cellpadding="0" align="center">
		<tbody>
		<tr>
		<td><a href="https://learndo.psychedservices.com">
		<img class="size-medium wp-image-567 alignleft" src="https://learndo.psychedservices.com/wp-content/uploads/2022/02/learn.do_SubBrand_Logo_small-300x82.png" alt="" width="250" height="68" />
		</a></td>
		</tr>
		</tbody>
		</table>
		<!-- Container 700px End -->
		
		<!-- Container 700px -->
		<table class="container" style="width: 700px;" border="0" width="700" cellspacing="0" cellpadding="0" align="center">
		<tbody>
		<tr>
		<td class="header-title" style="padding: 10px 0 10px 0; font-weight: bold; font-size: 100px; line-height: 100px; font-family: \'Noto sans\', sans-serif; text-align: center; color: #24586a;">WELCOME!</td>
		</tr>
		<tr>
		<td class="header-divider" style="padding-bottom: 20px; text-align: left;"><img class="alignnone wp-image-2459" src="https://learndo.psychedservices.com/wp-content/uploads/2023/03/Learn.Do_welcome_header.png" alt="" width="700" height="180" /></td>
		</tr>
		<tr>
		<td class="header-welcome" style="padding: 0 50px 30px 50px; font-size: 20px; letter-spacing: 2px; line-height: 32px; font-weight: normal; text-align: center; color: #24586a; font-family: \'Noto sans\', sans-serif;">Welcome to Learn.Do by Psyched Services! We are so excited for you to experience what our Learn.Do subscription has to offer. Follow the steps below to get started now!</td>
		</tr>
		</tbody>
		</table>
		<!-- Container 700px End -->
		
		<!-- Container 700px -->
		<table class="container" style="width: 700px; background: #A4C9D7;" border="0" width="700" cellspacing="0" cellpadding="0" align="center">
		<tbody>
		<tr>
		<td>
		<table class="container" style="width: 350px;" border="0" width="350" cellspacing="0" cellpadding="0" align="left">
		<tbody>
		<tr>
		<td class="sub-title" style="font-size: 27px; letter-spacing: 0.02em; font-weight: bold; text-align: left; color: #24586a; font-family: \'Noto sans\', sans-serif; padding: 20px 20px 20px 30px;">WHERE TO START</td>
		</tr>
		<tr>
		<td style="font-size: 16px; font-weight: normal; letter-spacing: 1px; text-align: left; color: #24586a; font-family: \'Noto sans\', sans-serif; padding: 0 0 0 30px;">
		<ul style="margin: 0; padding: 0 0 0 20px;">
			 <li style="margin-bottom: 8px;">Your username is: ' . $username . '</li>
			 <li style="margin-bottom: 8px;">Click on the link to set your password: '.$reset_link .'</li>
			 <li style="margin-bottom: 8px;">Login to learndo.psychedservices.com
		with your username and password.</li>
			 <li style="margin-bottom: 8px;">Once logged in you can access all Learn.Do content via the Dashboard.</li>
		</ul>
		</td>
		</tr>
		<tr>
		<td class="article-button" style="padding: 30px 0 30px 30px;">
		<table style="width: 290px; text-align: center;" border="0" width="290" cellspacing="0" cellpadding="0" align="left">
		<tbody>
		<tr>
		<td style="padding: 0;"><a style="text-decoration: none; background-color: #247996; color: #ffffff; font-weight: bold; font-family: \'Noto sans\', sans-serif; text-transform: uppercase; font-size: 18px; padding: 10px 50px; letter-spacing: 0.1em;" href="https://learndo.psychedservices.com/faqs">NEED HELP?</a></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<table class="container" style="width: 340px;" border="0" width="340" cellspacing="0" cellpadding="0" align="right">
		<tbody>
		<tr>
		<td class="article-thumb"><img class="alignnone size-full wp-image-2460" style="margin-top: -40px;" src="https://learndo.psychedservices.com/wp-content/uploads/2023/03/Learn.Do_welcome_image.png" alt="" width="340" height="362" /></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<!-- Container 700px End -->
		
		<a style="text-decoration: none; color: #24586a; font-weight: bold; font-family: \'Noto sans\', sans-serif; text-transform: uppercase; font-size: 20px; padding: 30px; letter-spacing: 0.1em;" href="https://learndo.psychedservices.com/faqs">Visit our FAQ\'s</a></td>
		</tr>
		</tbody>
		</table>
		<!-- Container 700px End --></td>
		</tr>
		</tbody>
		</table>
		<!-- Wrapper 100% End -->
		';
		$message .= bnfw_shortcode_email_css();
		return $message;


	}

	function bnfw_shortcode_password_link($atts = array(), $content = null, $tag = '') {
		if($content == "[email_user_id]" || $content == null ) return "[password_link]";

		$user = get_userdata(  $content );
		$key = get_password_reset_key( $user );
		$set_password_link = thim_get_login_page_url() . "?action=rp&key=$key&login=" . rawurlencode( $user->user_login );
		return $set_password_link;
	}
	add_shortcode( 'password_link', 'bnfw_shortcode_password_link' );

	function bnfw_shortcode_email_css() {
		$css = '
		<style type="text/css">
		/* ----- Reset ----- */
		html,
		body{
		margin: 0 !important;
		padding: 0 !important;
		height: 100% !important;
		width: 100% !important;
		font-family: "Martel", sans-serif;
		}
		
		*{
		-ms-text-size-adjust: 100%;
		-webkit-text-size-adjust: 100%;
		}
		
		div[style*="margin: 16px 0"]{
		margin: 0 !important;
		}
		
		table,
		td{
		mso-table-lspace: 0pt !important;
		mso-table-rspace: 0pt !important;
		}
		
		table{
		border-spacing: 0 !important;
		border-collapse: collapse !important;
		table-layout: fixed !important;
		margin: 0 auto !important;
		}
		
		table table table{
		table-layout: auto;
		}
		
		img{
		-ms-interpolation-mode: bicubic;
		}
		
		.yshortcuts a{
		border-bottom: none !important;
		}
		
		.mobile-link--footer a,
		a[x-apple-data-detectors]{
		color:inherit !important;
		text-decoration: underline !important;
		}
		
		@media (max-width: 700px){
		/* ----- Grid ----- */
		.container{
		width: 100% !important;
		}
		
		.container-outer{
		padding: 0 !important;
		}
		
		/* ----- Header ----- */
		.logo{
		float: none;
		text-align: center;
		}
		
		.header-title{
		text-align: center !important;
		font-size: 32px !important;
		}
		
		.header-divider{
		padding-bottom: 60px !important;
		text-align: center !important;
		}
		
		/* ----- Article ----- */
		.article-thumb,
		.article-title,
		.article-content,
		.article-button{
		text-align: center !important;
		padding-left: 15px !important;
		}
		
		.article-thumb{
		padding: 30px 0 15px 0 !important;
		}
		
		.article-title{
		padding: 0 0 15px 0 !important;
		}
		
		.article-content{
		padding: 0 15px 0 15px !important;
		}
		
		.article-button{
		padding: 20px 0 0 0 !important;
		}
		
		.article-button &gt; table{
		float: none;
		}
		
		/* ----- Footer ----- */
		.footer-copy{
		text-align: center !important;
		}
		
		.social{
		padding: 10px 0 0 0 !important;
		}
		
		.social &gt; table{
		float: none;
		}
		}"; </style>';

		return $css;
	}
	add_shortcode( 'email_css', 'bnfw_shortcode_email_css' );

	/* add_filter( 'wp_mail', function( $args ) {
			$args['message'] = do_shortcode( $args['message'] );
			return $args;
	}, 1, 1 ); */

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary_second' => esc_html__( 'Primary Menu Second', 'leardo' ),
			)
		);

remove_action( 'woocommerce_single_product_summary_quick', 'woocommerce_template_single_rating', 15 );
//add_action( 'woocommerce_single_product_summary_quick', 'woocommerce_template_single_rating', 60 );


remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 60 );


// REDIRECTS

function redirect_to_dashbord_function() {
	if(is_admin()) return;
	if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) return;
	if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) return;
	if ( !is_user_logged_in() ) return;

	return ( header("Location: " . get_bloginfo('url') . "/dashboard")) ;
}

add_shortcode('redirect-dashboard', 'redirect_to_dashbord_function');

function redirect_to_welcome_function() {
	// Gate keeper
	if(is_admin()) return;
	if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) return;
	if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) return;
	if ( !is_user_logged_in() ) return;

	return ( header("Location: " . get_bloginfo('url') . "/welcome")) ;
}

add_shortcode('redirect-welcome', 'redirect_to_welcome_function');

// redirect after register
add_filter( 'registration_redirect', 'user_register_redirect' );
function user_register_redirect( $registration_redirect ) {
	return get_bloginfo('url') . "/welcome";
}

function redirect_if_not_registered_function() {
	// Gate keeper
	if(is_admin()) return;
	if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) return;
	if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) return;
	if ( is_user_logged_in() ) return;

	return ( header("Location: " . get_bloginfo('url') . "/register")) ;
}

add_shortcode('redirect-if-not-registered', 'redirect_if_not_registered_function');



define( 'LERNDO_DIR', __FILE__ );

function learndo_register_form_function() {
	require_once('inc/user/tpl/register.php');
}

add_shortcode('learndo_register_form', 'learndo_register_form_function');


//add_filter('wc_price', 'pmpro_hide_price', 10 , 4);
function pmpro_hide_price($return, $price, $args, $unformatted_price){
	$isMember = pmpro_hasMembershipLevel();
	//if($isMember) return '';

	if($unformatted_price <= 0 && $isMember) return '';

	return $return;
}

add_filter('woocommerce_loop_add_to_cart_link', 'pmpro_hide_addtocart', 10, 3);
function pmpro_hide_addtocart($return, $product, $args){
	//$isMember = pmpro_hasMembershipLevel();
	//if($isMember){
	//}
		$downloads = get_user_product_downloads($product);
		if(empty($downloads)) return $return;
		if(get_current_user_id() == 0 ) return $return;
		
		$download_link = "<div class='downloads'>";
		foreach ($downloads as $download) {
				$download_link .= "<a href=" . esc_url($download['download_url']) . " class='wpdm-download-link download-on-click btn btn-primary'>Download</a>";
		}
		$download_link .= "</div>";

		return $download_link;

}

//add_filter('woocommerce_widget_cart_is_hidden', 'pmpro_hide_minicart');
function pmpro_hide_minicart(){
	$isMember = pmpro_hasMembershipLevel();
	if($isMember){ 
		return true; 
	}

	return false;
}


function wpa_overwrite_translation( $translated, $original, $textdomain ) {
	// For plugins and themes check for textdomain
	if( 'learnpress' === $textdomain ) {
		if( 'Your are logged in as %1$s. <a href="%2$s">Log out</a>?' == $translated ) {
			$translated = 'You are logged in as %1$s. <a href="%2$s">Log out</a>?';
		}
	}

	// For WordPress core just omit the textdomain check
	if( 'Exact text you wish to overwrite in WordPress core' == $translated ) {
		$translated = 'New text';
	}

	return $translated;
}

add_filter( 'gettext', 'wpa_overwrite_translation', 10, 3 );

// Custom finish course page
	function learnpress_finish_page($redirect, $course_id){

		// create the certificate here to be ready on the finished page
		if (class_exists('LP_Certificate')) {
			$user   = LP_Global::user();
			$course = learn_press_get_course($course_id);
			$cert_id = get_post_meta( $course->get_id(), '_lp_cert', true );
			$certificate = new LP_User_Certificate( $user->get_id(), $course->get_id(), $cert_id );
			$can_get_cert = LP_Certificate::can_get_certificate( $course->get_id(), $user->get_id() );
			$link_cert = $certificate->get_sharable_permalink();
		}
		return home_url('/completed-course?id=') . $course_id;
	}
	
	add_action( 'learn-press/finish-course-redirect', 'learnpress_finish_page', 10, 2 );
	
	// display the certificate and course rating
	add_shortcode('lp_course_certificate', 'lp_course_certificate_function');
	
	function lp_course_certificate_function(){
		if (!class_exists('LP_Certificate')) {
			return '';
		}

		$course_id = get_query_var('id');
		if ( get_query_var('id') ) {
			$user   = LP_Global::user();
			$course = learn_press_get_course($course_id);
			$cert_id = get_post_meta( $course->get_id(), '_lp_cert', true );
			$certificate = new LP_User_Certificate( $user->get_id(), $course->get_id(), $cert_id );
			$can_get_cert = LP_Certificate::can_get_certificate( $course->get_id(), $user->get_id() );
			$link_cert = $certificate->get_sharable_permalink();
	
			if ( $can_get_cert['flag'] ) {
				echo '<a class="lp-button" target="_blank" href="'. $link_cert .'" >Download Certificate</a>';
				//learn_press_certificate_get_template( 'view-button.php', array( 'certificate' => $certificate ) );
			} elseif ( ! $can_get_cert['flag'] && $can_get_cert['reason'] == 'not_buy' ) {
				learn_press_certificate_buy_button( $course );
			}
	
		}
	}

	add_shortcode('lp_course_complete_title', 'lp_course_complete_title_function');
	function lp_course_complete_title_function(){
		$course_id = get_query_var('id');
		if(!$course_id) return '';
		$course = learn_press_get_course($course_id);
		return $course->get_title();
	}

	add_shortcode('lp_course_review_link', 'lp_course_review_link_function');
	function lp_course_review_link_function(){
		$course_id = get_query_var('id');
		if(!$course_id) return '';

	 	return get_the_permalink($course_id) . '#leave-review';
	}

	function redirect_if_not_finished_function() {
		// Gate keeper
		if(is_admin()) return;
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) return;
		if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) return;

		$course_id = get_query_var('id');
		if(!$course_id){
			return ( header("Location: " . get_bloginfo('url') )) ;
		}

		$user   = LP_Global::user();
		$course = learn_press_get_course($course_id);
		
		$can_get_cert = LP_Certificate::can_get_certificate( $course->get_id(), $user->get_id() );
		if ( $can_get_cert['flag'] ) {
			return;
		}

		// else redirect to the course page
		return ( header("Location: " . get_the_permalink($course_id) )) ;
	}
	
	add_shortcode('redirect_if_not_finished', 'redirect_if_not_finished_function');



	remove_filter('get_the_excerpt', 'wp_trim_excerpt');

	add_action( 'add_meta_boxes', array ( 'T5_Richtext_Excerpt', 'switch_boxes' ) );

/**
 * Replaces the default excerpt editor with TinyMCE.
 */
class T5_Richtext_Excerpt
{
    /**
     * Replaces the meta boxes.
     *
     * @return void
     */
    public static function switch_boxes()
    {
        if ( ! post_type_supports( $GLOBALS['post']->post_type, 'excerpt' ) )
        {
            return;
        }

		if( get_post_type() == 'product' )  return; 

        remove_meta_box(
            'postexcerpt' // ID
        ,   ''            // Screen, empty to support all post types
        ,   'normal'      // Context
        );

        add_meta_box(
            'postexcerpt2'     // Reusing just 'postexcerpt' doesn't work.
        ,   __( 'Excerpt' )    // Title
        ,   array ( __CLASS__, 'show' ) // Display function
        ,   null              // Screen, we use all screens with meta boxes.
        ,   'normal'          // Context
        ,   'core'            // Priority
        );
    }

    /**
     * Output for the meta box.
     *
     * @param  object $post
     * @return void
     */
    public static function show( $post )
    {
    ?>
        <label class="screen-reader-text" for="excerpt"><?php
        _e( 'Excerpt' )
        ?></label>
        <?php
        // We use the default name, 'excerpt', so we don’t have to care about
        // saving, other filters etc.
        wp_editor(
            self::unescape( $post->post_excerpt ),
            'excerpt',
            array (
            'textarea_rows' => 15
        ,   'media_buttons' => FALSE
        ,   'teeny'         => FALSE
        ,   'tinymce'       => TRUE
            )
        );
    }

    /**
     * The excerpt is escaped usually. This breaks the HTML editor.
     *
     * @param  string $str
     * @return string
     */
    public static function unescape( $str )
    {
        return str_replace(
            array ( '&lt;', '&gt;', '&quot;', '&amp;', '&nbsp;', '&amp;nbsp;' )
        ,   array ( '<',    '>',    '"',      '&',     ' ', ' ' )
        ,   $str
        );
    }
}

### DISABLE PLUGIN UPDATES, if update contact melvin.m@getfriday.com / makewebbetter
function AS_disable_plugin_updates( $value ) {
	//create an array of plugins you want to exclude from updates ( string composed by folder/main_file.php)
	 $pluginsNotUpdatable = [
	  'makewebbetter-hubspot-for-woocommerce/makewebbetter-hubspot-for-woocommerce.php',
	  'hubspot-integration-customization/hubspot-integration-customization.php',
	  'leadin/leadin.php'
	];
  
	if ( isset($value) && is_object($value) ) {
	  foreach ($pluginsNotUpdatable as $plugin) {
		  if ( isset( $value->response[$plugin] ) ) {
			  unset( $value->response[$plugin] );
		  }
		}
	}
	return $value;
  }
  add_filter( 'site_transient_update_plugins', 'AS_disable_plugin_updates' );


// Popup template

if ( class_exists( 'WPPopups_Template', false ) ) :
	/**
	 * Elegant Popup
	 * Template for WPPopups.
	 */
	class WPPopups_Template_elegant_popup extends WPPopups_Template {
	
		/**
		 * Primary class constructor.
		 *
		 * @since 2.0.0
		 */
		public function init() {
	
			// Template name
			$this->name = 'LearnDo Popup';
	
			// Template slug
			$this->slug = 'learndo_popup';
			
			// Template description
			$this->description = 'Basic LearnDo Popup';
	
			// Template field and settings
			$this->data = array (
				'field_id' => 1,
				'content' => array (
					'popup_content' => '<a href="https://learndo.psychedservices.com/online-training/special-considerations-for-maximizing-student-success-supporting-self-advocacy/"><img class="alignleft wp-image-3953" src="https://learndo.loc/wp-content/uploads/2024/03/Course-Stock-Photo_-Self-Advocacy-500x300-1-300x180.jpg" alt="" width="236" height="142" /></a>
			<h4>New Course Alert</h4>
			Special Considerations for Maximizing Student Success: Supporting Self-Advocacy

			<a class="btn" href="https://learndo.psychedservices.com/online-training/special-considerations-for-maximizing-student-success-supporting-self-advocacy/">Register Now</a>',
				),
				'position' => array (
					'position' => 'centered',
				),
				'animation' => array (
					'animation' => 'fade',
				),
				'popup_box' => array (
					'width' => '650px',
					'padding' => '30',
					'radius' => '10',
					'auto_height' => 'yes',
					'height' => '350px',
				),
				'colors' => array (
					'show_overlay' => 'yes-color',
					'overlay_color' => 'rgba(0,0,0,0.5)',
					'overlay_blur' => '2',
					'bg_color' => 'rgb(255, 255, 255)',
					'bg_img' => '',
					'bg_img_repeat' => 'no-repeat',
					'bg_img_size' => 'auto',
				),
				'border' => array (
					'border_type' => 'none',
					'border_color' => '#000',
					'border_width' => '3',
					'border_radius' => '10',
					'border_margin' => '0',
				),
				'shadow' => array (
					'shadow_color' => '#ccc',
					'shadow_type' => 'outset',
					'shadow_x_offset' => '0',
					'shadow_y_offset' => '0',
					'shadow_blur' => '0',
					'shadow_spread' => '0',
				),
				'close' => array (
					'close_color' => 'rgb(208, 208, 208)',
					'close_hover_color' => 'rgb(180, 212, 59)',
					'close_shadow_color' => 'rgba(255, 255, 255, 0)',
					'close_size' => '30',
					'close_position' => 'top_right',
				),
				'css' => array (
					'custom_css' => '',
				),
				'global_rules' => array (
					'group_0' => array (
						'rule_0' => array (
							'rule' => 'page_type',
							'operator' => '==',
							'value' => 'all_pages',
						),
					),
				),
			);
				}
			}
			new WPPopups_Template_elegant_popup;
			endif;