<?php

/**
 * The template part for displaying results in search pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package thim
 */
?>

<?php
$theme_options_data = get_theme_mods();

$classes   = array();
$classes[] = 'col-sm-12 lpr_course';

$thumb_w    = (!empty($instance['thumbnail_width']) && '' != $instance['thumbnail_width']) ? $instance['thumbnail_width'] : apply_filters('thim_course_thumbnail_width', 450);
$thumb_h    = (!empty($instance['thumbnail_height']) && '' != $instance['thumbnail_height']) ? $instance['thumbnail_height'] : apply_filters('thim_course_thumbnail_height', 400);


?>

<?php //echo get_post_type() 
?>
<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>
	<div class="course-item">

		<div class="course-thumbnail">
			<a href="<?php echo esc_url(get_the_permalink(get_the_ID())); ?>">
				<?php echo thim_get_feature_image(get_post_thumbnail_id(get_the_ID()), 'full', $thumb_w, $thumb_h, get_the_title()); ?>
			</a>
			<?php do_action('thim_inner_thumbnail_course');
			// only button read more
			do_action('thim-lp-course-button-read-more');
			?>
		</div>

		<div class="thim-course-content">
			<?php the_title(sprintf('<h2 class="course-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h2>'); ?>

			<?php if (get_post_type() == 'product') : ?>

				<div class="entry-summary">
					<?php
					the_excerpt();
					?>
					<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html__('Read More', 'eduma'); ?></a>

				</div><!-- .entry-summary -->

				<div class="course-meta product__title">
					<?php $product = wc_get_product(get_the_ID()); ?>
					<div class="course-price">
						<div class="value">
							<?php do_action('woocommerce_after_shop_loop_item_title'); ?>
						</div>
					</div>
					<div class="lp-course-buttons">
						<div class="wrap-btn-add-course-to-cart">
							<?php do_action('woocommerce_after_shop_loop_item'); ?>
						</div>
					</div>
				</div>

			<?php elseif (get_post_type() == 'lp_course') : ?>
				<div class="course-meta">
					<?php learn_press_courses_loop_item_instructor(); ?>
					<?php thim_course_ratings(); ?>
					<?php learn_press_get_template('loop/course/students.php'); ?>
					<?php thim_course_ratings_count(); ?>
					<?php //learn_press_courses_loop_item_price(); 
					?>
					<?php do_action('thim_single_course_payment');
					if (class_exists('LP_Addon_Wishlist')) LP_Addon_Wishlist::instance()->wishlist_button(); ?>
				</div>
			<?php else : ?>

				<div class="entry-summary">
					<?php
					the_excerpt();
					?>
					<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html__('Read More', 'eduma'); ?></a>

				</div><!-- .entry-summary -->

			<?php endif; ?>
		</div>

		<?php /*
		do_action( 'thim_entry_top', 'full' ); ?>
		<div class="entry-content">
			<?php
			if ( has_post_format( 'link' ) && thim_meta( 'thim_url' ) && thim_meta( 'thim_text' ) ) {
				$url  = thim_meta( 'thim_url' );
				$text = thim_meta( 'thim_text' );
				if ( $url && $text ) { ?>
					<header class="entry-header">
						<h3 class="entry-title">
							<a class="link" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $text ); ?></a>
						</h3>
					</header>

					<?php
				}
				?>
				<div class="entry-summary">
					<?php
					the_excerpt();
					?>
				</div><!-- .entry-summary -->
				<div class="readmore">
					<a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__('Read More','eduma'); ?></a>
				</div>
			<?php } elseif ( has_post_format( 'quote' ) && thim_meta( 'thim_quote' ) && thim_meta( 'thim_author_url' ) ) {
				$quote      = thim_meta( 'thim_quote' );
				$author     = thim_meta( 'thim_author' );
				$author_url = thim_meta( 'thim_author_url' );
				if ( $author_url ) {
					$author = ' <a href=' . esc_url( $author_url ) . '>' . $author . '</a>';
				}
				if ( $quote && $author ) {
					?>
					<header class="entry-header">
						<div class="box-header box-quote">
							<blockquote><?php echo esc_html( $quote ); ?><cite><?php echo esc_html( $author ); ?></cite>
							</blockquote>
						</div>
					</header>
					<?php
				}
			} elseif ( has_post_format( 'audio' ) ) {
				?>
				<header class="entry-header">
					<div class="entry-contain">
						<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
						<?php //thim_entry_meta(); ?>
					</div>
				</header>
				<div class="entry-summary">
					<?php
					the_excerpt();
					?>
				</div><!-- .entry-summary -->
				<div class="readmore">
					<a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__('Read More','eduma'); ?></a>
				</div>
				<?php
		} elseif ( has_post_format( 'product' ) ) {  echo get_post_type(); ?>
			product
		<?php } elseif ( has_post_format( 'course' ) ) {

		} else {
				?>
				<header class="entry-header">

					<div class="">
						<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
						<?php //thim_entry_meta(); ?>
					</div>
				</header>
				<!-- .entry-header -->
				<div class="entry-summary">
					<?php
					the_excerpt();
					?>
				</div><!-- .entry-summary -->
				<div class="readmore">
					<a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__('Read More','eduma'); ?></a>
				</div>
			<?php }; ?>
		</div>
	</div> */ ?>
</article><!-- #post-## -->