<?php
/*
Plugin Name: WP Terms Popup Collector
Plugin URI: https://termsplugin.com
Description: Gather data about your WP Terms Popups with Collector.
Version: 1.8.0
Author: Link Software LLC
Author URI: https://linksoftwarellc.com
Domain Path: /languages
*/

define('WP_TERMS_POPUP_COLLECTOR_NAME', 'wp-terms-popup-collector');
define('WPTPC_VERSION', '1.8.0');
define('WPTPC_FILE', __FILE__);
define('WPTPC_STORE_URL', 'https://termsplugin.com');
define('WPTPC_STORE_PRODUCT', 'WP Terms Popup Collector');
define('WPTPC_STORE_PRODUCT_ID', 1208);

require_once 'inc/wptp-collector-licensing.php';
require_once 'inc/wptp-collector-activation.php';
require_once 'inc/wptp-collector-updates.php';
require_once 'inc/wptp-collector-settings.php';
require_once 'inc/wptp-collector-columns.php';
require_once 'inc/wptp-collector-functions.php';

register_activation_hook(__FILE__, 'wptp_collector_activation');

function wptp_collector_activation_warning()
{
    ?>
    <div class="notice notice-error is-dismissible">
        <p>WP Terms Popup Collector requires the <a href="https://wordpress.org/plugins/wp-terms-popup/">latest free version of WP Terms Popup</a> to be installed and activated. You must have both plugins installed and active at the same time for it to work properly!</p>
    </div>
    <?php
}

function wptp_collector_check_free()
{
    if (!function_exists('is_plugin_inactive')) {
        require_once ABSPATH.'/wp-admin/includes/plugin.php';
    }

    if (is_plugin_inactive('wp-terms-popup/index.php') && is_plugin_inactive('wp-terms-popup/wp-terms-popup.php')) {
        add_action('admin_notices', 'wptp_collector_activation_warning');

        return;
    }
}
add_action('plugins_loaded', 'wptp_collector_check_free');

function wptp_collector_scripts()
{
    wp_register_script('wptp-collector-datatables', plugins_url('wp-terms-popup-collector/assets/js/datatables.min.js'), ['jquery'], WPTPC_VERSION);
    wp_enqueue_script('wptp-collector-datatables');

    wp_register_script('wptp-collector-datatables-fixedColumns', plugins_url('wp-terms-popup-collector/assets/js/fixedColumns.min.js'), ['jquery'], WPTPC_VERSION);
    wp_enqueue_script('wptp-collector-datatables-fixedColumns');

    wp_register_script('wptp-collector-js', plugins_url('wp-terms-popup-collector/assets/js/wptp-collector.js'), ['jquery'], WPTPC_VERSION);
    wp_enqueue_script('wptp-collector-js');

    wp_register_style('wptp-collector-css-datatables', plugins_url('wp-terms-popup-collector/assets/css/datatables.min.css'), WPTPC_VERSION);
    wp_enqueue_style('wptp-collector-css-datatables');

    wp_register_style('wptp-collector-css-datatables-fixedColumns', plugins_url('wp-terms-popup-collector/assets/css/dataTables.fixedColumns.min.css'), [], WPTPC_VERSION);
    wp_enqueue_style('wptp-collector-css-datatables-fixedColumns');

    wp_register_style('wptp-collector-css', plugins_url('wp-terms-popup-collector/assets/css/wptp-collector.css'), [], WPTPC_VERSION);
    wp_enqueue_style('wptp-collector-css');
}
add_action('admin_enqueue_scripts', 'wptp_collector_scripts', 1);

function wptp_collector_textdomain()
{
    load_plugin_textdomain(WP_TERMS_POPUP_COLLECTOR_NAME, false, dirname(plugin_basename(__FILE__)).'/languages/');
}
add_action('plugins_loaded', 'wptp_collector_textdomain', 0);

function wptp_collector_textdomain_mofile($mofile, $domain)
{
    if (WP_TERMS_POPUP_COLLECTOR_NAME === $domain && false !== strpos($mofile, WP_LANG_DIR.'/plugins/')) {
        $locale = apply_filters('plugin_locale', determine_locale(), $domain);
        $mofile = WP_PLUGIN_DIR.'/'.dirname(plugin_basename(__FILE__)).'/languages/'.$domain.'-'.$locale.'.mo';
    }
    return $mofile;
}
add_filter('load_textdomain_mofile', 'wptp_collector_textdomain_mofile', 10, 2);

function wptp_collector_register_privacy_erasers($erasers)
{
    $erasers[WP_TERMS_POPUP_COLLECTOR_NAME] = [
        'eraser_friendly_name' => __('WP Terms Popup Collector', WP_TERMS_POPUP_COLLECTOR_NAME),
        'callback' => 'wptp_collector_erase_personal_data',
    ];

    return $erasers;
}
add_filter('wp_privacy_personal_data_erasers', 'wptp_collector_register_privacy_erasers');

function wptp_collector_register_user_data_exporters($exporters)
{
    $exporters[WP_TERMS_POPUP_COLLECTOR_NAME] = [
        'exporter_friendly_name' => __('WP Terms Popup Collector', WP_TERMS_POPUP_COLLECTOR_NAME),
        'callback' => 'wptp_collector_export_personal_data',
    ];
    return $exporters;
}
add_filter('wp_privacy_personal_data_exporters', 'wptp_collector_register_user_data_exporters');

add_action('init', 'wptp_collector_updates');
add_action('wptp_after_meta_boxes_post_type', 'wptp_collector_meta_box', 10, 2);
add_action('save_post', 'wptp_collector_meta_box_save', 10, 2);
add_action('publish_termpopup', 'wptp_collector_publish_termpopup', 10, 2);
