<?php
function wptp_collector_updates()
{
    require_once ABSPATH.'wp-admin/includes/upgrade.php';

    global $wpdb;

    $charset_collate = $wpdb->get_charset_collate();
    $table_name_logs = $wpdb->prefix.'wptp_collector_logs';
    $table_name_contents = $wpdb->prefix.'wptp_collector_contents';

    // Add column to logs table
    $is_status_col = $wpdb->get_results("SELECT `COLUMN_NAME` FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE `table_name` = '{$table_name_logs}' AND `TABLE_SCHEMA` = '{$wpdb->dbname}' AND `COLUMN_NAME` = 'contents_id'");
    if (empty($is_status_col)) {
        $add_status_column = "ALTER TABLE `{$table_name_logs}` ADD `contents_id` bigint(20) unsigned DEFAULT NULL AFTER `user_id`; ";
        $wpdb->query($add_status_column);
    }

    // Create table for popup contents
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name_contents'") != $table_name_contents) {
        $sql_contents = "CREATE TABLE $table_name_contents (
            `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
            `popup_id` bigint(20) unsigned DEFAULT NULL,
            `post_content` longtext DEFAULT NULL,
            `post_title` text DEFAULT NULL,
            PRIMARY KEY (`id`)
        ) $charset_collate;";
        dbDelta($sql_contents);
    }

    // Add current popups to contents table, if empty
    $count_contents = $wpdb->get_var("SELECT COUNT(*) FROM {$table_name_contents} WHERE id IS NOT NULL");
    if ($count_contents == 0) {
        $popups = new WP_Query([
            'post_type' => 'termpopup',
            'post_status' => 'publish',
            'posts_per_page' => -1,
            'orderby' => 'ID',
        ]);

        while ($popups->have_posts()) {
            $popups->the_post();

            $popup_id = get_the_ID();
            $post_content = get_the_content();
            $post_content = apply_filters('the_content', $post_content);
            $post_content = str_replace(']]>', ']]&gt;', $post_content);
            $post_title = get_the_title();

            // Insert data into contents table
            wptp_collector_insert_contents($popup_id, $post_content, $post_title);
        }

        wp_reset_postdata();
    }
}
