<?php

class WPF_Media_Tools_Public {

	/**
	 * Get things started
	 *
	 * @since 1.0
	 * @return void
	 */

	public function __construct() {

		// Video shortcode filtering
		add_filter( 'shortcode_atts_video', array( $this, 'video_atts' ), 10, 4 );
		add_filter( 'wp_video_shortcode', array( $this, 'shortcode_output_video' ), 10, 5 );

		// Embed shortcode filtering
		add_filter( 'shortcode_atts_embed', array( $this, 'video_atts' ), 10, 4 );
		add_filter( 'embed_oembed_html', array( $this, 'shortcode_output_embed' ), 10, 4 );

		// Presto Player
		add_filter( 'do_shortcode_tag', array( $this, 'shortcode_output_presto_player' ), 10, 4 );

		// VooPlayer
		add_filter( 'do_shortcode_tag', array( $this, 'shortcode_output_vooplayer' ), 10, 4 );

		// s3 Media Maestro
		add_filter( 'shortcode_atts_s3mm', array( $this, 'video_atts' ), 10, 4 );
		add_filter( 's3mm_shortcode_html', array( $this, 'shortcode_output_video' ), 10, 3 );

		// Frontend scripts
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

	}

	/**
	 * Add custom shortcode atts to media / embed shortcodes
	 *
	 * @since 1.0
	 * @return array Atts
	 */

	public function video_atts( $out, $pairs, $atts, $shortcode ) {

		foreach ( $atts as $key => $value ) {

			if ( strpos( $key, 'wpf_' ) !== false ) {
				$out[ $key ] = $value;
			}
		}

		return $out;

	}


	/**
	 * Adds data attributes to media shortcode output
	 *
	 * @since 1.0
	 * @return string Output
	 */

	public function shortcode_output_video( $output, $atts, $media, $post_id = false, $library = false ) {

		$data_atts = '';
		$found     = false;

		foreach ( $atts as $key => $value ) {
			if ( strpos( $key, 'wpf_' ) !== false ) {
				$data_atts .= 'data-' . $key . '="' . $value . '" ';
				$found      = true;
			}
		}

		if ( $found == true ) {
			$output = str_replace( '<video ', '<video ' . $data_atts, $output );
			wp_enqueue_script( 'wpf-media-tools' );
		}

		return $output;

	}

	/**
	 * Adds data attributes to embed shortcode output
	 *
	 * @since 1.0
	 * @return string Output
	 */

	public function shortcode_output_embed( $output, $url, $atts, $post_ID ) {

		if ( ! is_array( $atts ) ) {
			return $output;
		}

		$data_atts = '';
		$found     = false;

		foreach ( $atts as $key => $value ) {
			if ( strpos( $key, 'wpf_' ) !== false ) {
				$data_atts .= 'data-' . $key . '="' . $value . '" ';
				$found      = true;
			}
		}

		if ( $found != true ) {
			return $output;
		}

		wp_enqueue_script( 'wpf-media-tools' );

		// Vimeo iFrames
		if ( strpos( $output, 'vimeo' ) !== false ) {

			$data_atts .= 'data-player_type="vimeo" ';
			wp_enqueue_script( 'vimeo-api', '//player.vimeo.com/api/player.js', array( 'jquery' ) );

		} elseif ( strpos( $output, 'youtube' ) !== false ) {

			$output     = str_replace( '?feature=oembed', '?feature=oembed&enablejsapi=1', $output );
			$data_atts .= 'data-player_type="youtube" id="' . uniqid( 'wpf_youtube_' ) . '" ';
			wp_enqueue_script( 'youtube-api', '//www.youtube.com/iframe_api', array(), '1.0', false );

		} elseif ( strpos( $output, 'wistia' ) !== false ) {

			$data_atts .= 'data-player_type="wistia" id="' . uniqid( 'wpf_wistia_' ) . '" ';

			$output = str_replace( 'sandbox="allow-scripts" ', '', $output );
			$output = str_replace( 'security="restricted" ', '', $output );
			$output = str_replace( 'wp-embedded-content', 'wistia_embed', $output );

			wp_enqueue_script( 'wistia-api', '//fast.wistia.com/assets/external/E-v1.js', array(), '1.0', false );

		}

		$output = str_replace( '<iframe ', '<iframe ' . $data_atts, $output );

		return $output;

	}

	/**
	 * Adds data attributes to Presto Player output
	 *
	 * @since 1.2.0
	 *
	 * @param string       $output The shortcode output.
	 * @param string       $tag    The name of the shortcode tag.
	 * @param array|string $attr   Shortcode attributes array or empty string.
	 * @param array        $m      Regular expression match array.
	 * @return string The shortcode output.
	 */
	public function shortcode_output_presto_player( $output, $tag, $attr, $m ) {

		if ( 'presto_player' !== $tag ) {
			return $output;
		}

		$data_atts = '';
		$proceed   = false;

		// Check if WPF is in use on the video
		foreach ( $attr as $key => $value ) {

			if ( strpos( $key, 'wpf_' ) !== false ) {
				$data_atts .= 'data-' . $key . '="' . $value . '" ';
				$proceed    = true;
			}
		}

		if ( ! $proceed ) {
			return $output;
		}

		wp_enqueue_script( 'wpf-media-tools' );

		$data_atts .= 'data-player_type="presto_player" id="' . uniqid( 'wpf_presto_player_' ) . '" ';

		$output = str_replace( '<figure ', '<figure ' . $data_atts, $output );

		return $output;
	}

	/**
	 * Adds data attributes to VooPlayer output
	 *
	 * @since 1.0
	 * @return string Output
	 */

	public function shortcode_output_vooplayer( $output, $tag, $attr, $m ) {

		if ( $tag != 'vooplayer' ) {
			return $output;
		}

		$data_atts = '';
		$proceed   = false;

		// Check if WPF is in use on the video
		foreach ( $attr as $key => $value ) {

			if ( strpos( $key, 'wpf_' ) !== false ) {
				$data_atts .= 'data-' . $key . '="' . $value . '" ';
				$proceed    = true;
			}
		}

		if ( ! $proceed ) {
			return $output;
		}

		wp_enqueue_script( 'wpf-media-tools' );

		$data_atts .= 'data-player_type="vooplayer" id="' . uniqid( 'wpf_vooplayer_' ) . '" ';

		$output = str_replace( '<iframe ', '<iframe ' . $data_atts, $output );

		return $output;

	}

	/**
	 * Add custom shortcode atts to media shortcode
	 *
	 * @since 1.0
	 * @return array Atts
	 */

	public function enqueue_scripts() {

		wp_register_script( 'wpf-media-tools', WPF_MEDIA_TOOLS_DIR_URL . 'assets/wpf-media-tools.js', array( 'jquery' ), WPF_MEDIA_TOOLS_VERSION, true );

		$localize_data = array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
		);

		wp_localize_script( 'wpf-media-tools', 'wpf_mt_ajax', $localize_data );

		if ( wp_fusion()->settings->get( 'media_tools_enqueue_scripts' ) ) {

			wp_enqueue_script( 'wpf-media-tools' );

			$players = wp_fusion()->settings->get( 'media_tools_players', array() );

			if ( isset( $players['vimeo'] ) ) {
				wp_enqueue_script( 'vimeo-api', '//player.vimeo.com/api/player.js', array( 'jquery' ) );
			}

			if ( isset( $players['youtube'] ) ) {
				wp_enqueue_script( 'youtube-api', '//www.youtube.com/iframe_api', array(), '1.0', false );
			}

			if ( isset( $players['wistia'] ) ) {
				wp_enqueue_script( 'wistia-api', '//fast.wistia.com/assets/external/E-v1.js', array(), '1.0', false );
			}
		}

	}



}

new WPF_Media_Tools_Public();
