<?php

class WPF_Media_Tools_Elementor {


	/**
	 * Get things started
	 *
	 * @since 1.0
	 * @return void
	 */

	public function __construct() {

		// Controls
		add_action( 'elementor/element/video/section_image_overlay/after_section_end', array( $this, 'render_controls' ), 10, 3 );

		// Display
		add_action( 'elementor/widget/render_content', array( $this, 'render_widget' ), 100, 2 );

	}

	/**
	 * Render widget controls
	 *
	 * @access public
	 * @return void
	 */

	public function render_controls( $element, $args ) {

		$available_tags = wp_fusion()->settings->get( 'available_tags', array() );

		$data = array();

		foreach ( $available_tags as $id => $label ) {

			if ( is_array( $label ) ) {
				$label = $label['label'];
			}

			$data[ $id ] = $label;

		}

		$element->start_controls_section(
			'wpf_media_tags_section',
			[
				'label' => __( 'WP Fusion Media Tools', 'wp-fusion' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$element->add_control(
			'wpf_tags_start',
			[
				'label'       => __( 'Apply tags when media started', 'wp-fusion' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options'     => $data,
				'multiple'    => true,
				'label_block' => true,
			]
		);

		$element->add_control(
			'wpf_tags_complete',
			[
				'label'       => __( 'Apply tags when media completed', 'wp-fusion' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options'     => $data,
				'multiple'    => true,
				'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'wpf_timecode',
			[
				'label'       => __( 'Timecode:', 'wp-fusion' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => '0:00',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'wpf_tags_timecode',
			[
				'label'       => __( 'Apply tags:', 'wp-fusion' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'default'     => 'default',
				'options'     => $data,
				'multiple'    => true,
				'label_block' => true,
			]
		);

		$element->add_control(
			'wpf_timecodes',
			[
				'label' => __( 'Timecodes', 'wp-fusion' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ wpf_timecode }}}',
			]
		);

		do_action( 'wpf_elementor_controls_section', $element );

		$element->end_controls_section();

	}


	/**
	 * Show the video widget
	 *
	 * @access public
	 * @return void
	 */

	public function render_widget( $content, $widget ) {

		$data_atts     = '';
		$tags_start    = $widget->get_settings( 'wpf_tags_start' );
		$tags_end      = $widget->get_settings( 'wpf_tags_complete' );
		$tags_timecode = $widget->get_settings( 'wpf_tags_timecode' );
		$tags_at_time  = $widget->get_settings( 'wpf_timecode' );
		$repeater      = $widget->get_settings( 'wpf_timecodes' );

		if ( empty( $tags_start ) && empty( $tags_end ) && empty( $tags_timecode ) && empty( $repeater ) ) {
			return $content;
		}

		if ( ! empty( $tags_start ) && is_array( $tags_start ) ) {
			$tags_start = implode( ',', $tags_start );
			$data_atts .= 'data-wpf_tags_start' . '="' . $tags_start . '" ';
		}

		if ( ! empty( $tags_end ) && is_array( $tags_end ) ) {
			$tags_end   = implode( ',', $tags_end );
			$data_atts .= 'data-wpf_tags_complete' . '="' . $tags_end . '" ';
		}

		$count = 0;

		if ( ! empty( $tags_timecode ) && is_array( $tags_timecode ) ) {
			$tags_timecode = implode( ',', $tags_timecode );
			$data_atts    .= 'data-wpf_tags_timecode' . '="' . $tags_timecode . '" ';
			$count         = 2;
		}

		if ( ! empty( $tags_at_time ) ) {
			$data_atts .= 'data-wpf_timecode' . '="' . $tags_at_time . '" ';
		}

		if ( ! empty( $repeater ) ) {

			foreach ( $repeater as $data ) {

				if ( empty( $data['wpf_tags_timecode'] ) || ! is_array( $data['wpf_tags_timecode'] ) ) {
					continue;
				}

				if ( 0 == $count ) {

					// The first one doesn't get a number
					$data_atts .= 'data-wpf_timecode="' . $data['wpf_timecode'] . '" ';
					$data_atts .= 'data-wpf_tags_timecode="' . implode( ',', $data['wpf_tags_timecode'] ) . '" ';
					$count = 1;

				} else {
					$data_atts .= 'data-wpf_timecode_' . $count . '="' . $data['wpf_timecode'] . '" ';
					$data_atts .= 'data-wpf_tags_timecode_' . $count . '="' . implode( ',', $data['wpf_tags_timecode'] ) . '" ';
				}

				$count++;

			}
		}

		$player_type = $widget->get_settings( 'video_type' );

		// Vimeo iFrames.
		if ( 'vimeo' === $player_type ) {

			$data_atts .= 'data-player_type="vimeo" ';
			wp_enqueue_script( 'vimeo-api', '//player.vimeo.com/api/player.js', array( 'jquery' ) );

		} elseif ( 'youtube' === $player_type ) {

			$data_atts .= 'data-player_type="youtube" id="' . uniqid( 'wpf_youtube_' ) . '" ';

		} elseif ( 'hosted' === $player_type ) {

			// enqueue the mediaelement script.
			wp_enqueue_script( 'wp-mediaelement' );
			$data_atts .= 'data-player_type="hosted" id="' . uniqid( 'wpf_media_' ) . '" ';

		}

		wp_enqueue_script( 'wpf-media-tools' );

		if ( 'youtube' === $player_type ) {

			// Since some time in 2021, the YouTube player no longer has an iframe, just a <div.

			$content = str_replace( '<div class="elementor-video"', '<div class="elementor-video" ' . $data_atts, $content );

		} elseif ( 'hosted' === $player_type ) {

			// Hosted videos are just <video> tags.

			$content = str_replace( '<video ', '<video ' . $data_atts, $content );

		} else {
			$content = str_replace( '<iframe ', '<iframe ' . $data_atts, $content );
		}

		return $content;

	}


}

new WPF_Media_Tools_Elementor();
