<?php

class WPF_Media_Tools_Admin {

	/**
	 * Get things started
	 *
	 * @since 1.0
	 * @return void
	 */

	public function __construct() {

		add_filter( 'wpf_compatibility_notices', array( $this, 'compatibility_notices' ) );

		add_filter( 'wpf_configure_sections', array( $this, 'configure_sections' ), 10, 2 );
		add_filter( 'wpf_configure_settings', array( $this, 'register_settings' ), 10, 2 );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_footer', array( $this, 'media_modal_template' ) );

	}


	/**
	 * Add Addons tab to the settings.
	 *
	 * @since  1.2.3
	 *
	 * @param  array $page    The settings page.
	 * @param  array $options The options in the database.
	 * @return array The settings page with the new section added.
	 */
	public function configure_sections( $page, $options ) {

		if ( ! isset( $page['sections']['addons'] ) ) {
			$page['sections'] = wp_fusion()->settings->insert_setting_before( 'import', $page['sections'], array( 'addons' => __( 'Addons', 'wp-fusion-media-tools' ) ) );
		}

		return $page;

	}

	/**
	 * Add settings to the settings page,
	 *
	 * @since 1.2.3
	 *
	 * @param array $settings The available settings.
	 * @param array $options  The options in the database.
	 * @return array The settings with the new settings added.
	 */
	public function register_settings( $settings, $options ) {

		$settings['media_tools_header'] = array(
			'title'   => __( 'Media Tools', 'wp-fusion-media-tools' ),
			'desc'    => __( '<a href="https://wpfusion.com/documentation/media-tools/usage-guide/" target="_blank">Read our documentation</a> for more information on the WP Fusion Media Tools addon.', 'wp-fusion-media-tools' ),
			'type'    => 'heading',
			'section' => 'addons',
		);

		$settings['media_tools_enqueue_scripts'] = array(
			'title'   => __( 'Load Scripts Everywhere', 'wp-fusion-media-tools' ),
			'desc'    => __( 'Load the Media Tools tracking scripts on every page of the site (instead of just pages with trackable videos on them).', 'wp-fusion-media-tools' ),
			'type'    => 'checkbox',
			'section' => 'addons',
			'unlock'  => array( 'media_tools_players' ),
		);

		$settings['media_tools_players'] = array(
			'title'   => __( 'Enabled Players', 'wp-fusion' ),
			'desc'    => __( 'Select which player API scripts should be loaded on every page.', 'wp-fusion' ),
			'type'    => 'checkboxes',
			'section' => 'addons',
			'options' => array(
				'vimeo'   => 'Vimeo',
				'youtube' => 'YouTube',
				'wistia'  => 'Wistia',
			),
		);

		return $settings;

	}


	/**
	 * Conpatibility notices
	 *
	 * @since  1.1.3
	 *
	 * @param  array $notices The notices.
	 * @return array The notices.
	 */
	public function compatibility_notices( $notices ) {

		if ( is_plugin_active( 'borlabs-cookie/borlabs-cookie.php' ) ) {
			$notices['borlabs-cookie'] = __( 'Warning: The <strong>Borlabs Cookie - Cookie Opt-in</strong> plugin is active. This plugin may prevent the WP Fusion Media Tools addon from tracking video player engagement.', 'wp-fusion' );
		}

		return $notices;

	}


	/**
	 * Enqueue admin scripts
	 *
	 * @since 1.0
	 * @return void
	 */

	public function enqueue_scripts() {

		wp_enqueue_script( 'wpf-media-admin', WPF_MEDIA_TOOLS_DIR_URL . 'assets/wpf-media-tools-admin.js', array( 'jquery', 'media-editor', 'wpf-admin' ), WPF_MEDIA_TOOLS_VERSION, true );
		wp_enqueue_style( 'wpf-media-admin', WPF_MEDIA_TOOLS_DIR_URL . 'assets/wpf-media-tools-admin.css' );

	}

	/**
	 * Outputs media modal content for cloning into modal
	 *
	 * @since 1.0
	 * @return void
	 */

	public function media_modal_template() {

		global $post;

		if ( empty( $post ) ) {
			return;
		}

		if ( empty( $post->post_type ) ) {
			return;
		}

		?>

		<div id="wpf-media-settings-master" class="">
			
			<h3>WP Fusion Media Tracking</h3>

			<div class="setting">
				<span>Apply tags when media started:</span>
				<?php
				wpf_render_tag_multiselect(
					array(
						'setting'   => array(),
						'meta_name' => 'wpf-media-settings',
						'field_id'  => 'wpf_tags_start',
					)
				);
?>
			</div>

			<div class="setting">
				<span>Apply tags when media completed:</span>
				<?php
				wpf_render_tag_multiselect(
					array(
						'setting'   => array(),
						'meta_name' => 'wpf-media-settings',
						'field_id'  => 'wpf_tags_complete',
					)
				);
?>
			</div>

			<div class="setting">
				<span>Apply tags at timecode (timecode):</span>
				<input id="wpf_timecode" placeholder="0:00" type="text" />
			</div>

			<div class="setting">
				<span>Apply tags at timecode (tags):</span>
				<?php
				wpf_render_tag_multiselect(
					array(
						'setting'   => array(),
						'meta_name' => 'wpf-media-settings',
						'field_id'  => 'wpf_tags_timecode',
					)
				);
?>
			</div>

		</div>

		<?php
	}

}

new WPF_Media_Tools_Admin();
