jQuery(document).ready(function($){

	if (wp.media) {

		// Trigger on media modal open
        wp.media.view.Modal.prototype.on('open', function() {

            if(wp.media.frame._state == 'video-details') {

        		var settingsContainer = $('#wpf-media-settings-master').clone().attr('id', '').addClass('wpf-media-settings');
        		$(wp.media.frame.el).find('.media-frame-content .embed-video-settings .wp-video-holder').after(settingsContainer);

        		initializeTagsSelect('.media-frame-content .embed-video-settings .wpf-media-settings');

        		// Populate selects with options from shortcode
        		$('.wpf-media-settings select').each(function(index, el) {

        			var select = $(this);

                    var id = $(this).attr('id').replace( 'wpf-media-settings-', '' );

        			if(wp.media.frame.options.metadata.hasOwnProperty( id )) {
        				var selection = wp.media.frame.options.metadata[ id ].split(',');

        				// Add new options to select2 if not already present
        				$.each(selection, function(index, val) {
							if($(select).find('option[value="' + val + '"]').length == 0 ) {
								$(select).append(new Option(val, val));
							}
        				});

        				// Update select2 from <select>
        				$(this).val(selection).trigger('change');
        			}
        		});

        		// Populate text inputs
        		$('.wpf-media-settings input').each(function(index, el) {
        			if(wp.media.frame.options.metadata.hasOwnProperty($(this).attr('id'))) {
        				$(this).val(wp.media.frame.options.metadata[$(this).attr('id')]);
        			}
        		});


        		// Save select options to shortcode
        		$('.wpf-media-settings select').on('change', function(event) {

                    var id = $(this).attr('id').replace( 'wpf-media-settings-', '' );

        			if(!$(this).val()) {
        				delete wp.media.frame.media.attributes[ id ];
        			} else {
        				wp.media.frame.media.attributes[ id ] = $(this).val().join();
        			}

        		});

        		// Save inputs to shortcode
        		$('.wpf-media-settings .setting > input').bind("keyup input paste", function() {

    				if(!$(this).val()) {
    					delete wp.media.frame.media.attributes[$(this).attr('id')];
    				} else {
						wp.media.frame.media.attributes[$(this).attr('id')] = $(this).val();
    				}

        		});


            } else if (wp.media.frame._state == 'embed') {

            	var settingsContainer = $('#wpf-media-settings-master').clone().attr('id', '').addClass('wpf-media-settings');
                $(wp.media.frame.el).find('.media-frame-content .embed-link-settings .embed-container').after(settingsContainer);

                initializeTagsSelect('.media-frame-content .embed-link-settings .wpf-media-settings');

                // Populate selects with options from shortcode
                $('.wpf-media-settings select').each(function(index, el) {

                    var select = $(this);

                    var id = $(this).attr('id').replace( 'wpf-media-settings-', '' );

                    if(wp.media.frame.options.metadata.hasOwnProperty( id )) {
                        var selection = wp.media.frame.views._views[".media-frame-content"][0].model.metadata[ id ].split(',');

                        // Add new options to select2 if not already present
                        $.each(selection, function(index, val) {
                            if($(select).find('option[value="' + val + '"]').length == 0 ) {
                                $(select).append(new Option(val, val));
                            }
                        });

                        // Update select2 from <select>
                        $(this).val(selection).trigger('change');
                    }
                });

                // Populate text inputs
                $('.wpf-media-settings input').each(function(index, el) {
                    if(wp.media.frame.views._views[".media-frame-content"][0].model.metadata.hasOwnProperty($(this).attr('id'))) {
                        $(this).val(wp.media.frame.views._views[".media-frame-content"][0].model.metadata[$(this).attr('id')]);
                    }
                });


                // Save select options to shortcode
                $('.wpf-media-settings select').on('change', function(event) {

                    var id = $(this).attr('id').replace( 'wpf-media-settings-', '' );

                    if(!$(this).val()) {
                        delete wp.media.frame.views._views[".media-frame-content"][0].model.metadata[ id ];
                    } else {
                        wp.media.frame.views._views[".media-frame-content"][0].model.metadata[ id ] = $(this).val().join();
                    }

                });

                // Save inputs to shortcode
                $('.wpf-media-settings .setting > input').bind("keyup input paste", function() {

                    if(!$(this).val()) {
                        delete wp.media.frame.views._views[".media-frame-content"][0].model.metadata[ $(this).attr('id') ];
                    } else {
                        wp.media.frame.views._views[".media-frame-content"][0].model.metadata[ $(this).attr('id') ] = $(this).val();
                    }

                });

            }

        });

    }


});