jQuery(document).ready(function($){

	// Defines Increments for Changes to Rows

	function calcRows( target ) {

  		$.each( $( target + ' .clone'), function(index, val) {

      		var prevNum = $(this).attr('data-num');
      		
			// Increment

			var mainAttr = $(this).attr('data-num');
			mainAttr = mainAttr.replace(prevNum, index);
			$(this).attr('data-num', mainAttr);

			var nameTag = $(this).find('[name*="[tags]"]').attr('name');
			nameTag = nameTag.replace( prevNum, index );
			$(this).find('[name*="[tags]"]').attr('name', nameTag);

			var nameRe  = $(this).find('[name*="page"]').attr('name');
			nameRe = nameRe.replace( prevNum, index );
			$(this).find('[name*="page"]').attr('name', nameRe);


			if( $(this).find('[name*="url"]').length ) {

				var nameUrl = $(this).find('[name*="url"]').attr('name');
				nameUrl = nameUrl.replace(prevNum, index);
				$(this).find('[name*="url"]').attr('name', nameUrl );

			}

			// Login count inputs

			if( $(this).find('[name*="type"]').length ) {

				var nameType = $(this).find('[name*="type"]').attr('name');
				nameType = nameType.replace(prevNum, index);
				$(this).find('[name*="type"]').attr('name', nameType );

				var nameCount = $(this).find('[name*="[count]"]').attr('name');
				nameCount = nameCount.replace(prevNum, index);
				$(this).find('[name*="[count]"]').attr('name', nameCount );

				var idTag = $(this).find('[id*="apply_tags"]').attr('id');
				idTag = idTag.replace(prevNum, index);
				$(this).find('[id*="apply_tags"]').attr('id', idTag );

			}

  		});

	}

	// Formats Adding New Row
	function addRow( target ) {

		var newRow = $(target).find( '.repeater.clone' ).clone();
		newRow.insertBefore( target + ' .repeater.clone').removeClass('repeater');

		calcRows( target );

		var num = newRow.attr('data-num');
	
		newRow.find('.select4-container').remove();
		initializeTagsSelect( target + ' .clone[data-num="' + num + '"]');

		$( target + ' .clone[data-num="' + num + '"] select.select4-select-page').select4({
			allowClear: true,
			minimumInputLength: 3,
			tags : true,
			insertTag : function(data, tag){
				tag.text = tag.text + " (add URL)"
				data.push(tag);
			},
			ajax: {
    			url: ajaxurl,
    			dataType: 'json',
    			type: 'POST',
    			delay: 250,
    			cache: true,
    			data: function( params ) {
    				var query = {
						search: params.term,
						action: 'wpf_get_redirect_options'
					}

					return query;
    			}
    		}
		});

		$( target + ' .clone[data-num="' + num + '"] select.select4').select4();

		//Deletes new row before save
		newRow.find('.minus').click(function(event) {

			event.preventDefault();

			newRow.remove();

			calcRows( target );

		});

	}


	//Deletes exiting row
	$('.wpf-repeater .minus').click(function(event) {

		event.preventDefault();

		$(this).closest('.clone').remove();

		var target = $(this).closest( '.wpf-repeater' ).attr( 'id' );

		calcRows( '#' + target );

	});


	//Add Row Function
	$( '#logins_redirect_add_new' ).click(function(event) {

		event.preventDefault();

		addRow( '#wpf-repeater-rules' );
	

	});

	//Add Row Function
	$( '#logins_count_add_new' ).click(function(event) {

		event.preventDefault();

		addRow( '#wpf-repeater-count-rules' );
	

	});

	//Creates drag and drop container
	var drake = dragula({
		isContainer: function (el) {
			return el.classList.contains('dragula-container');
		},
		moves: function (el, source, handle, sibling) {
			return handle.classList.contains('bars');
		}
	});
      
	drake.on('drop', function(el, target, source, sibling) {

		var target = $(el).closest( '.wpf-repeater' ).attr( 'id' );

		calcRows( '#' + target );

	});

});