<?php

// deny direct access
if ( ! function_exists( 'add_action' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

/**
 * Class WPF_Downloads_htacess_handle
 *
 * Handling the .htaccess file
 * 1. Obtaining the file path
 * 2. Checking if file is writable
 * 3. Getting the file content
 *
 */

class WPF_Downloads_htacess {

	/**
	 * get_htaccess_file_path
	 *
	 * Returns the file path
	 *
	 * @return string
	 */

	private function get_htaccess_file_path() {
		$home_path     = get_home_path();
		$htaccess_file = $home_path . '.htaccess';

		return $htaccess_file;
	}

	/**
	 * htaccess_writable
	 *
	 * Checking if file exists, if it's writable, changing the permission if possible and populating the error log if
	 * needed
	 *
	 * @return bool
	 */

	public function htaccess_writable() {

		$htaccess_file = $this->get_htaccess_file_path();

		// checking if file exists
		if ( ! file_exists( $htaccess_file ) ) {
			return false;
		}

		// checking if file is writable
		if ( is_writable( $htaccess_file ) ) {
			return true;
		} else {
			return false;
		}

		// changing the permission if possible
		@chmod( $htaccess_file, 0666 );

		// it's impossible to change the permission, contact the admin
		if ( ! is_writable( $htaccess_file ) ) {
			return false;
		}
		return true;
	}

	/**
	 * get_htaccess_content
	 *
	 * getting the content of  the .htacess file
	 *
	 * @return bool|string
	 */

	public function get_htaccess_content() {


		$htaccess_file = $this->get_htaccess_file_path();

		if ( ! file_exists( $htaccess_file ) ) {
			return false;
		}

		if ( ! is_writable( $htaccess_file ) ) {
			@chmod( $htaccess_file, 0666 );
		}

		if ( ! $f = fopen( $htaccess_file, 'r' ) ) {
			return false;
		}

		return file_get_contents( $htaccess_file );
	}
}
