<?php

/**
 * Woocomerce regenerate download permissions for all orders
 *
 * @package       WCGENERATEDOWNLOAD
 * @author        Benjamin Albrecht
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   Woocommerce Regenerate Download Permissions
 * Plugin URI:    https://albrightdesign.de
 * Description:   Woocomerce regenerate download permissions for all orders
 * Version:       1.0.0
 * Author:        Benjamin Albrecht
 * Author URI:    https://albrightdesign.de
 * Text Domain:   woocommerce-generate-dl_permissions
 * Domain Path:   /languages
 */

 add_action('admin_menu', 'register_my_custom_submenu_page', 20);

 function register_my_custom_submenu_page() {
     add_submenu_page( 
        'woocommerce', 
     'Regenerate Download Permissions', 
     'Regenerate Download Permissions', 
     'manage_options', 
     'woocommerce-generate-dl-permissions', 
     'my_admin_page_contents'
    ); 
 }


function my_admin_page_contents() {
    ?>
        <h1>
            <?php esc_html_e( 'Woocommerce Regenerate Download Permissions', 'woocommerce-generate-dl_permissions' ); ?>
        </h1>

        <?php if (isset($_POST['_wc-generate-dl-permissions'])) : ?>
            <h3>... regenerating permissions</h3>
            <?php
                $args = array(
                    'limit' => -1,
                    'return' => 'ids',
                    'status' => 'completed'
                );
                $query = new WC_Order_Query( $args );
                $orders = $query->get_orders();
                ?>
                <h3>Orders found: <?php echo count($orders) ?> </h3>
                <?php 

                    $data_store = WC_Data_Store::load( 'customer-download' );
                    foreach( $orders as $order_id ) {
                        echo $order_id . ", ";
                        //wc_downloadable_product_permissions($order_id);

                        // 1)  Reset the download counter
                       
                        $data_store->delete_by_order_id( $order_id );
                        wc_downloadable_product_permissions( $order_id, true );

                        // 2) Retrieve Download and remove the access expiration. (Our poor customer has had enough trouble)
                        // *Could optionally reset to product default (x days or whatever)
                        $downloads = $data_store->get_downloads(array('order_id' => $order_id) );
                        if(is_array($downloads)){
                            foreach($downloads as $download){
                                $download->set_access_expires(null);
                                $download->save();
                            }
                        }
                    }
                
                ?> <p>Finished!</p> <?php
            ?>
        <?php else : ?>
        <form method="post" action="" enctype="multipart/form-data">
            <?php wp_nonce_field('wc-generate-dl-permissions', '_wc-generate-dl-permissions') ?>
            <input type="submit" class="button-primary" value="Regenerate Download permissions" />
        </form>
        <?php endif; ?>
    <?php
}

function get_orders_ids_by_product_id($product_id) {
    global $wpdb;
    $orders_statuses = "'wc-completed', 'wc-processing', 'wc-on-hold'";
    return $wpdb->get_col(
        "
        SELECT DISTINCT woi.order_id
        FROM {$wpdb->prefix}woocommerce_order_itemmeta as woim, 
             {$wpdb->prefix}woocommerce_order_items as woi, 
             {$wpdb->prefix}posts as p
        WHERE  woi.order_item_id = woim.order_item_id
        AND woi.order_id = p.ID
        AND p.post_status IN ( $orders_statuses )
        AND woim.meta_key IN ( '_product_id', '_variation_id' )
        AND woim.meta_value LIKE '$product_id'
        ORDER BY woi.order_item_id DESC"
    );
}

// if you don't add 3 as as 4th argument, this will not work as expected
add_action('save_post', 'prefix_on_post_update', 10, 3);

function prefix_on_post_update($post_id, $post, $update) {
    if ($post->post_type == 'product') {
        $orders_ids = get_orders_ids_by_product_id($post_id);
        foreach ($orders_ids as $order_id) {
            $data_store = WC_Data_Store::load('customer-download');
            $data_store->delete_by_order_id($order_id);
            wc_downloadable_product_permissions($order_id, true);
        }
    }
}