<?php
/**
 * All HubSpot needed general settings.
 *
 * @link       https://makewebbetter.com/
 * @since      1.0.0
 *
 * @package    makewebbetter-hubspot-for-woocommerce
 * @subpackage makewebbetter-hubspot-for-woocommerce/admin/templates/
 */

global $hubwoo;
?>

<div class="hubwoo-gs-wrap hubwoo-gs-wrap--gen">
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'User Guide and Documentation', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Follow through the steps and directions mentioned in our documentation for hands-on experience.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<a href="https://docs.makewebbetter.com/hubspot-integration-for-woocommerce/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'View Guide', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'Knowledgebase of HubSpot Plugins', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Learn more about your HubSpot integration and get your basic queries resolved with our detailed Q/A guides.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<a href="https://support.makewebbetter.com/hubspot-knowledge-base/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Learn More', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
			</div>
		</div>
	</div>	
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'Free Support', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'We’re available 24/7 at your service. Get connected with our skilled and experienced experts to get your queries resolved in no time.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<a href="https://makewebbetter.com/contact-us/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Connect Us', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
			</div>
		</div>
	</div>	
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'Custom Development Service', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Explore our custom development services if you need to get any specific feature for your business process to function more smoothly.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<a href="https://makewebbetter.com/hubspot-development-services/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Get Started', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'Book a Meeting', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Need personalized and dedicated assistance from our skilled experts? Schedule a 15-minutes meeting and get your business started with HubSpot.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<a href="https://meetings.hubspot.com/makewebbetter/free-hubspot-consultation?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Book Now', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'Download Plugin Log File', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Share your log files, if you face troubles working with the plugin, with our tech team.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<a href="?hubwoo_download=1" class="hubwoo__btn"><?php esc_html_e( 'Download', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot CMS Services', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Build amazingly beautiful and interactive websites with our easy-to-use HubSpot themes.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/hubspot-themes/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Get Started', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>	
</div>
