<?php
/**
 * LearnPress PMRO Account Functions
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'learn_press_pmproaccount_template' ) ) {
	/**
	 * Get pmpro account template.
	 *
	 * @param      $name
	 * @param null $args
	 */
	function learn_press_pmproaccount_template( $name, $args = null ) {
		LP_Addon_Pmpro_Account::instance()->get_template( $name, $args );
		//learn_press_get_template( $name, $args, learn_press_template_path() . '/addons/wishlist/', LP_ADDON_WISHLIST_TEMPLATE );
	}
}



add_filter( 'learn_press_profile_tabs', 'learn_press_pmpro_account', 20, 2 );
if ( ! function_exists( 'learn_press_pmpro_account' ) ) {
	/**
	 *  Add pmpro account tab into profile page.
	 *
	 * @param $tabs
	 * @param $user
	 *
	 * @return mixed
	 */
	function learn_press_pmpro_account( $tabs, $user ) {
		$content = '';

		$tabs[40] = array(
			'tab_id'      => 'pmpro_account',
			'tab_name'    => __( 'Membership', 'learnpress_pmproaccount' ),
			'tab_content' => apply_filters( 'learn_press_user_pmpro_account_content', $content, $user )
		);
		// Private customize
		if ( $user->ID != get_current_user_id() ) {
			unset ( $tabs[40] );
		}

		return $tabs;
	}
}

/**
 * This recipe changes localized text strings for
 * Paid Memberships Pro using the gettext filter.
 *
 * @link http://codex.wordpress.org/Plugin_API/Filter_Reference/gettext
 * 
 * These changes should preferably be changed with customized language files
 * and saved in /wp-content/languages/plugins/plugin-name
 * @link https://developer.wordpress.org/plugins/internationalization/localization/#using-localizations
 * 
 * References:
 * https://www.paidmembershipspro.com/documentation/languages/create-a-new-translation/
 * https://www.paidmembershipspro.com/paid-memberships-pro-in-your-language/
 *
 * You can add this recipe to your site by creating a custom plugin
 * or using the Code Snippets plugin available for free in the WordPress repository.
 * Read this companion article for step-by-step directions on either method.
 * https://www.paidmembershipspro.com/create-a-plugin-for-pmpro-customizations/
 */

/**
 * Filter level cost text paid membership pro; copyed from eduma
 */
add_filter( 'pmpro_level_cost_text', 'thim_pmpro_getLevelCost', 9, 4 );
if ( ! function_exists( 'thim_pmpro_getLevelCost' ) ) {
	function thim_pmpro_getLevelCost( $r, $level, $tags, $short ) {
		//initial payment
		if ( ! $short ) {
			$r = sprintf( __( 'The price for membership is <p class="price">%s</p>', 'eduma' ), pmpro_formatPrice( $level->initial_payment ) );
		} else {
			$r = sprintf( __( '%s', 'eduma' ), pmpro_formatPrice( $level->initial_payment ) );
		}

		//recurring part
		if ( $level->billing_amount != '0.00' ) {
			if ( $level->billing_limit > 1 ) {
				if ( $level->cycle_number == '1' ) {
					$r .= sprintf( __( '<p class="expired">Then %s per %s for %d %s</p>', 'eduma' ), pmpro_formatPrice( $level->billing_amount ), strtolower(pmpro_translate_billing_period( $level->cycle_period )), $level->billing_limit, strtolower(pmpro_translate_billing_period( $level->cycle_period, $level->billing_limit )) );
				} else {
					$r .= sprintf( __( '<p class="expired">Then %s every %d %s for %d payments</p>', 'eduma' ), pmpro_formatPrice( $level->billing_amount ), $level->cycle_number, pmpro_translate_billing_period( $level->cycle_period, $level->cycle_number ), $level->billing_limit );
				}
			} elseif ( $level->billing_limit == 1 ) {
				$r .= sprintf( __( '<p class="expired">Then %s after %d %s</p>', 'eduma' ), pmpro_formatPrice( $level->billing_amount ), $level->cycle_number, pmpro_translate_billing_period( $level->cycle_period, $level->cycle_number ) );
			} else {
				if ( $level->billing_amount === $level->initial_payment ) {
					if ( $level->cycle_number == '1' ) {
						if ( ! $short ) {
							$r = sprintf( __( 'The price for membership is <strong>%s per %s</strong>', 'eduma' ), pmpro_formatPrice( $level->initial_payment ), pmpro_translate_billing_period( $level->cycle_period ) );
						} else {
							$r = sprintf( __( '<p class="expired">%s per %s</p>', 'eduma' ), pmpro_formatPrice( $level->initial_payment ), pmpro_translate_billing_period( $level->cycle_period ) );
						}
					} else {
						if ( ! $short ) {
							$r = sprintf( __( 'The price for membership is <strong>%s every %d %s</strong>', 'eduma' ), pmpro_formatPrice( $level->initial_payment ), $level->cycle_number, pmpro_translate_billing_period( $level->cycle_period, $level->cycle_number ) );
						} else {
							$r = sprintf( __( '<p class="expired">%s every %d %s</p>', 'eduma' ), pmpro_formatPrice( $level->initial_payment ), $level->cycle_number, pmpro_translate_billing_period( $level->cycle_period, $level->cycle_number ) );
						}
					}
				} else {
					if ( $level->cycle_number == '1' ) {
						$r .= sprintf( __( '<p class="expired">then %s per %s</p>', 'eduma' ), pmpro_formatPrice( $level->billing_amount ), pmpro_translate_billing_period( $level->cycle_period ) );
					} else {
						$r .= sprintf( __( '<p class="expired">and then %s every %d %s</p>', 'eduma' ), pmpro_formatPrice( $level->billing_amount ), $level->cycle_number, pmpro_translate_billing_period( $level->cycle_period, $level->cycle_number ) );
					}
				}
			}
		}

		//trial part
		if ( $level->trial_limit ) {
			if ( $level->trial_amount == '0.00' ) {
				if ( $level->trial_limit == '1' ) {
					$r .= ' ' . __( 'After your initial payment, your first payment is Free.', 'eduma' );
				} else {
					$r .= ' ' . sprintf( __( 'After your initial payment, your first %d payments are Free.', 'eduma' ), $level->trial_limit );
				}
			} else {
				if ( $level->trial_limit == '1' ) {
					$r .= ' ' . sprintf( __( 'After your initial payment, your first payment will cost %s.', 'eduma' ), pmpro_formatPrice( $level->trial_amount ) );
				} else {
					$r .= ' ' . sprintf( __( 'After your initial payment, your first %d payments will cost %s.', 'eduma' ), $level->trial_limit, pmpro_formatPrice( $level->trial_amount ) );
				}
			}
		}

		//taxes part
		$tax_state = pmpro_getOption( "tax_state" );
		$tax_rate  = pmpro_getOption( "tax_rate" );

		if ( $tax_state && $tax_rate && ! pmpro_isLevelFree( $level ) ) {
			$r .= sprintf( __( 'Customers in %s will be charged %s%% tax.', 'eduma' ), $tax_state, round( $tax_rate * 100, 2 ) );
		}

		if ( ! $tags ) {
			$r = strip_tags( $r );
		}

		return $r;
	}
}


function on_cancel_membership( int $level_id, int $user_id) {

	if($level_id == 0){
		$args = array(
			'customer_id' => $user_id,
			'limit' => -1, // to retrieve _all_ orders by this user
		);
		$orders = wc_get_orders($args);

		foreach($orders as $order){
			if($order->get_total() == 0 && $order->get_status() == "completed"){ // only cancel order with total of 0
				$order->update_status( 'cancelled' );
			}
		}
	}
}
add_action( 'pmpro_after_change_membership_level', 'on_cancel_membership', 10, 2 );

function on_start_membership( int $level_id, int $user_id) {

	if($level_id != 0){
		$order = wc_create_order();

		// add all downloadables to the order
		$downloadables = get_posts( array(
				'post_type' => 'product',
				'numberposts' => -1,
				'post_status' => 'publish',
				'fields' => 'ids',
		));

		foreach ($downloadables as $downloadableId) {
			$order->add_product(wc_get_product($downloadableId), 1, array('subtotal' => 0, 'total' => 0));
		}

		$order->set_customer_id($user_id);
		$order->set_status('completed', 'imported order');
		$order->calculate_totals();
		$order->save();

		// update download permissions
		wc_downloadable_product_permissions($order->get_id());
	}
}
add_action( 'pmpro_after_change_membership_level', 'on_start_membership', 9, 2 );


function get_user_product_downloads( $product ){
	$productDownloads = array();

	if ($product->is_downloadable()) {
		$user_id = get_current_user_id();
		if(get_current_user_id() == 0 ) return $productDownloads;
		$downloads = wc_get_customer_available_downloads($user_id);
		
		// Loop through WC_Product_Download objects
		if (!empty($downloads)) {
			$downloads = super_unique($downloads, 'product_url');
			foreach ($downloads as $download) {
				if ($download['product_id'] === $product->get_id()) {
					$productDownloads[] = $download;
				}
			}
		}
	}

	return $productDownloads;
}

function user_can_download_product( $product ){
	if(get_current_user_id() == 0 ) return false;
	$productDownloads = get_user_product_downloads( $product );

	if (!empty($productDownloads)) return true;
	return false;
}