<?php

/**
 * Template: Account
 *
 * See documentation for how to override the PMPro templates.
 * @link https://www.paidmembershipspro.com/documentation/templates/
 *
 * @version 2.0
 *
 * @author 
 */


if (!defined('ABSPATH')) {
	exit;
}

$user = wp_get_current_user();

$lea_name = get_user_meta($user->ID, 'lea_name', true);

?>


<div id="profile-content-districts">
	<h3 class="profile-heading">District: <?= $lea_name ?></h3>

	<?php $args = array(
    'meta_query' => array(
        array(
            'key' => 'lea_name',
            'value' => $lea_name
        )
    ),
    'post_type' => 'learnpress_district',
    'posts_per_page' => -1
);
$posts = get_posts($args); 
?>

<h4>Assigned user</h4><ul
	<?php $args = array(
		'meta_query' => array(
			array(
				'key' => 'lea_name',
				'value' => esc_attr( $lea_name ),
				'compare' => '='
			)
		)
	);
	$member_arr = get_users($args);
	if ($member_arr) {
	  foreach ($member_arr as $user) { ?>
		<li><?= $user->user_email ?></li>
	<?php   }
	} else {
	  echo '<li>no users found</li>';
	} ?>
	<ul>


</div>