<?php
#require  '../../lib/fpdf/fpdf.php';

//phpinfo(); die();

require_once (dirname(dirname( dirname(__FILE__) ) ) . '/lib/dompdf/autoload.inc.php');
// reference the Dompdf namespace
use Dompdf\Dompdf;

define("DOMPDF_ENABLE_REMOTE", true);

function createPdf($filename, $from, $to, $district_name, $imgteam, $images, $user_count, $quater){
//$from = $_GET["from"];
//$to = $_GET["to"];

//$imgteam = $_GET["imgteam"];
//$img1 = $_GET["img1"];
//$img2 = $_GET["img2"];
//$img3 = $_GET["img3"];

//$user_count = $_GET["usercount"];

//$district_name = $_GET["district"];

$img1_title = $from ?  "Quarterly Report:  $from - $to" :  'Cumulative Totals';

if($quater == 99){
  $img1_title = $from ?  "Report:  $from - $to" :  'Cumulative Totals';
}

$url = "http" . (($_SERVER['SERVER_PORT'] == 443) ? "s" : "") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER["PHP_SELF"];
$path = dirname($url) ;

$html = "
<html>
    <head>
        <meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>

        <style>
    * { padding: 0; margin: 0; font-size: 14px; }
    @font-face {
        font-family:JosefinSans;
        font-style: normal;
        font-weight: normal;
        src: url($path/fonts/JosefinSans-Regular.ttf) format('truetype');
      }
      @font-face {
        font-family:JosefinSans;
        font-style: normal;
        font-weight: bold;
        src: url($path/fonts/JosefinSans-Bold.ttf) format('truetype');
      }
      h1 {
        font-size: 30px;
        font-weight: bold;
        letter-spacing: 0.05em;
      }
      h2 {
        font-size: 25px; font-weight: normal;
        letter-spacing: 0.05em;
        margin: 30px 0 30px;
      }
      .main-title{
        text-align: center;
        line-height: 30px;
      }
      .main-title h1,  .main-title h2 {
        margin: 0;
      }
</style>
    </head>
    <body>

<div style='font-family:JosefinSans, sans-serif; margin: 50px 50px; color: #24586A;'";

$styleBreak = "";
if($quater != 99){
  $styleBreak = "page-break-before: always;";
$html .= "<div class='main-title'>
  <h1>$district_name:<h1>
  <h2>$img1_title</h2>
  <h2>Total number of users: $user_count</h2>
</div>
<br>
<h2>TEAM REPORT</h2>
<img src='$imgteam' width='700' height='350' />
";
}

foreach ( $images as $key => $img){
  if($key == 0){
      $html .= "
      <div style='$styleBreak margin-top: 50px' ></div> 
      <div class='main-title'>
      <h1>$district_name:<h1>
      <h2>$img1_title</h2>
      <h2>Total number of users: $user_count</h2>
    </div>
      <h2 style='padding-top: 0; '>MEMBER REPORT</h2>
      ";
  }
  $html .= "
  <img src='$img' width='500' height='250' />
  ";
  $styleBreak = "page-break-before: always;";
}
$html .= "</div>
</body>
</html>
";




// instantiate and use the dompdf class
$dompdf = new Dompdf(array('enable_remote' => true, 'isFontSubsettingEnabled' => false, 'defaultMediaType' => 'all'));
$dompdf->loadHtml($html);

// (Optional) Setup the paper size and orientation
//$dompdf->setPaper('A4', 'landscape');


// Render the HTML as PDF
$dompdf->render();

// Output the generat
//$dompdf->stream($filename, array("Attachment" => true));

$output = $dompdf->output();
$file =  dirname(__FILE__) . '/export/' .  $filename;
file_put_contents($file, $output);

//$dompdf->stream("dompdf_out.pdf", array("Attachment" => false));



//exit(0);

//echo $img1;
//echo "<img src='$img1' width=750 height=400/>"
  return array(
    "url" =>  plugin_dir_url( __FILE__ ) . '/export/' . $filename,
    "file" => $file
  );
}
