<?php


// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

require_once  LP_ADDON_LEARNDOREPORTS_INC . 'data/data-team.php';
require_once  LP_ADDON_LEARNDOREPORTS_INC . 'graphs/bar_graph_team.php';
require_once  LP_ADDON_LEARNDOREPORTS_INC . 'pdf/pdf-team.php';


    /**
     * Return the pdf file
     */
    function getDistrictReport($district_id, $quater, $year, $from, $to){
        $district_id = trim($district_id);
        
        $team_graph = getTeamGraph($district_id, $quater, $year, $from, $to);
        $member_graphs = getMemberGraphs($district_id, $quater, $year, $from, $to);
        $team_count = $member_graphs["team_count"];

        $district = get_post( $district_id ); 
        $district_name = $district->post_title;

        /* $pdf = plugin_dir_url( __FILE__ ) . "../pdf/pdf-team.php?imgteam=". $team_graph . 
        "&from=$from&to=$to&district=" . $district_name . 
        "&usercount=" . $team_count; */

        $file_name_pdf = "team_report_d". $district_id . rand(10,1000) . "_q".  $quater . "_" .  $year . ".pdf";
        
        if($quater == 99){
            $file_name_pdf = "team_report_d". $district_id . rand(10,1000) . "$from-$to.pdf";
        }
        
        $pdf = createPdf($file_name_pdf,$from, $to, $district_name, $team_graph, $member_graphs["graphs"], $team_count, $quater);

        return array(
            "pdf" => $pdf,
            "csv" => "",
            "team_graph" => $team_graph,
            "member_graphs" => $member_graphs
        );

    }

    /**
     * 
     */ 
    function getTeamGraph($district_id, $quater, $year, $from, $to){
                // CACLC FROm to dates

                $data_m = array();
                $values_m = array();
                $titles_m = array();

                for($i = 1; $i <= 3; $i++){
                    $m = (($quater * 3)-3) + $i;
                    //echo 'Monat: ' . $m . ' ';
                    $from_m = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
                    $to_m = date("Y-m-d", mktime(0, 0, 1, $m+1, 0, $year));
                    //echo $from_m . ' - ' .  $to_m . '</br>';
                    $data_m[] = getTeamData($from_m,$to_m, $district_id);
                    $titles_m [] = date("M", mktime(0, 0, 1, $m, 1, $year));
                }

                foreach($data_m as $dm){
                    $started = 0;
                    $completed = 0;
                    $downloads = 0;
                    foreach($dm as $dmu){
                        $started += intval($dmu["course_started"]);
                        $completed += intval($dmu["course_completed"]);
                        $downloads += intval($dmu["downloads"]);
                    }
                    //$values_m[]
                    $values_m[0][] = $started;
                    $values_m[1][] = $completed;
                    $values_m[2][] = $downloads;
                }

                $values_m[0][] = 0;
                $values_m[1][] = 0;
                $values_m[2][] = 0;
                $titles_m[] = "";

                $file_name_team = "team_report_d". $district_id ."_q".  $quater . "_" .  $year . ".png";
                $queries = array(
                    "from" => $from,
                    "to"	=> $to,
                    "values" => $values_m,
                    "filename" => $file_name_team,
                    "titles" => $titles_m,
                    "team" => true 
                );


                $queryString_team = http_build_query($queries);
                createGraphPdf($values_m, $titles_m, $from, $to, true, $file_name_team);
                //$graph_team_url = plugin_dir_url( __FILE__ ) . "../graphs/bar_graph_team.php?" . $queryString_team;
                $graph_team_href = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/graphs/export/" . $file_name_team;

                return $graph_team_href;
    }
    
    function getMemberGraphs($district_id, $quater, $year, $from, $to){
        $file_name_prefix = "team_report_d". $district_id ."_q".  $quater . "_" .  $year . "_";
        $graphs = array();
        $data = getTeamData($from,$to, $district_id);

        $values_members = array();
        $titles_members = array();
        
        $count = 0; // current user
        $group = -1; // current group id
        $group_size = 6; // users per graph
         foreach($data as $item){
            $title = (string)$item["user_name"];

            if ($count % $group_size  == 0){
                $group++;
            }
            $values_members[$group][0][] =intval($item["course_started"]);
            $values_members[$group][1][] = intval($item["course_completed"]);
            $values_members[$group][2][] = intval($item["downloads"]);
            $titles_members[$group][] = $title;

            $count++;
        } 

        // fill empty groups
        for ($i = $count; $i <= (($group + 1)*$group_size); $i++) {
            $values_members[$group][0][] = 0;
            $values_members[$group][1][] = 0;
            $values_members[$group][2][] = 0;
            $titles_members[$group][] = "";
        }


        /* ?> <pre> <?php var_dump($values_members); ?> </pre> <?php */
        
        // create group graphs
        foreach($values_members as $group => $values){
            $file_name_monthly =  $file_name_prefix . $group . ".png";
            $queries1 = array(
                "from" => $from,
                "to"	=> $to,
                "values" => $values,
                "filename" => $file_name_monthly,
                "titles" => $titles_members[$group]
            );
            $queryString1 = http_build_query($queries1);
            //$graph_team_url1 = plugin_dir_url( __FILE__ ) . "../graphs/bar_graph_team.php?" . $queryString1;
            createGraphPdf($values_members[$group], $titles_members[$group], $from, $to, false, $file_name_monthly);
            $graph_monthly_href1 = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/graphs/export/" . $file_name_monthly;
            //$graphs[] = $graph_monthly_href1;
            $graphs[] = $graph_monthly_href1;
        }
       
        
        return array(
            "team_count" => count($data),
            "graphs" => $graphs
            
        );
    
    }
