<?php

function getDownloadablesData($from, $to){
    global $wpdb; //This is used only if making any database queries


    $posts = get_posts([
        'post_type' => 'product',
        'post_status' => 'publish',
        'numberposts' => -1,
        'has_password'   => FALSE,
         'order'    => 'ASC'
    ]);

    foreach ($posts as $post) {
        $course = learn_press_get_course( $post->ID );
        $product_id =  $post->ID;

        $course_purchases = $wpdb->get_results("

        SELECT o.ID as order_id, o.post_date, woot.meta_value AS order_total, 
        items.order_item_name AS name, items.order_item_id,
        p.meta_value as product_id, 
        c.meta_value as course_id,
        itotal.meta_value+itax.meta_value as item_total
        FROM `wp_posts` AS o
                LEFT JOIN wp_postmeta AS woot
                ON o.ID = woot.post_id AND woot.meta_key = '_order_total'
        
                JOIN wp_woocommerce_order_items AS items
                ON o.ID = items.order_id AND items.order_item_type = 'line_item'
        
                LEFT JOIN wp_woocommerce_order_itemmeta as p
                ON items.order_item_id = p.order_item_id AND p.meta_key = '_product_id'
        
                LEFT JOIN wp_woocommerce_order_itemmeta as c
                ON items.order_item_id = c.order_item_id AND c.meta_key = '_course_id'
        
                LEFT JOIN wp_woocommerce_order_itemmeta as itotal
                ON items.order_item_id = itotal.order_item_id AND itotal.meta_key = '_line_total'
        
                LEFT JOIN wp_woocommerce_order_itemmeta as itax
                ON items.order_item_id = itax.order_item_id AND itax.meta_key = '_line_tax'
        
        WHERE o.post_type = 'shop_order'
        AND o.post_status = 'wc-completed'
        AND woot.meta_value > 0
        AND p.meta_value = '$post->ID'
        AND o.post_date between '$from' and '$to'
        ;");

        $revenue_downloadables = 0;
        foreach($course_purchases as $purchase){
            $revenue_downloadables += $purchase->item_total;
        }

        $table_name = $wpdb->prefix . 'learnpress_downloadables_tracking';

        $downloads =  $wpdb->get_results("
            SELECT * FROM $table_name
            WHERE product_id = $post->ID
            AND time between '$from' and '$to'
        ");

        $downloads_subscribers =  $wpdb->get_results("
            SELECT * FROM $table_name
            WHERE product_id = $post->ID
            AND is_member = 1
            AND time between '$from' and '$to'
        ");

        $items[] =
            [ 
                "product_name" =>  $post->ID . ': ' .get_the_title($post),
                "single_purchase" => count($course_purchases),
                "downloads" => count($downloads),
                "downloads_subscribers" => count($downloads_subscribers),
                "revenue" => wc_price($revenue_downloadables),
                "float_revenue" => $revenue_downloadables
            ]
        ;
    };

    return $items;

}
    

?>