<?php
/**
 * LearnPress Admin Page Overview
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

require_once  LP_ADDON_LEARNDOREPORTS_INC . 'data/data-downloadables.php';

if (!class_exists('WP_List_Table')) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

function learndo_reports_add_menu_item_downloadables() {
	add_submenu_page('learndo-reports', 'Downloadables', 'Downloadables', 'activate_plugins', 'learndo-reports-downloadables', 'learndo_reports_render_downloadables', 2);
}
add_action('admin_menu', 'learndo_reports_add_menu_item_downloadables');


function learndo_reports_render_downloadables() {
	?>
	
		<?php 
		$from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
		$to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1 ));
	
		//Create an instance of our package class...
		$downloadableTable = new LearnDo_Reports_Downloadables_Table();
		//Fetch, prepare, sort, and filter our data...
		$downloadableTable->prepare_items();
		?>
		<div class="wrap">
	
			<div id="icon-users" class="icon32"><br/></div>
			<h2>LearnDo Reports - Downloadables</h2>
			
			<form action="<?= esc_url(admin_url('admin.php')) ?>">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
				<input type="date" name="from_date" value="<?= $from ?>" />
				<input type="date" name="to_date" value="<?= $to ?>" />
				<input type="submit" value="Show" class="e-button" />

				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=&to_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1 )) ?>" class="button">All Time</a>
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m")-1, 1)) . "&to_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 0)) ?>" class="button">Last Month</a>
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 1)) . "&to_date=" .  date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1 )) ?>" class="button">Current Month</a>

				<?php // Create CSV
        $csv_href = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/csv/downloadables.csv";
        $f = fopen(LP_ADDON_LEARNDOREPORTS_INC . "/csv/downloadables.csv", "wa+"); 
        fputcsv($f, str_replace("title","$from - $to", array_keys($downloadableTable->items[0])));
        foreach ($downloadableTable->items as $row)
        {
            fputcsv($f, array_map("html_entity_decode",preg_replace("/<.+>/sU", "", $row)));
        }
        fclose($f);
        ?><a class="button alignright"  href="<?= $csv_href ?>" target="_blank">CSV download</a> 
			</form>
	
			<!-- Forms are NOT created automatically, so you need to wrap the table in one to use features like bulk actions -->
			<form id="movies-filter" method="get">
				<!-- For plugins, we also need to ensure that the form posts back to our current page -->
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
				<!-- Now we can render the completed list table -->
		<?php $downloadableTable->display() ?>

        <?php $total = 0;
		foreach($downloadableTable->items as $item){
			$total += $item["float_revenue"];
		} ?>
		<h2 class="alignright">Total: <?php echo wc_price($total) ?> </h2>

			</form>
	
		</div>
		<?php }

class LearnDo_Reports_Downloadables_Table extends WP_List_Table {

    function __construct() {
        global $status, $page;

        //Set parent defaults
        parent::__construct(array(
            'singular' => 'Nice Link', //singular name of the listed records
            'plural' => 'Nice Links', //plural name of the listed records
            'ajax' => false        //does this table support ajax?
        ));
    }

    function column_default($item, $column_name) {
        switch ($column_name) {
            case 'downloadable': return "<b>" . $item["product_name"] . "</b>";
            case 'single_purchase': return $item["single_purchase"];
			case 'downloads': return $item["downloads"];
			case 'downloads_subscribers': return $item["downloads_subscribers"];
			case 'revenue': return $item["revenue"];
            default:
                return "col name = $column_name , " . print_r($item, true); //Show the whole array for troubleshooting purposes
        }
    }

    function get_columns() {
        return $columns = array(
            'downloadable' => 'Doownloadable',
            'single_purchase' => __('Single-Course Purchase'),
            'downloads' => __('Downloads'),
			'downloads_subscribers' => __('Downloads (Subscribers)'),
            'revenue' => __('Revenue')
        );
    }
  
	function prepare_items() {

		$from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
		$to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1 ));

		$this->items = getDownloadablesData($from, $to);

        $columns = $this->get_columns();
        $hidden = array();
        $sortable = array();

        $this->_column_headers = array($columns, $hidden, $sortable);

		
    }
}