<?php
/**
 * Plugin Name: LearnPress Downloads
 * Plugin URI: https://albrightdesign.de
 * Description: Add downloads to learnpress
 * Version: 4.0.1
 * Author: Benjamin Albrecht
 * Author URI: https://albrightdesign.de
 * Require_LP_Version: 3.0.0
 * License: 
 */

 // add download to meta box
if ( ! function_exists( 'learnpress_downloads_add_custom_field_course' ) ) {
	function learnpress_downloads_add_custom_field_course() {
		lp_meta_box_text_input_field(
			array(
				'id'          => 'lpd_files',
				'label'       => esc_html__( 'Downloads', 'eduma' ),
				'description' => esc_html__( 'wpdm file Ids separeted by ;', 'eduma' ),
				'default'     => ''
			)
		);
	}
}

add_action( 'learnpress/course-settings/after-general', 'learnpress_downloads_add_custom_field_course' );

/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function lpd_save_meta_box( $post_id ) {
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if ( $parent_id = wp_is_post_revision( $post_id ) ) {
        $post_id = $parent_id;
    }
    $fields = [
        'lpd_files','thim_course_downloads'
    ];
    foreach ( $fields as $field ) {
        if ( array_key_exists( $field, $_POST ) ) {
            update_post_meta( $post_id, $field, sanitize_text_field( $_POST[$field] ) );
        }
     }
}
add_action( 'save_post', 'lpd_save_meta_box' );





/**
 * add download tab to courses
 *
 * 
 */

add_filter( 'learn-press/course-tabs', 'learndo_download_tab', 99999 );

/**
 * @param mixed $tabs
 * @return mixed
 */
function learndo_download_tab( $tabs ){

    if(count(lpd_get_files()) == 0)
        return $tabs;
    
	$tabs['downloads_tab'] = array(
		'title'    => __( 'Course Materials', 'wp-education' ),
		'priority' => 100000,
		'callback' => 'learndo_download_tab_content',
        'icon'     => 'fa-file-download'
    );
    $tabs['curriculum']['title']= __( 'Webinar', 'wp-education' );

	return $tabs;
}

/**
 * @return array
 */
function lpd_get_files(){
    $filesString = esc_attr( get_post_meta( get_the_ID(), 'lpd_files', true ) );
    if(strlen($filesString)){
        return explode(";", $filesString);
    }
    return array();
}

// Custom Tab content
if( !function_exists('learndo_download_tab_content') ){
	function learndo_download_tab_content(){
		?>
		<h3>Downloads</h3>
        <?php 
            $id = get_the_ID();
            $user_id = get_current_user_id();
            $user = learn_press_get_user($user_id);
            $enrolled = $user->has_enrolled_course($id);
            $finished = $user->has_finished_course($id);
            $filesIds = lpd_get_files(); 
         ?>
         <?php if($enrolled || $finished): ?>
            <?php foreach($filesIds as $file):?>
		        <p><?php echo do_shortcode("[wpdm_package id='". $file ."' template='link-template-default-old']") ?></p>
            <?php endforeach ?>
        <?php else: ?>
            <p>Enroll to the course to download the content.</p>
        <?php endif ?>
		<?php
	}
}
