<?php

/**
 * Send report quaterly
 * 
 */



function district_sendreport_cron_job()
{
    if (!wp_next_scheduled('district_sendreport_cron_job_run')) {
        wp_schedule_event(current_time('timestamp'), 'daily', 'district_sendreport_cron_job_run');
        wp_schedule_event(current_time('timestamp'), 'hourly', 'district_sendreport_cron_job_run');
    }
}

function district_sendreport_cron_job_run()
{
    if (in_array(date('n/j'), ['4/1', '7/1', '10/1', '1/1'], true)) {


        /* if (class_exists("WP_Background_Process")) {

        require_once plugin_dir_path(__FILE__) . 'background-processes/class-send-report.php';
        require_once plugin_dir_path(__FILE__) . 'background-processes/class-send-report-process.php';

        //file_put_contents(plugin_dir_path(__FILE__) . 'log_' . date("j.n.Y") . '.log', "send report: " . date("j.n.Y") . "\n", FILE_APPEND);


        $process_all  = new WP_Send_Report_Process();

        $districts = get_posts([
            'post_type' => 'learnpress_district',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        foreach ($districts as $district) {
            $process_all->push_to_queue($district->ID);
        }

        $process_all->save()->dispatch();
    }
    */

        $reports_plugin = WP_PLUGIN_DIR . '/learnpress-learndo-reports';
        $pdf_dir = $reports_plugin . '/inc/pdf/export';
        if (is_dir($reports_plugin)) {
            // plugin directory found!


            require_once $reports_plugin . '/inc/data/data-team-reports.php';
            $year = date("Y");
            $quater_current = ceil(date("n") / 3);
            $quater =  $quater_current - 1;
            if ($quater == 0) {
                $quater = 4;
                $year = $year - 1;
            }

            $m = (($quater * 3) - 3) + 1; // start month
            $from = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
            $m = (($quater * 3) - 3) + 3; // end month
            $to = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));


            $districts = get_posts([
                'post_type' => 'learnpress_district',
                'numberposts' => -1,
                'order'    => 'ASC'
            ]);


            foreach ($districts as $key => $district) {
                // Prepare reports
                $district_id =  $district->ID;

                // send reports
                $director_email = get_post_meta($district_id, 'director_email', true);

                if ($director_email != "") {
                    $report = getDistrictReport($district_id, $quater, $year, $from, $to);
                    districtSendReport($director_email, $district_id, $report);
                    //print "mail send"; die();
                }
            }
        }
    }
}

function districtSendReport($send_to, $district_id, $report)
{

    // send reports
    $district_name = get_the_title($district_id);

    $subject = 'District Reports';
    $body = 'District Report for ' .  $district_name . ' 
        <br>' . $report["pdf"]["url"];
    $headers = array('Content-Type: text/html; charset=UTF-8');
    //$attachments = array(ABSPATH . '/uploads/abc.png');
    $attachments = array($report["pdf"]["file"]);

    //wp_mail('ben@4bai.de', $subject, $body, $headers, $attachments);
    wp_mail($send_to, $subject, $body, $headers, $attachments);

    //print "mail send"; die();
}

function district_sendreport_cron_job_clear()
{
    wp_clear_scheduled_hook('district_sendreport_cron_job_run');
}


register_deactivation_hook(__FILE__, 'district_sendreport_cron_job_clear');

add_action('wp', 'district_sendreport_cron_job');
add_action('district_sendreport_cron_job_run', 'district_sendreport_cron_job_run');





// Batch from the backend
if (class_exists('WP_Batch')) {

    /**
     * Class DistrictReport_Batch
     */
    class DistrictReport_Batch extends WP_Batch
    {

        /**
         * Unique identifier of each batch
         * @var string
         */
        public $id = 'district_report_batch';

        /**
         * Describe the batch
         * @var string
         */
        public $title = 'Email District Report to all District Directors';

        /**
         * To setup the batch data use the push() method to add WP_Batch_Item instances to the queue.
         *
         * Note: If the operation of obtaining data is expensive, cache it to avoid slowdowns.
         *
         * @return void
         */
        public function setup()
        {

            $districts = get_posts([
                'post_type' => 'learnpress_district',
                'numberposts' => -1,
                'order'    => 'ASC'
            ]);

            foreach ($districts as $district) {
                $this->push(new WP_Batch_Item(
                    $district->ID,
                    array('district_id' => $district->ID,)
                ));
            }
        }

        /**
         * Handles processing of batch item. One at a time.
         *
         * In order to work it correctly you must return values as follows:
         *
         * - TRUE - If the item was processed successfully.
         * - WP_Error instance - If there was an error. Add message to display it in the admin area.
         *
         * @param WP_Batch_Item $item
         *
         * @return bool|\WP_Error
         */
        public function process($item)
        {

            // Retrieve the custom data
            $district_id = $item->get_value('district_id');
            $director_email = get_post_meta($district_id, 'director_email', true);


            // Return WP_Error if the item processing failed (In our case we simply skip author with user id 5)
            /* if ($author_id == 5) {
                return new WP_Error(302, "Author skipped");
            } */
            /* if ($director_email == "" || $director_email == null) {
                return new WP_Error(302, "Director email not valid");
            } */


            // Do the expensive processing here. eg. Sending email.
            // ...



            $reports_plugin = WP_PLUGIN_DIR . '/learnpress-learndo-reports';
            $pdf_dir = $reports_plugin . '/inc/pdf/export';
            if (is_dir($reports_plugin)) {
                // plugin directory found!


                require_once $reports_plugin . '/inc/data/data-team-reports.php';
                $year = date("Y");
                $quater_current = ceil(date("n") / 3);
                $quater =  $quater_current - 1;
                if ($quater == 0) {
                    $quater = 4;
                    $year = $year - 1;
                }

                $m = (($quater * 3) - 3) + 1; // start month
                $from = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
                $m = (($quater * 3) - 3) + 3; // end month
                $to = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));

                try {
                    $report = getDistrictReport($district_id, $quater, $year, $from, $to);
                    districtSendReport($director_email, $district_id, $report);
                } catch (Exception $e) {
                    return new WP_Error(302, $e->getMessage());
                }
            }

            // Return true if the item processing is successful.
            return true;
        }

        /**
         * Called when specific process is finished (all items were processed).
         * This method can be overriden in the process class.
         * @return void
         */
        public function finish()
        {
            // Do something after process is finished.
            // You have $this->items, or other data you can set.
        }
    }

    /**
     * Initialize the batches.
     */
    function wp_batch_processing_init_district_reports()
    {
        $batch = new DistrictReport_Batch();
        WP_Batch_Processor::get_instance()->register($batch);
    }

    add_action('wp_batch_processing_init', 'wp_batch_processing_init_district_reports', 15, 1);
}
