<?php

trait WP_District_Send_Report
{
    public function send_report($district_id)
    {
        $director_email = get_post_meta($district_id, 'director_email', true);

        var_dump($director_email);

        $reports_plugin = WP_PLUGIN_DIR . '/learnpress-learndo-reports';
        $pdf_dir = $reports_plugin . '/inc/pdf/export';
        if (is_dir($reports_plugin)) {
            // plugin directory found!


            require_once $reports_plugin . '/inc/data/data-team-reports.php';
            $year = date("Y");
            $quater_current = ceil(date("n") / 3);
            $quater =  $quater_current - 1;
            if ($quater == 0) {
                $quater = 4;
                $year = $year - 1;
            }

            $m = (($quater * 3) - 3) + 1; // start month
            $from = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
            $m = (($quater * 3) - 3) + 3; // end month
            $to = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));

            try {
                $report = getDistrictReport($district_id, $quater, $year, $from, $to);
                $this->districtSendReport($director_email, $district_id, $report);
            } catch (Exception $e) {
                return new WP_Error(302, $e->getMessage());
            }
        }
    }

    function districtSendReport($send_to, $district_id, $report)
    {

        // send reports
        $district_name = get_the_title($district_id);

        $subject = 'District Reports';
        $body = 'District Report for ' .  $district_name . ' 
        <br>' . $report["pdf"]["url"];
        $headers = array('Content-Type: text/html; charset=UTF-8');
        //$attachments = array(ABSPATH . '/uploads/abc.png');
        $attachments = array($report["pdf"]["file"]);

        wp_mail('ben@4bai.de', $subject, $body, $headers, $attachments);
        //wp_mail($send_to, $subject, $body, $headers, $attachments);

        //print "mail send"; die();
    }
}
