<?php
/**
 * Plugin load class.
 *
 * @author   ThimPress
 * @package  LearnPress/DISTRICT/Classes
 * @version  4.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'LP_Addon_District' ) ) {
	/**
	 * Class LP_Addon_District.
	 */
	class LP_Addon_District extends LP_Addon {

		/**
		 * @var string
		 */
		protected $_tab_slug_District = '';


		/**
		 * @var string
		 */
		public $version = LP_ADDON_DISTRICT_VER;

		/**
		 * @var string
		 */
		public $require_version = LP_ADDON_DISTRICT_REQUIRE_VER;

		/**
		 * Path file addon
		 *
		 * @var string
		 */
		public $plugin_file = LP_ADDON_DISTRICT_FILE;

		/**
		 * LP_Addon_Wishlist constructor.
		 */
		public function __construct() {
			parent::__construct();
			//add_filter( 'learn-press/profile-tabs', array( $this, 'District_tab' ), 101, 1 );
			$this->_tab_slug_District = sanitize_title( __( 'District', 'learnpress-district' ) );
			
			add_action( 'widgets_init', array( $this, 'load_widget' ) );
		}

		/**
		 * Defined constants.
		 */
		protected function _define_constants() {
			define( 'LP_ADDON_DISTRICT_PATH', dirname( LP_ADDON_DISTRICT_FILE ) );
			define( 'LP_ADDON_DISTRICT_INC', LP_ADDON_DISTRICT_PATH . '/inc/' );
			define( 'LP_ADDON_DISTRICT_TEMPLATE', LP_ADDON_DISTRICT_PATH . '/templates/' );
		}

		/**
		 * Includes files.
		 */
		protected function _includes() {
			include_once LP_ADDON_DISTRICT_INC . 'functions.php';
			require_once LP_ADDON_DISTRICT_INC . 'widgets.php';
			include_once LP_ADDON_DISTRICT_INC . 'admin/admin-notice.php';
			include_once LP_ADDON_DISTRICT_INC . 'admin/page-manager.php';
			include_once LP_ADDON_DISTRICT_INC . 'admin/page-settings.php';

			include_once LP_ADDON_DISTRICT_INC . 'mail/send_reports.php';



		}

		/**
		 * Init hooks.
		 */
		protected function _init_hooks() {
			$this->rewrite_endpoint();
		}


		/**
		 * Wishlist scripts.
		 */
		protected function _enqueue_assets() {
		}

		/**
		 * Rewrite endpoint.
		 */
		public function rewrite_endpoint() {
			$endpoint                     = preg_replace( '!_!', '-', $this->get_District_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );
		}

		public function profile_tab_endpoints( $endpoints ) {
			$endpoints[] = $this->get_District_tab_slug();

			return $endpoints;
		}

		public function get_District_tab_slug() {
			return apply_filters( 'learn_press_District_tab_slug', $this->_tab_slug_District, $this );
		}


		/**
		 * Add Wishlist tab to user profile.
		 *
		 * @param $tabs
		 *
		 * @return mixed
		 */
		public function District_tab( $tabs ) {
			$tabs[ $this->get_District_tab_slug() ] = array(
				'title'    => __( 'School District', 'learnpress-district' ),
				'slug'     => $this->get_District_tab_slug(),
				'callback' => array( $this, 'District_tab_content' ),
				'priority' => 1,
				'icon'     => '<i class="fas fa-school" aria-hidden="true"></i>',
			);

			return $tabs;
		}

		/**
		 * Display content of tab PMPRO Account.
		 *
		 * @param $tab
		 * @param $tabs
		 * @param $profile
		 */
		public function District_tab_content( $tab, $tabs, $profile ) {
			$viewing_user = $profile->get_user();
			learn_press_district_template(
				'district-dashboard.php',
				array(
					'District' => 'content'
				)
			);
		}

		 public function load_widget() {
			//register_widget( 'LP_Widget_Pricing_Link' );
		}


	}
}

add_action( 'plugins_loaded', array( 'LP_Addon_District', 'instance' ) );
