<?php


function users_meta_box() {

$screens = array( 'learnpress_district' );

foreach ( $screens as $screen ) {
    add_meta_box(
        'users',
        __( 'Stundents', 'learnpress_district' ),
        'users_meta_box_callback',
        $screen
    );
}
}

function users_meta_box_callback( $post ) {

    $remove_user = array_key_exists('remove_user', $_GET) ? $_GET['remove_user'] : NULL;
    if($remove_user){
        update_user_meta( $remove_user, 'district_id',  '' );
        echo 'user removed: ' . $remove_user;
    }


    $args = array(
        'meta_query' => array(
            array(
                'key' => 'district_id',
                'value' => esc_attr(  $post->ID ),
                'compare' => '='
            )
        )
    );
    $member_arr = get_users($args);
    $url_parts = parse_url( home_url() );
    $current_url_with_query_string = $url_parts['scheme'] . "://" . $url_parts['host'] . add_query_arg( NULL, NULL );

    echo '<table class="wp-list-table widefat fixed striped table-view-list">';
    if ($member_arr) {
      foreach ($member_arr as $user) {
        echo '<tr>';
        echo '<td><a href="'.get_edit_user_link($user->ID).'">'. $user->user_email . '</a></td>';

        $remove_url =  $current_url_with_query_string . '&remove_user=' . $user->ID;
        echo '<td><a class="alert" href="'. $remove_url .'">remove</a></td>';
        echo '</tr>';
      }
    } else {
      echo '<li>no users found</li>';
    }
    echo '</table>';
    

// Add a nonce field so we can check for it later.
wp_nonce_field( 'remove_user_nonce', 'remove_user_nonce' );

$value = get_post_meta( $post->ID, 'remove_user', true );




}

/**
*  LEA META BOX
* set the lea name of the district
* 
*/


add_action( 'add_meta_boxes', 'users_meta_box' );

/**
* When the post is saved, saves our custom data.
*
* @param int $post_id
*/
function remove_user_meta_box_data( $post_id ) {

// Check if our nonce is set.
if ( ! isset( $_POST['remove_user_nonce'] ) ) {
    return;
}

// Verify that the nonce is valid.
if ( ! wp_verify_nonce( $_POST['remove_user_nonce'], 'remove_user_nonce' ) ) {
    return;
}

// If this is an autosave, our form has not been submitted, so we don't want to do anything.
if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
    return;
}

// Check the user's permissions.
if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

    if ( ! current_user_can( 'edit_page', $post_id ) ) {
        return;
    }

}
else {

    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
}

/* OK, it's safe for us to save the data now. */

// Make sure that it is set.
if ( ! isset( $_POST['add_user'] ) ) {
    return;
}

// Sanitize user input.
$my_data = sanitize_text_field( $_POST['remove_user'] );
$user = get_user_by('id', $my_data);
if($user){
    $user_id = $user->ID;
    update_user_meta( $user_id, 'district_id',  $post_id );
    return "added";
}



// Update the meta field in the database.
 //update_post_meta( $post_id, 'add_user', $my_data );
}

add_action( 'save_post', 'remove_user_meta_box_data' );
