<?php


function lea_name_meta_box() {

$screens = array( 'learnpress_district' );

foreach ( $screens as $screen ) {
    add_meta_box(
        'lea-name',
        __( 'LEA Name', 'learnpress_district' ),
        'lea_name_meta_box_callback',
        $screen
    );
}
}

function lea_name_meta_box_callback( $post ) {

// Add a nonce field so we can check for it later.
wp_nonce_field( 'lea_name_nonce', 'lea_name_nonce' );

$value = get_post_meta( $post->ID, 'lea_name', true );

echo '<input type="text" style="" id="lea_name" name="lea_name" value="' . esc_attr( $value ) . '"/>';



$assign_all = array_key_exists('asign_all_lea', $_GET) ? true : false;

if($assign_all){
    echo '<h4>All users assigned: </h4><ul>';
} else {
    echo '<h4> Found Users with lea name</h4><ul>';
}

$args = array(
    'meta_query' => array(
        array(
            'key' => 'lea_name',
            'value' => esc_attr( $value ),
            'compare' => '='
        )
    )
);
$member_arr = get_users($args);
if ($member_arr) {
  foreach ($member_arr as $user) {
    echo '<li><a href="'.get_edit_user_link($user->ID).'">'. $user->user_email . '</a></li>';
  }
} else {
  echo '<li>no users found</li>';
}

echo '</ul>';

$assign_all = array_key_exists('asign_all_lea', $_GET) ? true : false;
if( $assign_all){
    foreach($member_arr as $user){
        update_user_meta($user->ID, 'district_id', $post->ID . "" );
    } 
} else {
    $url_parts = parse_url( home_url() );
    $current_url_with_query_string = $url_parts['scheme'] . "://" . $url_parts['host'] . add_query_arg( NULL, NULL );
    
        echo ('
        <a href="' . $current_url_with_query_string .'&asign_all_lea=1"  class="e-button">Assign all</a>
        ');
}


}

/**
*  LEA META BOX
* set the lea name of the district
* 
*/


add_action( 'add_meta_boxes', 'lea_name_meta_box' );

/**
* When the post is saved, saves our custom data.
*
* @param int $post_id
*/
function save_lea_name_meta_box_data( $post_id ) {

// Check if our nonce is set.
if ( ! isset( $_POST['lea_name_nonce'] ) ) {
    return;
}

// Verify that the nonce is valid.
if ( ! wp_verify_nonce( $_POST['lea_name_nonce'], 'lea_name_nonce' ) ) {
    return;
}

// If this is an autosave, our form has not been submitted, so we don't want to do anything.
if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
    return;
}

// Check the user's permissions.
if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

    if ( ! current_user_can( 'edit_page', $post_id ) ) {
        return;
    }

}
else {

    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
}

/* OK, it's safe for us to save the data now. */

// Make sure that it is set.
if ( ! isset( $_POST['lea_name'] ) ) {
    return;
}

// Sanitize user input.
$my_data = sanitize_text_field( $_POST['lea_name'] );

// Update the meta field in the database.
update_post_meta( $post_id, 'lea_name', $my_data );
}

add_action( 'save_post', 'save_lea_name_meta_box_data' );

