<?php


function director_meta_box() {

$screens = array( 'learnpress_district' );

foreach ( $screens as $screen ) {
    add_meta_box(
        'director',
        __( 'Director', 'learnpress_district' ),
        'director_meta_box_callback',
        $screen
    );
}
}

function director_meta_box_callback( $post ) {

// Add a nonce field so we can check for it later.
wp_nonce_field( 'director_nonce', 'director_nonce' );

$value = get_post_meta( $post->ID, 'director_email', true );
echo '<label>Director E-Mail</label>';
echo '<input type="email" style="" id="director_email" name="director_email" value="' . esc_attr( $value ) . '"/>';
echo '<input class="button" type="submit" value="Save" />';

}

/**
*  LEA META BOX
* set the lea name of the district
* 
*/


add_action( 'add_meta_boxes', 'director_meta_box' );

/**
* When the post is saved, saves our custom data.
*
* @param int $post_id
*/
function save_director_meta_box_data( $post_id ) {

// Check if our nonce is set.
if ( ! isset( $_POST['director_nonce'] ) ) {
    return;
}

// Verify that the nonce is valid.
if ( ! wp_verify_nonce( $_POST['director_nonce'], 'director_nonce' ) ) {
    return;
}

// If this is an autosave, our form has not been submitted, so we don't want to do anything.
if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
    return;
}

// Check the user's permissions.
if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

    if ( ! current_user_can( 'edit_page', $post_id ) ) {
        return;
    }

}
else {

    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
}

/* OK, it's safe for us to save the data now. */

// Make sure that it is set.
if ( ! isset( $_POST['director_email'] ) ) {
    return;
}

// Sanitize user input.
$director_email = sanitize_text_field( $_POST['director_email'] );
update_post_meta( $post_id, 'director_email', $director_email );

/*
$user = get_user_by('email', $my_data);
if($user){
    $user_id = $user->ID;
    update_user_meta( $user_id, 'district_id',  $post_id );
    AdminNotice::displaySuccess(__('User added: ' . $my_data));
    return "added";
} else {
    AdminNotice::displayError(__('User not found:' . $my_data ));
}
*/



// Update the meta field in the database.
 //update_post_meta( $post_id, 'director', $my_data );
}

add_action( 'save_post', 'save_director_meta_box_data' );

add_action('admin_notices', [new AdminNotice(), 'displayAdminNotice']);

