<?php


class Mtm_2F_SMS extends Mtm_2F_Methode {

	static function get_Instance() {
		static $instance;
		$class = __CLASS__;
		// if instance not initial
		if ( ! isset( $instance ) ) {
			// Creates Class Object and set Instance
			$instance = new $class;
		}

		// Returns the instance
		return $instance;
	}


	function sendPasswort( $Passwort, $user ) {
		$CurrentUserData = get_userdata( $user->ID );
		$Empfaenger      = $CurrentUserData->user_email;
		$Betreff         = "Einmalpasswort für " . $CurrentUserData->user_firstname . " " . $CurrentUserData->user_lastname;
		if ( ! is_wp_error( $this->sendSMS( array(
			"phone_number" => $CurrentUserData->get( "phone_number" ),
			"firstname"    => $CurrentUserData->user_firstname,
			"lastname"     => $CurrentUserData->user_lastname,
			"email"        => $CurrentUserData->user_email,
			"blogname"     => get_bloginfo("name"),
			"blogurl"      => get_bloginfo("url"),
			"passkey"      => $Passwort
		) ) ) ) {
			return true;
		}

		return false;
	}

	/**
	 * Versendet eine SMS per API über Clicksend
	 *
	 * @param $params
	 *
	 * @return false|mixed|string
	 */
	function sendSMS( $params ) {
		try {
			//Clicksend Username und Passwort
			$username = get_option( 'mtm_2F_clicksend_username' );
			$password = get_option( 'mtm_2F_clicksend_password' );
			$sender   = get_option( 'mtm_2F_clicksend_sender' );

			$url = "https://rest.clicksend.com/v3/sms/send";

			$data = array();

			$mtm_2F_clicksend_phone_number = '';
			if ( isset( $params['phone_number'] ) ) {
				$mtm_2F_clicksend_phone_number = sanitize_text_field( $params['phone_number'] );
			}
			$mtm_2F_clicksend_firstname = '';
			if ( isset( $params['firstname'] ) ) {
				$mtm_2F_clicksend_firstname = sanitize_text_field( $params['firstname'] );
			}
			$mtm_2F_clicksend_lastname = '';
			if ( isset( $params['lastname'] ) ) {
				$mtm_2F_clicksend_lastname = sanitize_text_field( $params['lastname'] );
			}
			$mtm_2F_clicksend_email = '';
			if ( isset( $params['email'] ) ) {
				$mtm_2F_clicksend_email = sanitize_email( $params['email'] );
			}

			$message           = array();
			$message['source'] = 'wordpress';
			if ( ! empty( $sender ) ) {
				$message['from'] = $sender;
			}

			$needle = array(
				"{blogurl}",
				"{blogname}",
				"{first_name}",
				"{last_name}",
				"{passkey}"
			);
			$replace = array(
				$params["blogurl"],
				$params["blogname"],
				$mtm_2F_clicksend_firstname,
				$mtm_2F_clicksend_lastname,
				$params["passkey"]
			);
			$message['body']                    = str_replace($needle, $replace,get_option("mtm_2F_clicksend_msg"));
			$mtm_2F_clicksend_customer_sms_body = get_option( 'clicksend_customer_sms_body' );
			if ( ! empty( $clicksend_customer_sms_body ) ) {
				$message['body'] = $clicksend_customer_sms_body;
			}

			$message['to'] = $mtm_2F_clicksend_phone_number;
			if ( ! empty( $clicksend_country ) ) {
				$message['country'] = $clicksend_country;
			}

			$data['messages'][] = $message;

			$data = json_encode( $data );

			$header = array(
				"Content-Type"   => "application/json",
				"Content-Length" => strlen( $data ),
				"Authorization"  => "Basic " . base64_encode( $username . ":" . $password )
			);

			$body     = $data;
			$args     = array(
				'headers' => $header,
				'body'    => $body,
			);
			$response = wp_safe_remote_post( $url, $args );

			return $response['body'];

		} catch ( Exception $e ) {
			return json_encode( array( 'error' => '1', 'message' => $e->getMessage() ) );
		}
	}

	function getDisplayName() {
		return __( "SMS", MTM_2F_TEXT_DOMAIN );
	}


	/**
	 * Check if user phone_number and 2F actiovate are set.
	 *
	 * @param $user
	 *
	 * @return bool
	 */
	function checkUserCanUseMethode( $user ) {
		if ( !empty( get_user_meta( $user->ID, "phone_number" )[0] ) ) {
			return true;
		}

		return false;
	}

	function printnotificationtext( $user ) {
		$phone_number = $user->get( "phone_number" );
		echo esc_html( sprintf( __( 'An SMS was sent to %s ', MTM_2F_TEXT_DOMAIN ), $phone_number ) );
	}
}