<?php


class Mtm_2F_EMail extends Mtm_2F_Methode {

	static function get_Instance() {
		static $instance;
		$class = __CLASS__;
		// if instance not initial
		if ( ! isset( $instance ) ) {
			// Creates Class Object and set Instance
			$instance = new $class;
		}

		// Returns the instance
		return $instance;
	}


	function getDisplayName() {
		return __( "E-Mail", MTM_2F_TEXT_DOMAIN );
	}

	function sendPasswort( $Passwort, $user ) {
		$CurrentUser = get_userdata( $user->ID );
		$Empfaenger  = $CurrentUser->user_email;
		$Betreff     = "Einmalpasswort für " . $CurrentUser->first_name . "" . $CurrentUser->last_name;
		$CurrentUserData = get_userdata( $user->ID );
		$params = array(
			"phone_number" => $CurrentUserData->get( "phone_number" ),
			"firstname"    => $CurrentUserData->user_firstname,
			"lastname"     => $CurrentUserData->user_lastname,
			"email"        => $CurrentUserData->user_email,
			"blogname"     => get_bloginfo("name"),
			"blogurl"      => get_bloginfo("url"),
			"passkey"      => $Passwort
		);


		$needle = array(
			"{blogurl}",
			"{blogname}",
			"{first_name}",
			"{last_name}",
			"{passkey}"
		);
		$replace = array(
			$params["blogurl"],
			$params["blogname"],
			$params["firstname"],
			$params["lastname"],
			$params["passkey"]
		);

		$message = str_replace($needle, $replace,get_option("mtm_2F_clicksend_msg"));

		if(wp_mail( $Empfaenger, $Betreff, $message )){
			return true;
		}
	}


	/**
	 * Check if user e-mail address are set.
	 * Normaly return true because user need an e-mail address on registration
	 *
	 * @param $user
	 *
	 * @return bool
	 */
	function checkUserCanUseMethode( $user ) {
		$usermeta = get_userdata( $user->ID );
		if ( isset( $usermeta->user_email ) ) {
			return true;
		}

		return false;
	}

	function printnotificationtext( $user ) {
		$user = get_userdata( $user->ID );
		echo esc_html( sprintf( __( "An e-mail was send to %s", MTM_2F_TEXT_DOMAIN ), $user->user_email ) );
	}
}