<?php


class Mtm_2F_woo_frontend {

	public function __construct() {
		$this->mtm_2F_iní_woo_endpoint();
	}

	private function mtm_2F_iní_woo_endpoint(){
		add_action( 'init', array($this, 'mtm_2F_woo_endpoint') );
		add_filter( 'query_vars', array($this, 'mtm_2F_woo_query_vars'), 0 );
		register_activation_hook( __FILE__, array($this,'mtm_2F_woo_flush_rewrite_rules') );
		register_deactivation_hook( __FILE__, array($this,'mtm_2F_woo_flush_rewrite_rules') );
		add_filter( 'woocommerce_account_menu_items', array($this, 'mtm_2F_woo_my_account_menu_items') );
		add_action( 'woocommerce_account_mtm-2FA_endpoint', array($this, 'mtm_2F_woo_html_content') );
		add_action( 'wp_ajax_mtm_2F_woo_save', array( $this, 'mtm_2F_woo_save_form') );
	}

	/**
	 * Flush rewrite rules on plugin activation.
	 */
	public function mtm_2F_woo_flush_rewrite_rules() {
		add_rewrite_endpoint( 'mtm-2FA', EP_ROOT | EP_PAGES );
		flush_rewrite_rules();
	}

	public function mtm_2F_woo_endpoint() {
		add_rewrite_endpoint( 'mtm-2FA', EP_ROOT | EP_PAGES );
	}

    public function mtm_2F_woo_query_vars( $vars ) {
		$vars[] = 'mtm-2FA';

		return $vars;
	}

	/**
	 * Insert the new endpoint into the My Account menu.
	 *
	 * @param array $items
	 * @return array
	 */
	public function mtm_2F_woo_my_account_menu_items( $items ) {
		// Remove the logout menu item.
		$logout = $items['customer-logout'];
		unset( $items['customer-logout'] );

		// Insert your custom endpoint.
		$items['mtm-2FA'] = __( 'Two Factor Authentification', MTM_2F_TEXT_DOMAIN );

		// Insert back the logout item.
		$items['customer-logout'] = $logout;

		return $items;
	}

	/**
	 * Endpoint HTML content.
	 */
	public function mtm_2F_woo_html_content() {
		wp_enqueue_script( 'mtm_2F_Profil_js', plugins_url('includes' . DIRECTORY_SEPARATOR . 'js' . DIRECTORY_SEPARATOR . 'mtm_2F_profile.js', __FILE__));
		wp_enqueue_style( 'mtm_2F_Profil_css', plugins_url('includes' . DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR . 'mtm_2F_profile.css', __FILE__));
		wp_localize_script( 'mtm_2F_Profil_js', 'mtm_ajax_obj',
			array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),
                    "userID" => get_current_user_id()) );
		?>
		<div id="mtm-2F-woo-page">
			<p><?php _e("On this page you can setup a Two Factor Authentification.", MTM_2F_TEXT_DOMAIN); ?></p>
			<div id="mtm-2F-woo-form">
				<form id="mtm-2f-woo-usermeta-form">
					<?php Mtm_2F_profil_fields::mtm_2F_profil_fields_html(wp_get_current_user());?>
                    <button type="submit">
                        Save Settings
                        <img src="<?php echo esc_url(plugins_url( 'includes/img/spinner.gif', __FILE__ )); ?>" id="mtm-save-spinner"/>
                    </button>
				</form>
			</div>
		</div>
		<?php
	}

	function mtm_2F_woo_save_form(){
		if(!isset($_POST['formdata'])){
			echo "Error: Form data missing";
			return false;
		}
		$formdata = $_POST["formdata"];
		$user_id = get_current_user_id();
		$use2F = "";
		$methode = "";
		$phonenumber="";
		foreach ($formdata as $field){
			switch ($field["name"]){
				case "mtm_2F_use_2FA":
					$use2F = $field["value"];
					break;
				case "mtm_2F_primary_methode":
					$methode = $field["value"];
					break;
				case "phone_number":
					$phonenumber = $field["value"];
					break;
			}
		}

		update_user_meta( $user_id, 'mtm_2F_use_2FA', $use2F );

		if ( preg_match( '/\+\d{1,3}\s\d{1,14}(\d{1,13})?/m', $phonenumber ) ) {
			//Maybe Validate phone_number with https://numverify.com/ json API?
			update_user_meta( $user_id, 'mtm_2F_primary_methode', $methode );
			update_user_meta( $user_id, 'phone_number', $phonenumber );
		} else {
			update_user_meta( $user_id, 'mtm_2F_primary_methode', "Mtm_2F_EMail");
			update_user_meta( $user_id, 'phone_number', "" );
		}


		$response = array(
			"mtm_2F_primary_methode" => get_user_meta($user_id, 'mtm_2F_primary_methode')[0],
			"phone_number" => get_user_meta($user_id, "phone_number")[0],
			"mtm_2F_use_2FA" => get_user_meta($user_id, "mtm_2F_use_2FA")[0]
		);
		wp_send_json_success($response);
		return true;
	}




}