<?php

/**
 * Class Mtm_2F_profil_fields
 *
 * manage profil fields and backup codes
 */
class Mtm_2F_profil_fields {

    /*
     * Constructor for class Mtm_2F_profil_fields
     */
	public function __construct() {
		$this->mtm_2F_ini_profil_fields();

		//Disable 2FA if password reset.
		//add_action( 'password_reset', array( $this, 'mtm_2F_password_reset' ) );
	}

	/**
     * Load scripts and styles on wp-admin
     *
	 * @param $hook
	 */
	function mtm_2f_load_scripts_and_styles_on_admin( $hook ) {
		if ('profile.php' == $hook || 'user-edit.php' == $hook) {
			wp_enqueue_script( 'mtm_2F_Profil_js', plugins_url('includes' . DIRECTORY_SEPARATOR . 'js' . DIRECTORY_SEPARATOR . 'mtm_2F_profile.js', __FILE__));
			wp_enqueue_style( 'mtm_2F_Profil_css', plugins_url('includes' . DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR . 'mtm_2F_profile.css', __FILE__));

			wp_localize_script( 'mtm_2F_Profil_js', 'mtm_ajax_obj',
				array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),
				       "userID" => get_current_user_id()) );
		}
	}



	/**
	 * Load scripts and styles on login page
	 */
	function mtm_2f_load_scripts_and_styles_on_login() {
		wp_enqueue_style( 'mtm_2F_register_css', plugins_url('includes' . DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR . 'mtm_2F_register.css', __FILE__));
	}

	/**
	 * ini Hooks for profil fields
	 */
	function mtm_2F_ini_profil_fields() {
		//register_activation_hook( __FILE__, array($this, 'mtm_2f_create_fields_in_DB') );

		add_action( 'register_form', array( $this, 'mtm_2F_register_fields' ) );
		//TODO: Add Backend Registration Fields
		//add_action( 'user_new_form',  array( $this, 'mtm_2F_profil_fields_html' ) );


		add_action( 'user_register',  array( $this,'mtm_2F_user_register') );
		//add_action( 'user_new_form',  array( $this, 'mtm_2F_profil_fields_html' ) );
		add_filter( 'wp_new_user_notification_email', array( $this,'mtm_2F_user_register_notification_email' ) , 10, 2);


		//Errors
		add_filter( 'registration_errors', array( $this,'mtm_2F_registration_errors'), 10, 3 );

		add_action( 'show_user_profile', array( $this, 'mtm_2F_profil_fields_html' ) );
		add_action( 'edit_user_profile', array( $this, 'mtm_2F_profil_fields_html' ) );
		//TODO: Fix Create user
        //add_action( 'user_new_form', array( $this, 'mtm_2F_profil_fields_html' ) );
		add_action( 'personal_options_update', array( $this, 'mtm_2F_save_profil_fields' ) );
		add_action( 'edit_user_profile_update', array( $this, 'mtm_2F_save_profil_fields' ) );

		//add_action( 'user_profile_update_errors', array( $this,'mtm_2F_backend_registration_errors'), 10, 3 );

		add_action( 'admin_enqueue_scripts', array( $this, 'mtm_2f_load_scripts_and_styles_on_admin') );
		add_action( 'login_enqueue_scripts', array( $this, 'mtm_2f_load_scripts_and_styles_on_login') );

		add_action( 'wp_ajax_mtm_2F_generate_backup_codes', array( $this, 'mtm_2F_generate_backup_codes') );
	}

	/**
	 * Erstellt die Benutzerfelder in der Datenbank damit das Menü direkt werte hat (keine Fehlermeldungen).
	 *
	 * @param int $user_id User ID
	 */
	function mtm_2f_create_fields_in_DB( int $user_id ){
		update_user_meta( $user_id, 'mtm_2F_use_2FA','' );
		update_user_meta( $user_id, 'mtm_2F_primary_methode', '' );
		update_user_meta( $user_id, 'phone_number',  '' );
    }

	/**
	 * Save new created user data in user meta
	 *
	 * @param int $user_id UserID to save tu user meta
	 *
	 * @return int
	 */
	function mtm_2F_user_register( int $user_id ) {
	    if(isset( $_POST['mtm_2F_use_2FA'])){
		    update_user_meta( $user_id, 'mtm_2F_use_2FA', sanitize_text_field($_POST['mtm_2F_use_2FA']) );
	    }
		if(isset( $_POST['mtm_2F_primary_methode'])) {
			update_user_meta( $user_id, 'mtm_2F_primary_methode', sanitize_text_field($_POST['mtm_2F_primary_methode']) );
		}
		if(isset(  $_POST['phone_number'] )) {
			//TODO: Validate phone_number with https://numverify.com/ json API?
			update_user_meta( $user_id, 'phone_number', sanitize_text_field($_POST['phone_number']) );
		}
		return 0;
	}

	function mtm_2F_user_register_notification_email($email, $user){
		$key = get_password_reset_key( $user );
		if ( is_wp_error( $key ) ) {
			return -1;
		}
		/* translators: %s: User login. */
		$email["message"]  = sprintf( __( 'Username: %s' ), $user->user_login ) . "\r\n\r\n";
		$email["message"] .= __( 'To set your password, visit the following address:' ) . "\r\n\r\n";
		$email["message"] .= network_site_url( "wp-login.php?action=rp&key=$key&login=" . rawurlencode( $user->user_login ) . "&redirect_to=" . urlencode(get_admin_url() . "profile.php?backupCode=1"), 'login' ) . "\r\n\r\n";
		$email["message"] .= sprintf(__("After setting the password please get your backup-codes for security reasons. Backup-codes will help you to login, in case you lost your 2FA-device.\nClick here to do that: %s", MTM_2F_TEXT_DOMAIN), get_admin_url() . "profile.php?backupCode=1");
		return $email;
	}

	/**
     * Add registration error
     *
	 * @param $errors
	 *
	 * @return mixed
	 */
	function mtm_2F_registration_errors( $errors /*, $sanitized_user_login, $user_email*/ ) {

	    if(isset($_POST['mtm_2F_use_2FA'])){
			if ( $_POST['mtm_2F_use_2FA'] == "1" && empty( $_POST['phone_number'] ) && $_POST['mtm_2F_primary_methode'] == "Mtm_2F_SMS" ) {
				$errors->add( 'mtm_2F_phone_nummer_error', __( '<strong>ERROR</strong>: Please enter your phone number for 2FA with SMS.', 'crf' ) );
			}
	    }
		return $errors;
	}

	/**
     * Create html for register user form
     * @since 0.1
	 */
    function mtm_2F_register_fields(){?>
        <h3><?php _e( "Two Factor Authentification Settings", MTM_2F_TEXT_DOMAIN ); ?></h3>
        <p id="description"><?php  __( "If you Two Factor Authentification methode will be invalide on some time (example phone number change), you can use your backup codes witch send to you per E-Mail on first enable of 2FA!", MTM_2F_TEXT_DOMAIN ); ?></p>
		<br/>
	    <p>
            <div style="display: flex;flex-direction: row;justify-content: space-between;">
                <label for="mtm_2F_use_2FA" ><?php _e( "Enable 2FA", MTM_2F_TEXT_DOMAIN ); ?></label>
                <input type="checkbox" name="mtm_2F_use_2FA" id="mtm_2F_use_2FA"
                <?php
                if(isset($_POST['mtm_2F_use_2FA'])){
                    if ( $_POST['mtm_2F_use_2FA'] == "1" ) {
                        echo 'checked';
                    }
                }
                ?>
                       value="1" style="margin-top: 4px;" class="input-checkbox"/>
            </div>
	        <span class="description"><?php _e( "Please check the checkbox if you want to use Two-Factor Authentification." ); ?></span><br /><br />
	    </p>

	    <p>
		    <select id="mtm_2F_primary_methode" name="mtm_2F_primary_methode" class="input">
			    <?php
			    $methodes = Mtm_2F::mtm_2F_get_methodes();

			    foreach ( $methodes as $class => $methode ) {
					    ?>
					    <<option value="<?php echo $class ?>"
				        <?php
				        if(isset($_POST['mtm_2F_primary_methode'])){
				            if ( $class ==  sanitize_text_field($_POST['mtm_2F_primary_methode']) ) {
					            echo "selected";
				            }
				        }
				        ?>>
				        <?php echo $methode->getDisplayName(); ?></option><?php
			    }
			    ?>
		    </select>
		    <span class="description"><?php _e( "Please enter your primary Two-Factor method.", MTM_2F_TEXT_DOMAIN ); ?></span>
	    </p>

		<p>
			<label for="phone_number"><?php _e( "Phone Number", MTM_2F_TEXT_DOMAIN ); ?></label>
			<div style="display: flex; flex-direction: row;">
				<input type="tel" name="phone_number" id="phone_number"
			       value="<?php if(isset($_POST['phone_number'])) {echo esc_attr($_POST['phone_number']); }?>"
			       pattern="\+\d{1,3}\s\d{1,14}(\d{1,13})?"
			       class="input"/><span class="validity"></span>
            </div>
        <span class="description"><?php _e( "Please enter your Phone Number in the format like +49 7777777777, if you selected SMS as your primary Two-Factor method.", MTM_2F_TEXT_DOMAIN ); ?></span>
	    <br><br>
	    </p>
    <?php
	}

	/**
	 * Create html for user profil page and create user page
	 *
	 * @param WP_User $user User to get user meta for option page
	 *
	 * @since 0.1
	 * @since 0.3 add backup codes
	 */
    static function  mtm_2F_profil_fields_html( WP_User $user ) { ?>
        <h3><?php _e( "Two Factor Authentification Settings", MTM_2F_TEXT_DOMAIN ); ?></h3>
        <p id="description"><?php  __( "If you Two Factor Authentification methode will be invalide on some time (example phone number change), you can use your backup codes witch send to you per E-Mail on first enable of 2FA!", MTM_2F_TEXT_DOMAIN ); ?></p>

        <table class="form-table">
            <tr>
                <th><label for="mtm_2F_use_2FA"><?php _e( "Enable 2FA", MTM_2F_TEXT_DOMAIN ); ?></label></th>
                <td>
                    <input type="checkbox" name="mtm_2F_use_2FA" id="mtm_2F_use_2FA"
                           value="1"
                            <?php
                            if($user instanceof WP_User){
                                if ( !empty(get_user_meta( $user->ID, "mtm_2F_use_2FA" )[0])) {
                                    if(get_user_meta( $user->ID, "mtm_2F_use_2FA" )[0] == "1"){
                                        echo 'checked';
                                    }
                                }
                            }
                            ?> class="regular-checkbox"/><br/>
                    <span class="description"><?php _e( "Please check the checkbox if you want to use Two-Factor Authentification." ); ?></span>
                </td>
            </tr>
            <tr class="mtm_2F_Settings">
                <th></th>
                <td>
	                <?php
	                $backupCodestext = array("","");
	                if(isset($_GET["backupCode"]) && $_GET["backupCode"] == 1){
		                $backupCodestext = Mtm_2F_profil_fields::mtm_2F_generate_backup_codes($user->ID);
	                }
	                //TODO: set copy text on parameter
	                ?>
                    <input type="button" class="button" id="mtm_2F_generate_backup_codes" value="<?php _e( "Regenerate backup-codes", MTM_2F_TEXT_DOMAIN ); ?>">
	                <?php
	                if ( !empty(get_user_meta( $user->ID, 'mtm_2F_backup_codes' ))) {
		                ?>
			                <span id="mtm_2F_backup_codes_count"><?php echo __( "Available backup codes", MTM_2F_TEXT_DOMAIN ) . " " . count( get_user_meta( $user->ID, 'mtm_2F_backup_codes' )[0] ); ?></span>
		                <?php
	                }else{
	                    ?>
                            <span id="mtm_2F_backup_codes_error"><?php echo __( "Please generate new backup codes before you activate two factor authentification!", MTM_2F_TEXT_DOMAIN )?></span>
                        <?php
	                }
	                ?>

	                <br>
                    <span class="description"><?php _e( "This will delete the old backup-codes and generate 8 new backup-codes.", MTM_2F_TEXT_DOMAIN ); ?></span>
	                <div id="backupcodes" class="modal <?php
	                if(isset($_GET["backupCode"]) && $_GET["backupCode"] == 1){
	                	echo "show-modal";
	                } ?>">
		                <!-- Modal content -->
		                <div class="modal-content">
			                <span class="backupcodes-close">&times;</span>
			                <span class="modal-text">
				                <?php echo $backupCodestext[0]; ?>
			                </span>
			                <input type="button" class="button backupcodes-copy" value="<?php _e("Copy" , MTM_2F_TEXT_DOMAIN) ?>" data-text="<?php echo $backupCodestext[1] ?>">
		                </div>

	                </div>
                </td>
            </tr>
            <tr class="mtm_2F_Settings">
                <th>
                    <label for="mtm_2F_primary_methode"><?php _e( "Primary 2FA methode", MTM_2F_TEXT_DOMAIN ); ?></label>
                </th>
                <td>
                    <select id="mtm_2F_primary_methode" name="mtm_2F_primary_methode">
						<?php
						$methodes = Mtm_2F::mtm_2F_get_methodes();

			                if ( $user instanceof WP_User && isset( get_user_meta( $user->ID, 'mtm_2F_primary_methode' )[0] ) ) {
				                $selected = get_user_meta( $user->ID, 'mtm_2F_primary_methode' )[0];
			                } else {
				                $selected = "Mtm_2F_EMail";
			                }

                            foreach ( $methodes as $class => $methode ) {

                                ?>
                                <option
                                <?php
                                if($user instanceof WP_User){
                                    if ( ! $methode->checkUserCanUseMethode( $user ) ){
                                    ?>
                                        hidden
                                    <?php
                                    }
                                }
                                ?>value="<?php echo $class ?>" <?php if( $class == $selected ) {echo "selected";}

                                ?>>
                                <?php echo $methode->getDisplayName(); ?></option><?php
                            }
						?>
                    </select>
                    <span class="description"><?php _e( "Please enter your primary Two-Factor method.", MTM_2F_TEXT_DOMAIN ); ?></span>
                </td>
            </tr>
            <tr class="mtm_2F_Settings">
                <th><label for="phone_number"><?php _e( "Phone Number", MTM_2F_TEXT_DOMAIN ); ?></label></th>
                <td>
                    <input type="tel" name="phone_number" id="phone_number"
                           value="<?php
		                    if($user instanceof WP_User){
		                        echo esc_attr( get_the_author_meta( 'phone_number', $user->ID ) );
		                    } ?>"
                           pattern="\+\d{1,3}\s\d{1,14}(\d{1,13})?"
                           class="regular-text"/><span class="validity"></span><br/>
                    <span class="description"><?php _e( "Please enter your Phone Number in the format like +49 7777777777", MTM_2F_TEXT_DOMAIN ); ?></span>
                </td>
            </tr>
        </table>
	<?php }

	/**
	 * @param int $user_id UserID to save options in user meta
	 *
	 * @return bool|int Return false if user dont have permissions
	 * @since 0.3 add Backup codes
	 * @since 0.1
	 *
	 *
	 */
	function mtm_2F_save_profil_fields( int $user_id ) {
		if ( ! current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}
		$response = null;
		if(get_user_meta($user_id, "mtm_2F_use_2FA")[0] == "0" && $_POST['mtm_2F_use_2FA'] == "1"){
		    $codes = get_user_meta($user_id, "mtm_2F_backup_codes")[0];
			if(empty($codes)){
				$response = $this->mtm_2F_generate_backup_codes($user_id);
			}
		}


		update_user_meta( $user_id, 'mtm_2F_use_2FA', isset($_POST['mtm_2F_use_2FA']) ? sanitize_text_field($_POST['mtm_2F_use_2FA']) : "0" );
		$phone_number = $this->mtm_2F_get_check_phone_number();
		if ( $phone_number == "" ) {
			update_user_meta( $user_id, 'mtm_2F_primary_methode', "Mtm_2F_EMail" );
		} else {
			update_user_meta( $user_id, 'mtm_2F_primary_methode', sanitize_text_field($_POST['mtm_2F_primary_methode']) );
		}
		update_user_meta( $user_id, 'phone_number', $phone_number );

		return (!empty($response)) ? $response : 0;
	}

	/**
	 * Check phone number with preg_match
     *
     *
	 * @see mtm_2F_save_profil_fields
	 * @return string Current valide phone number
	 */
	function mtm_2F_get_check_phone_number(){
		if(preg_match('/\+\d{1,3}\s\d{1,14}(\d{1,13})?/m', sanitize_text_field($_POST['phone_number']) )){
		    return $_POST['phone_number'];
		}else {
			return "";
		}
	}

	/**
	 * Disable 2FA for given user
	 *
	 * @param WP_User $user User to set the 2FA to "disabled"
	 */
	function mtm_2F_disable( WP_User $user ) {
		update_user_meta( $user->ID, 'mtm_2F_use_2FA', '0' );
	}

	/* Generate 2FA-backup-codes
     *
	 * @param $user_id User id for save codes to User meta
	 */
	static function mtm_2F_generate_backup_codes($user_id){
			if(!isset($_POST["userID"])){
				if(empty($user_id)){
					if(wp_doing_ajax()){
						wp_send_json_error("No User ID");
						echo "no User ID";
					}
					return 0;
				}
			}else {
				$user_id = intval($_POST["userID"]);
				if(!(is_numeric($user_id) && $user_id > 0)) {
					if(wp_doing_ajax()){
						wp_send_json_error("No User ID");
						echo "no User ID";
					}
					return 0;
				}
			}
	        $BackupCodesRaw = array();
	        for ($i = 0; $i < 8; $i++){
		        $BackupCodesRaw[] = Mtm_2F_Methode::genPasswort( 8, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890" );
            }
		    $BackupCodes = array();
            foreach ( $BackupCodesRaw as $key => $codeRaw  ) {
                $BackupCodes[] = wp_hash_password($codeRaw);
            }

			$CopyText = "";
            $ResponseString = "<p>" . __("Please save these backup-codes in a safe place.", MTM_2F_TEXT_DOMAIN) . "</p><ol>";
            foreach ($BackupCodesRaw as $key => $code){
            	$ResponseString .= "<li>" . $code . "</li>";
            	$CopyText .= ($key + 1) . " " . $code . "\n";
            }
            $ResponseString .= "</ol>";

			//Save the encrypted codes to database
            update_user_meta( $user_id, 'mtm_2F_backup_codes', $BackupCodes );

			if(wp_doing_ajax()) {
				wp_send_json_success( array( $ResponseString, $CopyText ) );
			}

			return  array( $ResponseString, $CopyText );
    }

}