<?php

//TODO: Admin Page erstellen. Options nur mit get_options holen!
class Mtm_2F_adminpanel {

	function __construct() {
		// create custom plugin settings menu
		add_action( 'admin_menu', array( $this, 'mtm_2F_plugin_create_menu' ) );
		add_action( 'user_register', array($this, 'mtm_2f_create_fields_in_DB'));
	}

	function mtm_2f_create_fields_in_DB($user_id){
		update_option('mtm_2F_clicksend_username', '');
		update_option('mtm_2F_clicksend_password', '');
		update_option('mtm_2F_clicksend_sender', '');
		update_option('mtm_2F_clicksend_msg', '');
		update_option('mtm_2F_ip_whitelist', '');
	}

	function mtm_2F_plugin_create_menu() {

		//create new top-level menu
		add_options_page( MTM_2F_PLUGIN_DISPLAYNAME . 'setting page', MTM_2F_SETTING_DISPLAYNAME, 'administrator', "mtm-2F-settings", array(
			$this,
			'mtm_2F_plugin_settings_page'
		) );

		//call register settings function
		add_action( 'admin_init', array( $this, 'mtm_2F_register_plugin_settings' ) );
	}


	function mtm_2F_register_plugin_settings() {
		//register our settings
		register_setting( 'mtm-2F-plugin-settings', 'mtm_2F_clicksend_username' );
		register_setting( 'mtm-2F-plugin-settings', 'mtm_2F_clicksend_password', array(
			$this,
			'mtm_2f_validate_clicksend_password'
		) );
		register_setting( 'mtm-2F-plugin-settings', 'mtm_2F_clicksend_sender' );
		register_setting( 'mtm-2F-plugin-settings', 'mtm_2F_clicksend_msg' );
		register_setting( 'mtm-2F-plugin-settings', 'mtm_2F_ip_whitelist' );
	}

	function mtm_2F_plugin_settings_page() {
		?>
        <div class="wrap">
            <h1><?php echo MTM_2F_PLUGIN_DISPLAYNAME ?></h1>

            <form method="post" action="options.php">
				<?php settings_fields( 'mtm-2F-plugin-settings' ); ?>
				<?php do_settings_sections( 'mtm-2F-plugin-settings' ); ?>

	            <h2><?php _e( "ClickSend.com login data", MTM_2F_TEXT_DOMAIN ); ?></h2>
	            <table class="form-table">
                    <tr valign="top">
                        <th scope="row"><?php _e( "Username", MTM_2F_TEXT_DOMAIN ); ?></th>
                        <td><input type="text" name="mtm_2F_clicksend_username"
                                   value="<?php echo esc_attr( get_option( 'mtm_2F_clicksend_username' ) ); ?>"/></td>
                    </tr>

                    <tr valign="top">
                        <th scope="row"><?php _e( "Passwort", MTM_2F_TEXT_DOMAIN ); ?></th>
                        <td><input type="password" name="mtm_2F_clicksend_password"
                                   value="<?php echo esc_attr( get_option( 'mtm_2F_clicksend_password' ) ); ?>"/></td>
                    </tr>

                    <tr valign="top">
                        <th scope="row"><?php _e( "Sender", MTM_2F_TEXT_DOMAIN ); ?></th>
                        <td><input type="text" name="mtm_2F_clicksend_sender"
                                   value="<?php echo esc_attr( get_option( 'mtm_2F_clicksend_sender' ) ); ?>"/></td>
                    </tr>
	            </table>

	            <h2><?php _e( "Message settings", MTM_2F_TEXT_DOMAIN ); ?></h2>
	            <table class="form-table">
		            <tr valign="top">
                        <th scope="row"><?php _e( "Message", MTM_2F_TEXT_DOMAIN ); ?></th>
                        <td>
	                        <textarea name="mtm_2F_clicksend_msg" id="mtm_2F_clicksend_msg" rows="5" cols="60" maxlength="150"><?php echo esc_attr( get_option( 'mtm_2F_clicksend_msg' ) ); ?></textarea>
                            <p class="description"><?php _e("Use this placeholders:", MTM_2F_TEXT_DOMAIN)?></p>
	                        <ul>
		                        <li><?php _e("{blogurl} for blogurl", MTM_2F_TEXT_DOMAIN); ?></li>
		                        <li><?php _e("{blogname} for blogname", MTM_2F_TEXT_DOMAIN); ?></li>
		                        <li><?php _e("{first_name} for user first name", MTM_2F_TEXT_DOMAIN); ?></li>
		                        <li><?php _e("{last_name} for user last name", MTM_2F_TEXT_DOMAIN); ?></li>
		                        <li><?php _e("{passkey} for the one time passkey", MTM_2F_TEXT_DOMAIN); ?></li>
	                        </ul>
                        </td>
                    </tr>
                </table>

                <h2><?php _e( "IP WhiteList", MTM_2F_TEXT_DOMAIN ); ?></h2>
                <table class="form-table">
                    <tr valign="top">
                        <th scope="row"><?php _e( "IP Liste", MTM_2F_TEXT_DOMAIN ); ?></th>
                        <td>
                            <textarea name="mtm_2F_ip_whitelist" id="mtm_2F_ip_whitelist" rows="5" cols="60" maxlength="150"><?php echo esc_attr( get_option( 'mtm_2F_ip_whitelist' ) ); ?></textarea>
                            <p><?php _e("You can whitelist your IP. Whitelisted IPs dont need enter a 2FA passkey", MTM_2F_TEXT_DOMAIN) ?></p>
                        </td>
                    </tr>
                </table>

				<?php submit_button(); ?>

            </form>
        </div>
	<?php }

	function mtm_2f_validate_clicksend_password( $passkey ) {
		//Hier kann man Passkey etc Validieren wenn später erforderlich
		return $passkey;
	}
}