<?php

/*
 * Plugin Name: Log deleted plugins by WP Staging
 * Plugin URI: https://wp-staging.com
 * Description: Write a log file whenever a plugin is deleted or deactivated plugins.
 *
 * This is a must-use standalone plugin.
 *
 * Author: WP Staging
 * Version: 1.0
 * Author URI: https://wp-staging.com
 */

add_action('deactivated_plugin', function ($plugin_file) {

    $datetime = date('d-m-Y H:i:s');

    $message = "[{$datetime}] Deactivated plugin {$plugin_file}";

    error_log(
        "$message\n",
        3,
        WP_CONTENT_DIR . "/7263767234-deleted-plugins.log"
    );

    wp_mail('ben@albrightdesign.de', 'Plugin deactivated on LearnDo', $message);

}, 20, 2);

add_action('deleted_plugin', function ($plugin_file, $deleted) {

    if ($deleted) {

        $datetime = date('d-m-Y H:i:s');

        $message = "[{$datetime}] Deleted plugin {$plugin_file}";

        error_log(
            "[{$datetime}] Deleted plugin {$plugin_file}\n",
            3,
            WP_CONTENT_DIR . "/7263767234-deleted-plugins.log"
        );

        wp_mail('ben@albrightdesign.de', 'Plugin deleted on LearnDo', $message);
    }

}, 20, 2);