<?php
    function wptp_collector_update_logs($popup_id)
    {
        global $wpdb;

        $table_name_logs = $wpdb->prefix.'wptp_collector_logs';
        $table_name_contents = $wpdb->prefix.'wptp_collector_contents';
        $timestamp = current_time('mysql');

        // Find Agreement Expiration
        if (get_option('termsopt_expiry') && get_option('termsopt_expiry') != '' && get_option('termsopt_expiry') > 0) {
            $agreement_expiration = date('Y-m-d H:i:s', strtotime($timestamp) + (get_option('termsopt_expiry')) * 60 * 60);
        } else {
            if (get_option('termsopt_expiry') != '' && get_option('termsopt_expiry') == 0) {
                $agreement_expiration = $timestamp;
            } else {
                $agreement_expiration = date('Y-m-d H:i:s', strtotime($timestamp) + 3 * 24 * 60 * 60);
            }
        }

        // Find Agree Button Text
        if ((get_post_meta($popup_id, 'terms_agreetxt', true)) != '') {
            $agreement_text = get_post_meta($popup_id, 'terms_agreetxt', true);
        } elseif (get_option('termsopt_agreetxt') != '') {
            $agreement_text = get_option('termsopt_agreetxt');
        } else {
            $agreement_text = __('I Agree', WP_TERMS_POPUP_COLLECTOR_NAME);
        }

        // Determine IP Address, using Pippin's Example: https://gist.github.com/pippinsplugins/9641841
        $ip_address = 'Unknown';
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }

        // Find ID for this popup's most recent contents
        $contents_id = $wpdb->get_var(
            $wpdb->prepare("SELECT id FROM {$table_name_contents} WHERE popup_id = %d ORDER BY id DESC LIMIT 1", $popup_id)
        );

        // Find user ID
        $user_id = get_current_user_id();

        // Insert data into logs table
        $sql_logs_data = "INSERT INTO `$table_name_logs` (`popup_id`, `user_id`, `contents_id`, `ip_address`, `user_agent`, `source`, `agreement_expiration`, `agreement_text`, `timestamp`) 
            VALUES (%d, %d, %d, %s, %s, %s, %s, %s, %s)";

        $logs_data = $wpdb->prepare(
            $sql_logs_data,
            $popup_id,
            $user_id,
            $contents_id,
            $ip_address,
            $_SERVER['HTTP_USER_AGENT'],
            $_SERVER['REQUEST_URI'],
            $agreement_expiration,
            $agreement_text,
            $timestamp
        );

        $wpdb->query($logs_data);

        wptp_collector_update_results($popup_id, 'conversions');

        do_action('wptp_collector_after_update_logs', [
            'popup_id' => $popup_id,
            'user_id' => $user_id,
            'contents_id' => $contents_id,
            'ip_address' => $ip_address,
            'user_agent' => $_SERVER['HTTP_USER_AGENT'],
            'source' => $_SERVER['REQUEST_URI'],
            'agreement_expiration' => $agreement_expiration,
            'agreement_text' => $agreement_text,
            'timestamp' => $timestamp,
        ]);
    }

    function wptp_collector_update_results($popup_id, $increment = 'views')
    {
        global $wpdb;

        $table_name_results = $wpdb->prefix.'wptp_collector_results';

        // Update data in results table; insert row if none exists already for given popup ID
        $result = $wpdb->get_row($wpdb->prepare("SELECT popup_id FROM $table_name_results WHERE popup_id = %d", $popup_id));
        if (is_null($result)) {
            $sql_results_data = "INSERT INTO `$table_name_results` (`popup_id`, `views`) 
            VALUES (%d, %d)";

            $results_data = $wpdb->prepare(
                $sql_results_data,
                $popup_id,
                '1'
            );

            $wpdb->query($results_data);
        } else {
            $wpdb->query($wpdb->prepare("UPDATE `$table_name_results` SET `$increment` = `$increment` + 1 WHERE popup_id = %d", $popup_id));
        }
    }

    function wptp_collector_logs($popup_id)
    {
        global $wpdb;

        $table_name_users = $wpdb->prefix.'users';
        $table_name_logs = $wpdb->prefix.'wptp_collector_logs';

        $results = [];

        $arr_results = $wpdb->get_results(
            $wpdb->prepare(
                "
                SELECT `$table_name_logs`.*, `$table_name_users`.`display_name`, `$table_name_users`.`user_login` 
                FROM `$table_name_logs` 
                LEFT JOIN `$table_name_users` ON `$table_name_users`.`id` = `$table_name_logs`.`user_id`
                WHERE popup_id = %d 
                ORDER BY `timestamp` DESC
                ",
                $popup_id
            )
        );

        if ($arr_results) {
            $results = $arr_results;
        }

        return $results;
    }

    function wptp_collector_results($popup_id, $column)
    {
        global $wpdb;

        $table_name_results = $wpdb->prefix.'wptp_collector_results';

        $results = 0;

        $arr_results = $wpdb->get_col($wpdb->prepare("SELECT $column FROM `$table_name_results` WHERE popup_id = %d", $popup_id));
        if ($arr_results) {
            $results = 0 + $arr_results[0];
        }

        return $results;
    }

    function wptp_collector_delete_results($popup_id)
    {
        global $wpdb;

        $table_name_logs = $wpdb->prefix.'wptp_collector_logs';
        $table_name_results = $wpdb->prefix.'wptp_collector_results';

        if (is_numeric($popup_id) && $popup_id > 0) {
            $wpdb->query($wpdb->prepare("DELETE FROM `$table_name_logs` WHERE popup_id = %d", $popup_id));
            $wpdb->query($wpdb->prepare("UPDATE `$table_name_results` SET `views` = 0 WHERE popup_id = %d", $popup_id));
            $wpdb->query($wpdb->prepare("UPDATE `$table_name_results` SET `conversions` = 0 WHERE popup_id = %d", $popup_id));

            return true;
        } else {
            return false;
        }
    }

    function wptp_collector_delete_result($popup_id, $result_id)
    {
        global $wpdb;

        $table_name_logs = $wpdb->prefix.'wptp_collector_logs';
        $table_name_results = $wpdb->prefix.'wptp_collector_results';

        if (is_numeric($popup_id) && $popup_id > 0 && is_numeric($result_id) && $result_id > 0) {
            $wpdb->query($wpdb->prepare("DELETE FROM `$table_name_logs` WHERE id = %d", $result_id));
            $wpdb->query($wpdb->prepare("UPDATE `$table_name_results` SET `views` = `views` - 1 WHERE popup_id = %d", $popup_id));
            $wpdb->query($wpdb->prepare("UPDATE `$table_name_results` SET `conversions` = `conversions` - 1 WHERE popup_id = %d", $popup_id));

            return true;
        } else {
            return false;
        }
    }

    function wptp_collector_erase_personal_data($email_address)
    {
        global $wpdb;

        $user = get_user_by('email', $email_address);

        if ($user !== false) {
            $table_name_logs = $wpdb->prefix.'wptp_collector_logs';
            $items_removed = $wpdb->get_row($wpdb->prepare("SELECT COUNT(id) AS count FROM $table_name_logs WHERE user_id = %d", $user->ID));
            $wpdb->query($wpdb->prepare("DELETE FROM `$table_name_logs` WHERE user_id = %d", $user->ID));
        }

        return [
            'items_removed' => (isset($items_removed->count) ? $items_removed : 0),
            'items_retained' => false,
            'messages' => [],
            'done' => true,
        ];
    }

    function wptp_collector_export_personal_data($email_address, $page = 1)
    {
        global $wpdb;

        $user = get_user_by('email', $email_address);

        if ($user !== false) {
            $table_name_logs = $wpdb->prefix.'wptp_collector_logs';

            $export_items = [];

            $logs = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name_logs WHERE user_id = %d", $user->ID));

            foreach ($logs as $log) {
                $group_id = 'wptp-collector';
                $group_label = __('WP Terms Popup Collector', WP_TERMS_POPUP_COLLECTOR_NAME);
                $item_id = 'wptp-collector-log-'.$log->id;

                $data = [
                    [
                        'name' => __('Popup ID', WP_TERMS_POPUP_COLLECTOR_NAME),
                        'value' => $log->popup_id,
                    ],
                    [
                        'name' => __('Date', WP_TERMS_POPUP_COLLECTOR_NAME),
                        'value' => $log->timestamp,
                    ],
                    [
                        'name' => __('IP Address', WP_TERMS_POPUP_COLLECTOR_NAME),
                        'value' => $log->ip_address,
                    ],
                    [
                        'name' => __('User Agent', WP_TERMS_POPUP_COLLECTOR_NAME),
                        'value' => $log->user_agent,
                    ],
                    [
                        'name' => __('Expiration', WP_TERMS_POPUP_COLLECTOR_NAME),
                        'value' => $log->agreement_expiration,
                    ],
                ];

                $export_items[] = [
                    'group_id' => $group_id,
                    'group_label' => $group_label,
                    'item_id' => $item_id,
                    'data' => $data,
                ];
            }
        }

        return [
            'data' => $export_items,
            'done' => true,
        ];
    }

    function wptp_collector_meta_boxes()
    {
        $wptp_installed_version = get_option('wptp_version');
        if (version_compare(get_option('wptp_version'), '2.3.0', '<')) {
            return;
        }
        
        $screen = get_post_types([
            'public' => true,
        ]);
        unset($screen['termpopup']);

        // Post Type
        add_meta_box(
            'wptp-collector-meta',
            esc_html__('WP Terms Popup Collector Settings', WP_TERMS_POPUP_COLLECTOR_NAME),
            'wptp_collector_meta_box_contents',
            'termpopup',
            'normal',
            'high'
        );
    }

    function wptp_collector_meta_box_contents($object, $box)
    {
        $wptpc_settings = get_post_meta($object->ID, 'wptpc_settings', true);

        if (empty($wptpc_settings)) {
            $wptpc_settings = get_option('wptpc_settings');
        } ?>
        <table class="wptp-meta-box">
            <tbody>
                <tr>
                    <td><?php _e('Check Collector Data?', WP_TERMS_POPUP_COLLECTOR_NAME); ?></td>
                    <td>
                        <label for="check-ip-address">
                            <input type="checkbox" id="check-ip-address" name="wptpc_settings[check_ip_address]" value="1" <?php checked('1', (isset($wptpc_settings['check_ip_address']) ? $wptpc_settings['check_ip_address'] : 0)); ?>>
                            <?php esc_attr_e('IP Address', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <label for="check-user-agent">
                            <input type="checkbox" id="check-user-agent" name="wptpc_settings[check_user_agent]" value="1" <?php checked('1', (isset($wptpc_settings['check_user_agent']) ? $wptpc_settings['check_user_agent'] : 0)); ?>>
                            <?php esc_attr_e('User Agent', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <label for="check-user">
                            <input type="checkbox" id="check-user" name="wptpc_settings[check]" value="1" <?php checked('1', (isset($wptpc_settings['check']) ? $wptpc_settings['check'] : 0)); ?>>
                            <?php esc_attr_e('WordPress User', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <small>
                            <?php _e('Check Collector data and do not display the popup if the selected fields match your visitor\'s information.', WP_TERMS_POPUP_COLLECTOR_NAME); ?><br>
                            <?php _e('This feature ignores the stored cookie and expiration date.', WP_TERMS_POPUP_COLLECTOR_NAME); ?><br>
                            <?php _e('<a href="https://termsplugin.com/support/how-to-check-collector-data-before-showing-a-popup" target="_blank">Learn more about how this feature works at the WP Terms Popup website</a>.', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </small>
                    </td>
                </tr>

                <tr>
                    <td><?php _e('Email Collector Data?', WP_TERMS_POPUP_COLLECTOR_NAME); ?></td>
                    <td>
                        <label for="email-ip-address">
                            <input type="checkbox" id="email-ip-address" name="wptpc_settings[email][ip_address]" value="1" <?php checked('1', (isset($wptpc_settings['email']['ip_address']) ? $wptpc_settings['email']['ip_address'] : 0)); ?>>
                            <?php esc_attr_e('IP Address', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <label for="email-user-agent">
                            <input type="checkbox" id="email-user-agent" name="wptpc_settings[email][user_agent]" value="1" <?php checked('1', (isset($wptpc_settings['email']['user_agent']) ? $wptpc_settings['email']['user_agent'] : 0)); ?>>
                            <?php esc_attr_e('User Agent', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <label for="email-source">
                            <input type="checkbox" id="email-source" name="wptpc_settings[email][source]" value="1" <?php checked('1', (isset($wptpc_settings['email']['source']) ? $wptpc_settings['email']['source'] : 0)); ?>>
                            <?php esc_attr_e('Source', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <label for="email-wordpress-user">
                            <input type="checkbox" id="email-wordpress-user" name="wptpc_settings[email][wordpress_user]" value="1" <?php checked('1', (isset($wptpc_settings['email']['wordpress_user']) ? $wptpc_settings['email']['wordpress_user'] : 0)); ?>>
                            <?php esc_attr_e('WordPress User', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <label for="email-expiration">
                            <input type="checkbox" id="email-expiration" name="wptpc_settings[email][expiration]" value="1" <?php checked('1', (isset($wptpc_settings['email']['expiration']) ? $wptpc_settings['email']['expiration'] : 0)); ?>>
                            <?php esc_attr_e('Expiration', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </label>
                        <br>

                        <small>
                            <?php echo _e('Email will be sent, after each agreement, to:', WP_TERMS_POPUP_COLLECTOR_NAME); ?> <?php echo esc_html(get_bloginfo('admin_email')); ?><br>
                            <?php _e('<a href="https://termsplugin.com/support/how-to-email-collector-data-after-agreement" target="_blank">Learn more about how this feature works at the WP Terms Popup website</a>.', WP_TERMS_POPUP_COLLECTOR_NAME); ?>
                        </small>
                    </td>
                </tr>
            </tbody>
        </table>
        <?php
    }

    function wptp_collector_meta_box_save($post_id, $post)
    {
        $post_type = get_post_type_object($post->post_type);

        if (!current_user_can($post_type->cap->edit_post, $post_id)) {
            return $post_id;
        }

        $wptpc_settings = (isset($_POST['wptpc_settings']) ? $_POST['wptpc_settings'] : []);
        update_post_meta($post_id, 'wptpc_settings', $wptpc_settings);
    }

    function wptp_collector_check($popup_id)
    {
        global $wpdb;

        $wptpc_settings = get_post_meta($popup_id, 'wptpc_settings', true);
        $table_name_logs = $wpdb->prefix.'wptp_collector_logs';
        $parameters = [];

        if (!isset($wptpc_settings) || empty($wptpc_settings)) {
            return false;
        }

        // Determine IP Address, using Pippin's Example: https://gist.github.com/pippinsplugins/9641841
        $ip_address = null;
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }

        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $user_id = get_current_user_id();

        // Construct Lookup Query
        $sql_results = "SELECT `$table_name_logs`.* FROM `$table_name_logs` WHERE popup_id = ".$popup_id.' ';

        // IP Address
        if (isset($wptpc_settings['check_ip_address']) && $wptpc_settings['check_ip_address'] !== false) {
            $sql_results .= 'AND ip_address = %s ';
            $parameters[] = $ip_address;
        }

        // User Agent
        if (isset($wptpc_settings['check_user_agent']) && $wptpc_settings['check_user_agent'] !== false) {
            $sql_results .= 'AND user_agent = %s ';
            $parameters[] = $user_agent;
        }

        // WordPress User
        if (isset($wptpc_settings['check']) && $wptpc_settings['check'] !== false) {
            $sql_results .= 'AND (user_id <> 0 AND user_id = %d) ';
            $parameters[] = $user_id;
        }

        $sql_results .= 'ORDER BY `timestamp` DESC';

        if (isset($parameters) && !empty($parameters)) {
            $arr_results = $wpdb->get_results($wpdb->prepare($sql_results, $parameters));

            if (!empty($arr_results)) {
                return true;
            }
        }

        return false;
    }

    function wptp_collector_get_contents($contents_id)
    {
        global $wpdb;

        $table_name_contents = $wpdb->prefix.'wptp_collector_contents';

        $contents = $wpdb->get_row(
            $wpdb->prepare(
                "
                SELECT `$table_name_contents`.*
                FROM `$table_name_contents` 
                WHERE id = %d 
                ",
                $contents_id
            )
        );

        return $contents;
    }

    function wptp_collector_insert_contents($popup_id, $post_content, $post_title)
    {
        global $wpdb;

        $table_name_contents = $wpdb->prefix.'wptp_collector_contents';

        $sql_content = "INSERT INTO `$table_name_contents` (`popup_id`, `post_content`, `post_title`) 
            VALUES (%d, %s, %s)";

        $contents_data = $wpdb->prepare(
            $sql_content,
            $popup_id,
            $post_content,
            $post_title
        );

        $wpdb->query($contents_data);
    }

    function wptp_collector_publish_termpopup($post_id, $post)
    {
        $popup_id = get_the_ID();
        $post_content = $post->post_content;
        $post_content = apply_filters('the_content', $post_content);
        $post_content = str_replace(']]>', ']]&gt;', $post_content);
        $post_title = $post->post_title;

        // Insert data into contents table
        wptp_collector_insert_contents($post_id, $post_content, $post_title);
    }

    function wptp_collector_email_log($log)
    {
        $popup_name = get_the_title($log['popup_id']);
        $wptpc_settings = get_post_meta($log['popup_id'], 'wptpc_settings', true);

        if (!isset($wptpc_settings['email']) || empty(array_filter($wptpc_settings['email']))) {
            return;
        }

        $to = get_bloginfo('admin_email');
        $headers = ['Content-Type: text/html; charset=UTF-8'];
        $subject = 'WP Terms Popup Agreement: '.$popup_name;
        $body = '<p>'.__('A new popup agreement has been made on your website.', WP_TERMS_POPUP_COLLECTOR_NAME).'</p>';
        $body.= '<p>';
        $body.= '<b>'.__('Date', WP_TERMS_POPUP_COLLECTOR_NAME).':</b> '.date(get_option('date_format').' '.get_option('time_format'), strtotime($log['timestamp']));

        // IP Address
        if (isset($wptpc_settings['email']['ip_address'])) {
            $body.= '<br><b>'.__('IP Address', WP_TERMS_POPUP_COLLECTOR_NAME).':</b> '.$log['ip_address'];
        }

        // User Agent
        if (isset($wptpc_settings['email']['user_agent'])) {
            $body.= '<br><b>'.__('User Agent', WP_TERMS_POPUP_COLLECTOR_NAME).':</b> '.$log['user_agent'];
        }

        // Source
        if (isset($wptpc_settings['email']['source'])) {
            $body.= '<br><b>'.__('Source', WP_TERMS_POPUP_COLLECTOR_NAME).':</b> <a href="'.get_site_url(null, $log['source']).'">'.get_site_url(null, $log['source']).'</a>';
        }

        // WordPress User
        if (isset($wptpc_settings['email']['wordpress_user'])) {
            $body.= '<br><b>'.__('WordPress User', WP_TERMS_POPUP_COLLECTOR_NAME).':</b>';
            if ($log['user_id'] != 0 && $user = get_userdata($log['user_id'])) {
                $body.= $user->display_name.' ('.$user->user_login.')';
            } else {
                $body.= __('N/A', WP_TERMS_POPUP_COLLECTOR_NAME);
            }
        }

        // Expiration
        if (isset($wptpc_settings['email']['expiration'])) {
            $body.= '<br><b>'.__('Expiration', WP_TERMS_POPUP_COLLECTOR_NAME).':</b> '.date(get_option('date_format').' '.get_option('time_format'), strtotime($log['agreement_expiration']));
        }

        $body.= '</p>';
    
        if (wp_mail($to, $subject, $body, $headers)) {
            return true;
        } else {
            return false;
        }
    }