<?php

class WPF_Media_Tools_Compat {

	/**
	 * Compatibility tweaks with other themes and plugins
	 *
	 * @since 1.1
	 * @return void
	 */

	public function __construct() {

		// Video shortcode filtering
		add_filter( 'acf/load_value/name=video_embed_code', array( $this, 'memberoni_video' ), 10, 3 );

	}

	/**
	 * Outputs scripts for memberoni video embeds (really janky)
	 *
	 * @since 1.1
	 * @return string Value
	 */

	public function memberoni_video( $value, $post_id, $field ) {

		if ( false === strpos( $value, 'wpf_' ) ) {
			return $value;
		}

		if ( strpos( $value, 'vimeo' ) !== false ) {

			$data_atts     .= 'data-player_type="vimeo" ';
			$inline_scripts = '<script type="text/javascript" src="//player.vimeo.com/api/player.js"></script>';

		} elseif ( strpos( $value, 'youtube' ) !== false ) {

			$value          = str_replace( '?feature=oembed', '?feature=oembed&enablejsapi=1', $value );
			$data_atts     .= 'data-player_type="youtube" id="' . uniqid( 'wpf_youtube_' ) . '" ';
			$inline_scripts = '<script type="text/javascript" src="//www.youtube.com/iframe_api"></script>';

		} elseif ( strpos( $value, 'wistia' ) !== false ) {

			$data_atts .= 'data-player_type="wistia" id="' . uniqid( 'wpf_wistia_' ) . '" ';

			$value = str_replace( 'sandbox="allow-scripts" ', '', $value );
			$value = str_replace( 'security="restricted" ', '', $value );
			$value = str_replace( 'wp-embedded-content', 'wistia_embed', $value );

			$inline_scripts = '<script type="text/javascript" src="//fast.wistia.com/assets/external/E-v1.js"></script>';

		}

		// This runs too late to properly enqueue them
		$inline_scripts .= '<script type="text/javascript">/* <![CDATA[ */ var wpf_mt_ajax = {"ajaxurl":"' . admin_url( 'admin-ajax.php' ) . '"}; /* ]]> */</script>';

		$inline_scripts .= '<script type="text/javascript" src="' . WPF_MEDIA_TOOLS_DIR_URL . 'assets/wpf-media-tools.js?ver=' . WPF_MEDIA_TOOLS_VERSION . '"></script>';

		$value = $inline_scripts . str_replace( '<iframe ', '<iframe ' . $data_atts, $value );

		return $value;

	}


}

new WPF_Media_Tools_Compat();
