
jQuery(document).ready(function($){

	// Apply tags

	function applyTags(tags) {

		var data = {
			'action'	 : 'apply_tags',
			'tags'		 : tags,
		};

		$.post(wpf_mt_ajax.ajaxurl, data);

	}

	function sortNumber(a,b) {
        return a - b;
    }

	// Get data attributes from player

	function getPlayerData(el) {

		var playerData = $(el).data();

		// Build object of registered timecodes and tags
		
		if( typeof playerData.wpf_tags_timecode !== 'undefined' && typeof playerData.wpf_timecode !== 'undefined' ) {

			playerData.timecodeTags = {};

			$.each(playerData, function(index, val) {

				 if(index.startsWith('wpf_timecode')) {

					// Get index of timecode
					var i = index.replace('wpf_timecode', '');

					// Convert mm:ss format to seconds
					var pieces = val.toString().split(":");

					if(pieces.constructor === Array) {
						var seconds = pieces.pop();
						$.each(pieces, function(pieceIndex, pieceVal) {
							seconds = parseFloat(seconds) + (pieceVal * 60);
						});
					} else {
						var seconds = pieces;
					}

					playerData.timecodeTags[seconds] = playerData['wpf_tags_timecode' + i];

				 }

			});

		}

		return playerData;


	}

	// Mediaelement.js embeds

	$('video').each(function(index, el) {
		
		var playerData = getPlayerData(el);

		if ( typeof playerData.wpf_tags_start == 'undefined' && typeof playerData.wpf_tags_complete == 'undefined' && typeof playerData.timecodeTags == 'undefined' ) {
			return;
		}

		new MediaElement($(this).attr('id'), {

			success: function (mediaElement, domObject) {

				if ( typeof playerData.wpf_tags_start != 'undefined' ) {

					mediaElement.addEventListener('play', function(e) {

						// mediaElement start video

						applyTags(playerData.wpf_tags_start);

					});

				}

				if ( typeof playerData.wpf_tags_complete != 'undefined' ) {

					mediaElement.addEventListener('ended', function(e) {

						// mediaElement video complete

						applyTags(playerData.wpf_tags_complete);

					});

				}

				if ( typeof playerData.timecodeTags != 'undefined' ) {

					mediaElement.addEventListener('timeupdate', function(e) {

						// mediaElement player progress

						if(Object.keys(playerData.timecodeTags).length == 0)
							return;

						$.each(playerData.timecodeTags, function(timecode, tags) {
							 
							 if(mediaElement.currentTime >= timecode) {
								applyTags(tags);
								delete playerData.timecodeTags[timecode];
							 }

						});

					});

				}

			}
		});

	});

	// Initialize Vimeo player tracking on an element

	function initializeVimeo( el ) {

		var playerData = getPlayerData( el );

		var player = new Vimeo.Player( el );

		// Set it as ready

		$(el).attr( 'data-wpf_init', true );

		if ( typeof playerData.wpf_tags_start != 'undefined' ) {

			var startDone = false;

			player.on('play', function() {

				// Vimeo started video
				
				if(startDone == false) {
					startDone = true;
					applyTags(playerData.wpf_tags_start);
				}
			});

		}

		if ( typeof playerData.wpf_tags_complete != 'undefined' ) {

			var completeDone = false;
			
			player.on('timeupdate', function(data) {

				if (data.percent >= 0.95 && completeDone == false) {

					// Vimeo 95% complete

					completeDone = true;
					applyTags(playerData.wpf_tags_complete);
				}

			});

		}

		if ( typeof playerData.timecodeTags != 'undefined' ) {

			player.on('timeupdate', function(data) {

				// Vimeo player progress

				if( Object.keys( playerData.timecodeTags ).length == 0 ) {
					return;
				}

				$.each(playerData.timecodeTags, function(timecode, tags) {

					if ( timecode.endsWith('%') ) {

						// Percentage based tracking

						var percent = parseInt( timecode.replace('%', '') );
						percent = percent / 100;

						 if( data.percent >= percent ) {
							applyTags(tags);
							delete playerData.timecodeTags[timecode];
						 }

					} else {
					 
						 if(data.seconds >= timecode) {
							applyTags(tags);
							delete playerData.timecodeTags[timecode];
						 }

					}

				});

			});

		}

	}

	// Initialize YouTube player tracking on an element

	function initializeYouTube( el ) {

		if ( typeof YT == 'undefined' ) {
			console.log('YouTube API Undefined. Unable to initialize WP Fusion media tracking.');
			return;
		}

		var playerData = getPlayerData( el );

		var playerId = $(el).attr('id');

		if ( ! playerId ) {
			playerId = 'ytplayer' + Math.floor(Math.random() * 100);
			$(el).attr('id', playerId);
		}

		var appliedStart = false;

		player = YT.get( playerId );

		if ( typeof player == 'undefined' ) {

			// Create a new player

			player = new YT.Player( playerId, {
				events: {
					'onReady': onPlayerReady,
					'onStateChange': onPlayerStateChange
				},
			});

		} else {

			// The player was created by another plugin

			player.addEventListener( 'onReady', onPlayerReady );
			player.addEventListener( 'onStateChange', onPlayerStateChange );

		}

		// Set it as ready

		$(el).attr( 'data-wpf_init', true );

		// Elementor image overlay support
		$('.elementor-custom-embed-image-overlay').parent().has( '#' + playerId ).click(function(event) {
			
			if( typeof playerData.wpf_tags_start != 'undefined' ) {
				applyTags(playerData.wpf_tags_start);
				appliedStart = true;
			}

		});

		function onPlayerStateChange(event) {

			if (event.data == YT.PlayerState.PLAYING && typeof playerData.wpf_tags_start != 'undefined' ) {

				// YouTube started video

				if( appliedStart == false ) {
					applyTags(playerData.wpf_tags_start);
					appliedStart = true;
				}

			} else if( event.data == YT.PlayerState.ENDED && typeof playerData.wpf_tags_complete != 'undefined' ) {

				// YouTube finished video

				// This doesn't currently work when both FitVids (Boss Theme) and Elementor are in use at the same time

				applyTags(playerData.wpf_tags_complete);

			}

		}

		function onPlayerReady(event) {

			if ( typeof playerData.timecodeTags != 'undefined' ) {

				var videotime = 0;
				var timeupdater = null;

				function updateTime() {

					var oldTime = videotime;

					if(player && player.getCurrentTime) {
						videotime = player.getCurrentTime();
					}

					if(videotime !== oldTime) {
						onProgress(videotime);
					}
				}

				timeupdater = setInterval(updateTime, 500);

			}

		}

		function onProgress(currentTime) {

			var progressTags = [];

			if ( typeof playerData.wpf_tags_start != 'undefined' && appliedStart == false ) {

				progressTags = progressTags.concat( playerData.wpf_tags_start );
				appliedStart = true;

			}

			// YouTube 500ms player progress

			if( Object.keys(playerData.timecodeTags).length > 0 ) {

				$.each(playerData.timecodeTags, function(timecode, tags) {
					 
					 if(currentTime >= timecode) {
						progressTags = progressTags.concat( tags );
						delete playerData.timecodeTags[timecode];
					 }

				});

			}

			if ( progressTags.length ) {
				applyTags( progressTags );
			}


		}

	}

	// Initialize Wistia player tracking on an element

	function initializeWistia( el ) {

		var playerData = getPlayerData( el );

		window._wq = window._wq || [];

		var videoObject = Wistia.api( $(el).attr('id') );

		// Set it as ready

		$(el).attr( 'data-wpf_init', true );

		_wq.push({
			// id: videoObject.hashedId(), 
			id: '_all',
			onReady: function(video) {

				if (typeof playerData.wpf_tags_start != 'undefined') {

					var startDone = false;

					video.bind( 'play', function () {

						// Wistia start video

						if (startDone == false) {

							startDone = true;
							applyTags(playerData.wpf_tags_start);

						}
					});

				}

				if ( typeof playerData.wpf_tags_complete != 'undefined' ) {

					var completeDone = false;

					video.bind('timechange', function(t) {

						if ( t / video.duration() >= 0.95 && completeDone == false) {

							// Wistia 95% complete

							completeDone = true;
							applyTags(playerData.wpf_tags_complete);

						}

					});

				}

				if ( typeof playerData.timecodeTags != 'undefined' ) {

					video.bind('timechange', function(t) {

						if( Object.keys(playerData.timecodeTags).length == 0 ) {
							return;
						}

						$.each(playerData.timecodeTags, function(timecode, tags) {

							// Wistia player progress

							if( t >= timecode ) {

								applyTags(tags);
								delete playerData.timecodeTags[timecode];

							}

						});

					});
				}
			}

		});

	}

	// Initialize VooPlayer player tracking on an element

	function initializeVooPlayer( el ) {

		var playerData = getPlayerData( el );

		var playerId = $(el).attr('data-playerid');

		document.addEventListener('vooPlayerReady', function( event ) {

			// Set it as ready

			$(el).attr( 'data-wpf_init', true );

			// VooPlayer can't tell you the current time (annoying), so you have to create an array of all the timecodes
			// you're interested in first, and pass them to vooAPI( playerId, 'getTime' ) and it will tell you if the current
			// time is close to one of your defined timecodes.

			var completeTimecode = false;

			var startDone = false;
			var completeDone = false;
			var vooTimecodes = [ 1 ];

			// Merge in timecodes
			if ( typeof playerData.timecodeTags != 'undefined' && Object.keys(playerData.timecodeTags).length != 0 ) {

				$.each(playerData.timecodeTags, function(timecode, tags) {

					vooTimecodes.push( parseInt( timecode ) );

				});

			}

			vooAPI(playerId, 'getDuration', ['1'], function( duration ) {

				completeTimecode = parseInt( Math.floor( duration * 0.95 ) );
				vooTimecodes.push( completeTimecode );

				vooTimecodes.sort(sortNumber);

			});

			function checkVooProgress() {

				vooAPI(playerId, 'getTime', vooTimecodes, checkTimecodes);

				function checkTimecodes( time ) {

					if (typeof playerData.wpf_tags_start != 'undefined') {

						if (startDone == false) {

							startDone = true;
							applyTags(playerData.wpf_tags_start);

							vooTimecodes.splice( $.inArray('1', vooTimecodes), 1 );

							vooAPI(playerId, 'getTime', vooTimecodes, checkTimecodes);

						}

					}

					if ( typeof playerData.wpf_tags_complete != 'undefined' ) {

						if (completeDone == false && time == completeTimecode ) {

							completeDone = true;
							applyTags(playerData.wpf_tags_complete);

							clearInterval( vooProgressChecker );

						}

					}

					if ( typeof playerData.timecodeTags != 'undefined' ) {

						if(Object.keys(playerData.timecodeTags).length == 0)
							return;

						$.each(playerData.timecodeTags, function(timecode, tags) {

							if( timecode == time ) {

								applyTags(tags);
								delete playerData.timecodeTags[timecode];

								vooTimecodes.splice( $.inArray(timecode, vooTimecodes), 1 );

								vooAPI(playerId, 'getTime', vooTimecodes, checkTimecodes);

							}

						});

					}

				}

			}

			var vooProgressChecker = setInterval(checkVooProgress, 1000);

		});

	}

	// Generic initializer. Checks the type and calls the right function

	function initializePlayer( el ) {

		var playerType = $(el).attr('data-player_type');

		if ( typeof playerType == 'undefined' ) {
			return; // If WP Fusion isn't set on this player
		}

		if( playerType == 'vimeo') {

			initializeVimeo( el );

		} else if( playerType == 'youtube') {

			initializeYouTube( el );

		} else if ( playerType == 'wistia') {

			initializeWistia( el );

		} else if ( playerType == 'vooplayer') {

			initializeVooPlayer( el );

		}

	}

	//
	// Try to find videos to interact with
	//

	// To start, on page load we'll go through all the iFrames and see if any are eligible

	function initializeIFrames() {

		$('iframe').each(function(index, el) {
			initializePlayer( el );
		});

	}

	setTimeout( initializeIFrames, 1000 );

	// PrestoPlayer

	if ( typeof wp != 'undefined' && typeof wp.hooks != 'undefined' ) {

		wp.hooks.addAction( 'presto.playerReady', 'wp-fusion-media-tools', (player) => {

			var container = $( player.elements.container.getRootNode().host || player.elements.container ).closest('figure');

			var playerType = container.attr('data-player_type');

			if ( typeof playerType == 'undefined' ) {
				return; // If WP Fusion isn't set on this player
			}

			player.wpfData = getPlayerData( container );

			if (typeof player.wpfData.wpf_tags_start != 'undefined') {

				// Started playing

				var startDone = false;

				player.on( 'playing', event => {

					const player = event.detail.plyr;

					if (startDone == false) {

						startDone = true;
						applyTags(player.wpfData.wpf_tags_start);

					}
				});

			}

			// Completed

			var completeDone = false;

			player.on( 'timeupdate', event => {

				const player = event.detail.plyr;

				if ( typeof player.wpfData.wpf_tags_complete != 'undefined' ) {

					if ( player.currentTime / player.duration >= 0.95 && completeDone == false) {

						// 95% complete

						completeDone = true;
						applyTags(player.wpfData.wpf_tags_complete);

					}

				}

				if ( typeof player.wpfData.timecodeTags != 'undefined' ) {

					$.each(player.wpfData.timecodeTags, function(timecode, tags) {
						
						if ( timecode.endsWith('%') ) {

							// Percentage based tracking
	
							var percent = parseInt( timecode.replace('%', '') );
							percent = percent / 100;
	
							 if( ( player.currentTime / player.duration ) >= percent ) {
								applyTags(tags);
								delete player.wpfData.timecodeTags[timecode];
							 }
	
						} else {

							if( player.currentTime >= timecode ) {

								applyTags(tags);
								delete player.wpfData.timecodeTags[timecode];

							}
						}

					});

				}

			});

		});
	}

});