<?php

GFForms::include_feed_addon_framework();

/**
 * Gravity Forms integration.
 *
 * @since 1.0.0
 */
class WPF_ET_Gravity_Forms_Feed extends GFFeedAddOn {

	protected $_version                  = WPF_EVENT_TRACKING_VERSION;
	protected $_min_gravityforms_version = '1.7.9999';
	protected $_slug                     = 'wpf-event-tracking';
	protected $_full_path                = __FILE__;
	protected $_title                    = 'CRM Integration';
	protected $_short_title              = 'Event Tracking';
	protected $postvars                  = array();
	public $feed_lists;

	protected $_capabilities_settings_page = array( 'manage_options' );
	protected $_capabilities_form_settings = array( 'manage_options' );
	protected $_capabilities_plugin_page   = array( 'manage_options' );
	protected $_capabilities_app_menu      = array( 'manage_options' );
	protected $_capabilities_app_settings  = array( 'manage_options' );
	protected $_capabilities_uninstall     = array( 'manage_options' );

	private static $_instance = null;

	/**
	 * Get an instance of this class.
	 *
	 * @since  1.0.0
	 *
	 * @return WPF_ET_Gravity_Forms_Feed
	 */
	public static function get_instance() {
		if ( null === self::$_instance ) {
			self::$_instance = new WPF_ET_Gravity_Forms_Feed();
		}

		return self::$_instance;
	}


	// # FEED PROCESSING -----------------------------------------------------------------------------------------------

	/**
	 * Process the feed e.g. subscribe the user to a list.
	 *
	 * @param array $feed The feed object to be processed.
	 * @param array $entry The entry object currently being processed.
	 * @param array $form The form object currently being processed.
	 *
	 * @return bool|void
	 */
	public function process_feed( $feed, $entry, $form ) {

		$event = array(
			'name'  => GFCommon::replace_variables( str_replace( 'form:', '', $feed['meta']['form_submitted']['name'] ), $form, $entry, false, false, false, 'text' ),
			'value' => GFCommon::replace_variables( str_replace( 'form:', '', $feed['meta']['form_submitted']['value'] ), $form, $entry, false, false, false, 'text' ),
		);

		$email_address = wpf_get_current_user_email();

		if ( ! $email_address ) {
			// If the person isn't identified, check the form.
			foreach ( $entry as $field ) {
				if ( is_email( $field ) ) {
					$email_address = $field;
					break;
				}
			}
		}

		wp_fusion_event_tracking()->integrations->{'gravity-forms'}->track_event( $event, $email_address );

	}

	// # ADMIN FUNCTIONS -----------------------------------------------------------------------------------------------

	/**
	 * Configures the settings which should be rendered on the feed edit page in
	 * the Form Settings > Event Tracking area.
	 *
	 * @since  1.0.0
	 *
	 * @return array The settings.
	 */
	public function feed_settings_fields() {
		return array(
			array(
				'title'  => esc_html__( 'WP Fusion - Event Tracking Settings', 'wp-fusion-event-tracking' ),
				'fields' => array(
					array(
						'label' => esc_html__( 'Track Event', 'wp-fusion-event-tracking' ),
						'type'  => 'wpf_event_tracking',
						'name'  => 'form_submitted',
					),
					array(
						'name'           => 'condition',
						'label'          => esc_html__( 'Condition', 'wp-fusion-event-tracking' ),
						'type'           => 'feed_condition',
						'checkbox_label' => esc_html__( 'Enable Condition', 'wp-fusion-event-tracking' ),
						'instructions'   => esc_html__( 'Process this simple feed if', 'wp-fusion-event-tracking' ),
					),
				),
			),
		);
	}


	/**
	 * Custom callback for the wpf_event_tracking field type. Currently not in
	 * use.
	 *
	 * @since 1.0.0
	 *
	 * @param array $field  The field.
	 * @return mixed HTML output.
	 */
	public function settings_wpf_event_tracking( $field ) {

		$form = $this->get_current_form();

		$args = array(
			'meta_name' => '_gform_setting_' . $field['name'],
			'field_id'  => null, // this gives us an input with name _gform_setting_form_submitted[name], which lets GF save it properly.
			'setting'   => $this->get_setting( $field['name'] ),
		);

		wp_fusion_event_tracking()->integrations->{'gravity-forms'}->render_event_tracking_fields( 'form_submitted', $form['id'], $args );

	}

	/**
	 * Configures which columns should be displayed on the feed list page.
	 *
	 * @since  1.0.0
	 *
	 * @return array The feed list columns.
	 */
	public function feed_list_columns() {
		return array(
			'eventname'  => esc_html__( 'Event Name', 'wp-fusion-event-tracking' ),
			'eventvalue' => esc_html__( 'Event Value', 'wp-fusion-event-tracking' ),
		);
	}

	/**
	 * Display the event name column.
	 *
	 * @since  1.0.0
	 *
	 * @param  array $feed The feed being included in the feed list.
	 * @return string The event name.
	 */
	public function get_column_value_eventname( $feed ) {
		return '<b>' . rgars( $feed, 'meta/form_submitted/name' ) . '</b>';
	}


	/**
	 * Display the event value column.
	 *
	 * @since  1.0.0
	 *
	 * @param  array $feed The feed being included in the feed list.
	 * @return string The event value.
	 */
	public function get_column_value_eventvalue( $feed ) {
		return '<b>' . rgars( $feed, 'meta/form_submitted/value' ) . '</b>';
	}


	/**
	 * Return the plugin's icon for the plugin/form settings menu.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_menu_icon() {

		return wpf_logo_svg();

	}

}
