<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Renders the field select HTML for admin pages
 *
 * @since  1.0.0
 *
 * @param  array $args   The arguments.
 * @return mixed HTML inputs.
 */
function wpf_render_event_tracking_fields( $args = array() ) {

	// Default values.

	$defaults = array(
		'meta_name'   => 'wpf_event_tracking_settings',
		'field_id'    => null,
		'integration' => false,
		'trigger'     => false,
		'setting'     => array(
			'name'  => '',
			'value' => '',
		),
		'class'       => '',
	);

	$args = wp_parse_args( $args, $defaults );

	if ( empty( $args['setting'] ) ) {
		$args['setting'] = array(
			'name'  => false,
			'value' => false,
		);
	}

	// Get the field ID.
	if ( false === $args['field_id'] ) {
		$field_id = sanitize_html_class( $args['meta_name'] );
	} else {
		$field_id = sanitize_html_class( $args['meta_name'] ) . '-' . $args['field_id'];
	}

	$field_name = esc_attr( $args['meta_name'] ) . ( ! is_null( $args['field_id'] ) ? '[' . esc_attr( $args['field_id'] ) . ']' : '' );

	echo '
		<span class="wpf-event-tracking" data-trigger="' . esc_attr( $args['trigger'] ) . '" data-integration="' . esc_attr( $args['integration'] ) . '">
			<span class="wpf-event-tracking-input-container">
				<label for="' . esc_attr( $args['field_id'] ) . '" data-placeholder="Name:"></label>
				<input value="' . esc_attr( $args['setting']['name'] ) . '" name="' . esc_attr( $field_name ) . '[name]" id="' . esc_attr( $args['field_id'] ) . '" class="wpf-et-name" type="text">
				<span class="right input">
					<a class="open-list tooltip-merge-tag"></a>
				</span>
			</span>

			<select id="' . esc_attr( $field_id ) . '-name-select" class="select4-event-tracking"></select>

			<span class="wpf-event-tracking-input-container">
				<label for="' . esc_attr( $args['field_id'] ) . '_value" data-placeholder="Value:"></label>
				<input value="' . esc_attr( $args['setting']['value'] ) . '" name="' . esc_attr( $field_name ) . '[value]" id="' . esc_attr( $args['field_id'] ) . '_value" class="wpf-et-value" type="text">
				<span class="right input">
					<a class="open-list tooltip-merge-tag"></a>
				</span>
			</span>

			<select id="' . esc_attr( $field_id ) . '-value-select" class="select4-event-tracking"></select>

			<span class="wpf-container wpf-preview">
				<span class="label">' . esc_html__( 'Preview', 'wp-fusion-event-tracking' ) . ':</span>
				<span class="wpf-event-tracking-preview event-name hidden"></span>
				<span class="wpf-event-tracking-preview event-value hidden"></span>
			</span>        
		</span>
	';

}
