jQuery(document).ready(function($){

	$(document).on('click','.wpf-event-tracking a.open-list', function( e ) {
		e.preventDefault();

		var inputContainer = $(this).closest( 'span.wpf-event-tracking-input-container' );
		var select = inputContainer.next( 'select.select4-event-tracking' );

		if ( ! select.data( 'select4' ) ) {

			var trigger     = $(this).closest( '.wpf-event-tracking' ).attr( 'data-trigger' );
			var integration = $(this).closest( '.wpf-event-tracking' ).attr( 'data-integration' );

			var data = []

			wpfEventData.triggers[ integration ][ trigger ].options.forEach( function( element ) {

				var group = {
					text: element.name,
					children: [ '' ] // for some reason the first item isn't selectable so we'll just add an empty array key here.
				}

				element.options.forEach( function( option ) {

					var text = '{' + element.type + ':' + option.meta + '}';

					group.children.push(
						{
							id: text,
							text: text,
						}
					);

				} );

				data.push( group );

			} );

			select.select4({
				allowClear: true,
				theme: 'wpf-events',
				width: '250px',
				data: data,
			}).on('select4:select', function(event) {

				let value = event.params.data.text;
				let text_field = inputContainer.find('input[type=text]');
				let text_value = text_field.val();
				let cursorPos = text_field.prop('selectionStart');

				if ( cursorPos > 0 || ( cursorPos == 0 && text_value.length == 0 ) ) {

					// If it's empty or we're inserting at the cursor.
					var textBefore = text_value.substring(0,  cursorPos);
					var textAfter  = text_value.substring(cursorPos, text_value.length);

				} else {

					// If we're appending to the end.
					var textBefore = text_value;
					var textAfter  = '';

				}

				
				text_field.val(textBefore.trim() + ' ' + value + textAfter);
				text_field.focus().change();
				select.val([]); // clear the select
			});

		}

		select.select4('open');

	});

	$(document).on('change','td.trigger select.trigger', function() {

		$(this).closest( 'tr' ).find( 'select.select4-hidden-accessible option, select.select4-hidden-accessible optgroup' ).remove();
		$(this).closest( 'tr' ).find( 'select.select4-hidden-accessible' ).select4( 'destroy' ); // clear out the old options
		$(this).next( 'span.description' ).html( $(this).find( 'option:selected' ).attr( 'data-description' ) ); // update the description
		$(this).closest( 'tr' ).find( 'span.wpf-event-tracking' ).attr( 'data-trigger', $(this).find( 'option:selected' ).val() ); // update the data atts on the container.

	});

	$(document).on('input change','.wpf-event-tracking input[type=text]', function() {

		if ( ! $(this).val() ) {
			return;
		}

		// Build up the text values and replacements.

		var trigger     = $(this).closest( '.wpf-event-tracking' ).attr( 'data-trigger' );
		var integration = $(this).closest( '.wpf-event-tracking' ).attr( 'data-integration' );

		var previews = [];

		wpfEventData.triggers[ integration ][ trigger ].options.forEach( function( element ) {

			element.options.forEach( function( option ) {

				previews.push( {
					text: '{' + element.type + ':' + option.meta + '}',
					preview: option.preview,
				} );

			} );
		} );

		var input = $(this);
		var text_value = input.val();

		// Convert shortcodes
		if( text_value.includes('{') && text_value.includes('}') ) {

			var matches = text_value.split('{')
			.filter(function(v){ return v.indexOf('}') > -1})
			.map( function(value) { 
			  return value.split('}')[0]
			});
			matches.forEach(function(match){

				let new_match = '{' + match + '}';

				previews.forEach( function( element ) {

					if ( element.text == new_match ) {
						text_value = text_value.replace( new_match, '<b>' + element.preview + '</b>');
					}

				} );

			});

		}

		if( text_value != '' ){
			input.closest('.wpf-event-tracking').find('.wpf-preview').show();
		}

		if( input.attr('class') == 'wpf-et-name' ){
			input.closest('.wpf-event-tracking').find('.wpf-preview .event-name').html( text_value );
		} else if( input.attr('class') == 'wpf-et-value' ){
			input.closest('.wpf-event-tracking').find('.wpf-preview .event-value').html( text_value );
		}
		
	});

	// EDD Recurring subscription.
	$(document).on('input change','#edd_recurring',function(){
		if($(this).val() === 'yes'){
			$('.wpf-event-tracking').find('[data-trigger=edd_subscription_status_changed]').parents('table').show();
		}else{
			$('.wpf-event-tracking').find('[data-trigger=edd_subscription_status_changed]').parents('table').hide();
		}
	});

	if($('#edd_recurring').length > 0){
		if($('#edd_recurring').val() === 'no'){
			$('.wpf-event-tracking').find('[data-trigger=edd_subscription_status_changed]').parents('table').hide();
		}
	}

	// Trigger preview on page load.
	$('.wpf-event-tracking input[type=text]').trigger('change');

	// Option Page scripts
	if( $( '#wpf_et_option_page .wpf-repeater' ).length ){

		$( '#wpf_et_option_page .wpf-repeater' ).repeater(
			{
				initEmpty: false,
				show: function () {

					$( this ).slideDown();
					var main_parent = $( this ).parents( '.wpf-repeater' );
					$( '.order span',main_parent ).each(
						function (i) {
							var numbering = i + 1;
							$( this ).text( numbering );
						}
					);

					// fixing the issue of the labels
					var params = [this];
					$( this ).find( "label[for]" ).each(
						function(index, element) {
							var currentRepeater = params[0];
							var originalFieldId = $( element ).attr( "for" );
							var newField        = $( currentRepeater ).find( "select[id='" + originalFieldId + "']" );
							if ($( newField ).length > 0) {
								var newFieldName = $( newField ).attr( 'name' );
								$( newField ).attr( 'id', newFieldName );
								$( currentRepeater ).find( "label[for='" + originalFieldId + "']" ).attr( 'for', newFieldName );
							}
						},
						params
					);

					// Fix select4
					$( '.select4-container',$( this ) ).remove();
					$( '.trigger option:first',$( this ) ).attr( 'selected',false ).attr( 'selected',true );
					$( '.wpf-preview .event-name,.wpf-preview .event-value',$( this ) ).html( '' );

				},
				hide: function (deleteElement) {
					if (confirm( 'Are you sure you want to delete this trigger?' )) {
						$( this ).slideUp( deleteElement );
					}
				},
				ready: function (setIndexes) {
					$( ".wpf-repeater .table_body" ).on(
						"sortupdate",
						function( event, ui ) {
							setIndexes();
						}
					);
				},
				isFirstItemUndeletable: false
			}
		);

		$( ".wpf-repeater .table_body" ).sortable(
			{
				handle: '.order',
				update: function (event, ui) {
					$( '.order span',$( this ).parents( '.wpf-repeater' ) ).each(
						function (i) {
							var numbering = i + 1;
							$( this ).text( numbering );
						}
					);
				}
			}
		);

		function wpf_limit_chars(limit){
			var title_limit_notice = wpfEventData.crms_notices.title_limit.replace('{limit}',limit);


			// Limit title.
			$('.wpf-event-tracking .wpf-et-name').each(function(index,this_field){
				this_field = $(this);

				if(this_field.val().length > limit){
					this_field.addClass('wpf-tip wpf-tip-bottom').attr('data-tip', title_limit_notice);
					$( '.wpf-tip.wpf-tip-bottom' ).tipTip({
						'attribute': 'data-tip',
						'delay': 0,
						'activation':'focus',
						'defaultPosition': 'top',
					});
					this_field.css('color','#cc0000');
				}
	
			});
		
			$(document).on('input','.wpf-event-tracking .wpf-et-name', function() {
				var this_field = $(this);

				if(this_field.val().length > limit){
					this_field.addClass('wpf-tip wpf-tip-bottom').attr('data-tip', title_limit_notice);
					$( '.wpf-tip.wpf-tip-bottom' ).tipTip({
						'attribute': 'data-tip',
						'delay': 0,
						'activation':'focus',
						'defaultPosition': 'top',
					});
					this_field.css('color','#cc0000');
					this_field.focus();
				}else{
					this_field.css('color','#000');
					$('#tiptip_holder').remove();
				}
			});
		}

		if ( wpfEventData.crm === 'activecampaign' ) {
			wpf_limit_chars(40);
		}

		if ( wpfEventData.crm === 'mailchimp' ) {
			wpf_limit_chars(30);
		}

	}

} );
