<?php

/*
Plugin Name: WP Fusion - Downloads Addon
Description: Protects media library items using a user's CRM tags
Plugin URI: https://wpfusion.com/
Version: 1.2.2
Author: Very Good Plugins
Author URI: https://verygoodplugins.com/
Text Domain: wp-fusion
*/

/**
 * @copyright Copyright (c) 2016. All rights reserved.
 *
 * @license   Released under the GPL license http://www.opensource.org/licenses/gpl-license.php
 *
 * **********************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * **********************************************************************
 */


// deny direct access
if ( ! function_exists( 'add_action' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

define( 'WPF_DOWNLOADS_VERSION', '1.2.2' );


/**
 * Class WP_Fusion_Downloads
 *
 * @since 1.0
 * @return void
 */
final class WP_Fusion_Downloads {

	/** Singleton *************************************************************/

	/**
	 * @var WP_Fusion_Downloads The one true WP_Fusion_Downloads
	 * @since 1.0
	 */
	private static $instance;

	/**
	 * Allows interfacing with the main class
	 *
	 * @var WPF_Downloads_Public
	 * @since 1.0
	 */
	public $public;


	/**
	 * instance
	 *
	 * Main WP_Fusion_Downloads Instance
	 *
	 * Insures that only one instance of WP_Fusion_Downloads exists in memory at any one
	 * time. Also prevents needing to define globals all over the place.
	 *
	 * @since     1.0
	 * @static
	 * @staticvar array $instance
	 * @return The one true WP_Fusion_Downloads
	 */

	public static function instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof WP_Fusion_Downloads ) ) {

			self::$instance = new WP_Fusion_Downloads();
			self::$instance->register_hooks();
			self::$instance->setup_constants();
			self::$instance->includes();

			self::$instance->public = new WPF_Downloads_Public();

		}

		return self::$instance;
	}

	public function register_hooks() {

		register_activation_hook( __FILE__, array( $this, 'plugin_install' ) );
		add_action( 'plugins_loaded', array( $this, 'updater' ) );

	}

	/**
	 *  plugin_install
	 *
	 * flush the rules on install
	 */

	public function plugin_install() {

		//Remove rewrite rules and then recreate rewrite rules.
		//NOTE: WP Core function
		flush_rewrite_rules();

	}

	/**
	 * __clone
	 *
	 * Throw error on object clone
	 *
	 * The whole idea of the singleton design pattern is that there is a single
	 * object therefore, we don't want the object to be cloned.
	 *
	 * @access protected
	 * @return void
	 */

	public function __clone() {
		// Cloning instances of the class is forbidden
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'wp-fusion' ), '1.0' );
	}

	/**
	 * __wakeup
	 *
	 * Disable unserializing of the class
	 *
	 * @access protected
	 * @return void
	 */

	public function __wakeup() {
		// Unserializing instances of the class is forbidden
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'wp-fusion' ), '1.0' );
	}

	/**
	 * setup_constants
	 *
	 * Setup plugin constants
	 *
	 * @access private
	 * @return void
	 */

	private function setup_constants() {

		if ( ! defined( 'WPF_DOWNLOADS_DIR_PATH' ) ) {
			define( 'WPF_DOWNLOADS_DIR_PATH', plugin_dir_path( __FILE__ ) );
		}

		if ( ! defined( 'WPF_DOWNLOADS_PLUGIN_PATH' ) ) {
			define( 'WPF_DOWNLOADS_PLUGIN_PATH', plugin_basename( __FILE__ ) );
		}

		if ( ! defined( 'WPF_DOWNLOADS_DIR_URL' ) ) {
			define( 'WPF_DOWNLOADS_DIR_URL', plugin_dir_url( __FILE__ ) );
		}

		if ( ! defined( 'WPF_DOWNLOADS_ENDPOINT' ) ) {
			define( 'WPF_DOWNLOADS_ENDPOINT', 'wpfd' );
		}

	}


	/**
	 * includes
	 *
	 * Include required files
	 *
	 * @access private
	 * @return void
	 */

	private function includes() {

		// handling files
		require_once WPF_DOWNLOADS_DIR_PATH . 'includes/class-file.php';

		// handling .htaccess
		require_once WPF_DOWNLOADS_DIR_PATH . 'includes/class-htaccess.php';

		if ( is_admin() ) {
			require_once WPF_DOWNLOADS_DIR_PATH . 'includes/admin/class-admin.php';
		}

		require_once WPF_DOWNLOADS_DIR_PATH . 'includes/class-public.php';

	}

	/**
	 * updater
	 *
	 * Set up EDD updater
	 *
	 * @access public
	 * @return void
	 */

	public function updater() {

		if ( ! is_admin() || ! class_exists( 'WPF_Plugin_Updater' ) ) {
			return;
		}

		$license_status = wp_fusion()->settings->get( 'license_status' );
		$license_key    = wp_fusion()->settings->get( 'license_key' );

		if ( $license_status == 'valid' ) {

			// setup the updater
			$edd_updater = new WPF_Plugin_Updater(
				WPF_STORE_URL, __FILE__, array(
					'version' => WPF_DOWNLOADS_VERSION,
					'license' => $license_key,
					'item_id' => 17571,
					'author'  => 'Very Good Plugins',
				)
			);

		} else {

			global $pagenow;

			if ( 'plugins.php' === $pagenow ) {
				add_action( 'after_plugin_row_' . WPF_DOWNLOADS_PLUGIN_PATH, array(
					wp_fusion(),
					'wpf_update_message',
				), 10, 3 );
			}
		}

	}

}


/**
 * wp_fusion_downloads
 *
 * The main function responsible for returning the one true WP Fusion Downloads
 * Instance to functions everywhere.
 *
 * Use this function like you would a global variable, except without needing
 * to declare the global.
 *
 * Example: <?php $wpfd = wp_fusion_downloads(); ?>
 *
 * @return object The one true WP Fusion Downloads
 */

function wp_fusion_downloads() {

	return WP_Fusion_Downloads::instance();

}

wp_fusion_downloads();
