<?php
/**
 * All HubSpot needed general settings.
 *
 * @link       https://makewebbetter.com/
 * @since      1.0.0
 *
 * @package    makewebbetter-hubspot-for-woocommerce
 * @subpackage makewebbetter-hubspot-for-woocommerce/admin/templates/
 */

global $hubwoo;
?>

<div class="hubwoo-gs-wrap hubwoo-gs-wrap--gen">
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot Recommended Products Addon', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Recommend related products automatically to increase average order value at your store. With this add-on, you can select the products you want to offer as recommendations and send them through automated emails after the purchase.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/hubspot-recommended-products-addon/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( '$79 Buy Now', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot Field To Field Sync', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Automate the process of syncing all of your customer information to HubSpot for quicker access and efficient decision making process. With Field to Field Sync for HubSpot, you can easily map HubSpot contact properties and the WordPress users’ fields.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/product/hubspot-field-to-field-sync/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( '$79 Buy Now', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot Deals For WooCommerce Memberships', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'HubSpot Deals for WooCommerce Memberships enables you to organize your site members as HubSpot deals with relevant deal stage, plans and the opening and closing dates.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/product/hubspot-deals-for-woocommerce-memberships/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( '$59 Buy Now', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<h3 class="hubwoo-addon-heading"><?php esc_html_e( 'Additional Services', 'makewebbetter-hubspot-for-woocommerce' ); ?></h3>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot Onboarding Services', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Maximize your business’s potential with our HubSpot Onboarding Services. Our onboarding services include a personalized approach to streamline HubSpot implementation and training processes.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/hubspot-onboarding-services/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Get Started', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'Custom App/Integration Development Services', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Scale your business to new heights with unique functionalities and features that your customers will love. Get our dedicated HubSpot custom app/integration services to fulfill your unique business needs.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/hubspot-development-services/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Get Started', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot Themes', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Create aesthetic & responsive web pages with minimal efforts with HubSpot themes and offer a great experience on every device.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/hubspot-themes/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Get Started', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<div class="hubwoo-box-card hubwoo-box-n-card">
		<div class="hubwoo-box-n-card">
			<div class="hubwoo-box-n-card__content">
				<div class="hubwoo-fields-header hubwoo-common-header">
					<h2><?php esc_html_e( 'HubSpot Migration Services', 'makewebbetter-hubspot-for-woocommerce' ); ?></h2>
				</div>
				<div class="hubwoo-box-card__subtitle">
					<?php
						esc_html_e( 'Our HubSpot Migration Services help you to migrate your website from any CMS to HubSpot along with the blogs, automations, leads, deals, SMSs, calls & emails, etc. with experienced Hubspot migration consultants.', 'makewebbetter-hubspot-for-woocommerce' );
					?>
				</div>
			</div>
			<div class="hubwoo-box-n-card__btn">
				<div>
					<a href="https://makewebbetter.com/hubspot-migration-services/?utm_source=MWB-HubspotFree-backend&utm_medium=MWB-backend&utm_campaign=backend" target="_blank" class="hubwoo__btn "><?php esc_html_e( 'Get Started', 'makewebbetter-hubspot-for-woocommerce' ); ?></a>
				</div>
			</div>
		</div>
	</div>
</div>
