<?php
/**
 * Plugin Name: LearnPress Woo Dashboard
 * Plugin URI: https://albrightdesign.de
 * Description: Merge the woocommerce account dashboard into the learnpress account dashboard
 * Version: 4.0.1
 * Author: Benjamin Albrecht
 * Author URI: https://albrightdesign.de
 * Require_LP_Version: 3.0.0
 * License: 
 */


 /**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

define( 'LP_ADDON_WOODASH_FILE', __FILE__ );

/**
 * Class LP_Addon_Woo_Dashboard_Preload
 */
class LP_Addon_Woo_Dashboard_Preload {
	/**
	 * @var array|string[]
	 */
	public static $addon_info = array();

	/**
	 * LP_Addon_Woo_Dashboard_Preload constructor.
	 */
	public function __construct() {
		// Set Base name plugin.
		define( 'LP_ADDON_WOODASH_BASENAME', plugin_basename( LP_ADDON_WOODASH_FILE ) );

		// Set version addon for LP check .
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		self::$addon_info = get_file_data(
			LP_ADDON_WOODASH_FILE,
			array(
				'Name'               => 'Plugin Name',
				'Require_LP_Version' => 'Require_LP_Version',
				'Version'            => 'Version',
			)
		);

		define( 'LP_ADDON_WOODASH_VER', self::$addon_info['Version'] );
		define( 'LP_ADDON_WOODASH_REQUIRE_VER', self::$addon_info['Require_LP_Version'] );

		// Check LP activated .
		if ( ! is_plugin_active( 'learnpress/learnpress.php' ) ) {
			add_action( 'admin_notices', array( $this, 'show_note_errors_require_lp' ) );

			deactivate_plugins( LP_ADDON_WOODASH_BASENAME );

			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}

			return;
		}

		// Sure LP loaded.
		add_action( 'learn-press/ready', array( $this, 'load' ) );
	}

	/**
	 * Load addon
	 */
	public function load() {
		LP_Addon::load( 'LP_Addon_Woo_Dashboard', 'inc/load.php', __FILE__ );
	}

	public function show_note_errors_require_lp() {
		?>
		<div class="notice notice-error">
			<p><?php echo( 'Please active <strong>LP version ' . LP_ADDON_WOODASH_REQUIRE_VER . ' or later</strong> before active <strong>' . self::$addon_info['Name'] . '</strong>' ); ?></p>
		</div>
		<?php
	}
}

new LP_Addon_Woo_Dashboard_Preload();

