<?php
/**
 * Plugin load class.
 *
 * @author   ThimPress
 * @package  LearnPress/WooDashboard/Classes
 * @version  4.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'LP_Addon_Woo_Dashboard' ) ) {
	/**
	 * Class LP_Addon_Woo_Dashboard.
	 */
	class LP_Addon_Woo_Dashboard extends LP_Addon {

		/**
		 * @var string
		 */
		protected $_tab_slug_downloads = '';

		/**
		 * @var string
		 */
		protected $_tab_slug_orders = '';

		/**
		 * @var string
		 */
		protected $_tab_slug_address = '';


		/**
		 * @var string
		 */
		protected $_tab_slug_address_edit_billing = '';

				/**
		 * @var string
		 */
		protected $_tab_slug_address_edit_shipping = '';


		/**
		 * @var string
		 */
		public $version = LP_ADDON_WOODASH_VER;

		/**
		 * @var string
		 */
		public $require_version = LP_ADDON_WOODASH_REQUIRE_VER;

		/**
		 * Path file addon
		 *
		 * @var string
		 */
		public $plugin_file = LP_ADDON_WOODASH_FILE;

		/**
		 * LP_Addon_Wishlist constructor.
		 */
		public function __construct() {
			parent::__construct();
			add_filter( 'learn-press/profile-tabs', array( $this, 'download_tab' ), 100, 1 );
			$this->_tab_slug_downloads = sanitize_title( __( 'downloads', 'learnpress-woodash' ) );
			
			add_filter( 'learn-press/profile-tabs', array( $this, 'orders_tab' ), 100, 1 );
			$this->_tab_slug_orders = sanitize_title( __( 'w-orders', 'learnpress-woodash' ) );

			add_filter( 'learn-press/profile-tabs', array( $this, 'address_tab' ), 100, 1 );
			$this->_tab_slug_address = 'edit-address';

			$this->_tab_slug_address_edit_billing = 'edit-address/billing';
			$this->_tab_slug_address_edit_shipping = 'edit-address/shipping';
		}

		/**
		 * Defined constants.
		 */
		protected function _define_constants() {
			define( 'LP_ADDON_WOODASH_PATH', dirname( LP_ADDON_WOODASH_FILE ) );
			define( 'LP_ADDON_WOODASH_INC', LP_ADDON_WOODASH_PATH . '/inc/' );
			define( 'LP_ADDON_WOODASH_TEMPLATE', LP_ADDON_WOODASH_PATH . '/templates/' );
		}

		/**
		 * Includes files.
		 */
		protected function _includes() {
			include_once LP_ADDON_WOODASH_INC . 'functions.php';
		}

		/**
		 * Init hooks.
		 */
		protected function _init_hooks() {
			//add_action( 'learn-press/after-course-buttons', array( $this, '' ), 100 );
			//add_filter( 'learn_press_profile_tab_endpoints', array( $this, 'prowishlist_buttonfile_tab_endpoints' ) );
			//LP_Request_Handler::register_ajax( 'toggle_course_wishlist', array( $this, 'toggle_course_wishlist' ) );

			$this->rewrite_endpoint();
		}


		/**
		 * Wishlist scripts.
		 */
		protected function _enqueue_assets() {
			/* wp_enqueue_style( 'lp-course-wishlist-style',
				untrailingslashit( plugins_url( '/', LP_ADDON_WISHLIST_FILE ) ) . '/assets/css/wishlist.css' );
			wp_enqueue_script( 'lp-course-wishlist-script',
				untrailingslashit( plugins_url( '/', LP_ADDON_WISHLIST_FILE ) ) . '/assets/js/wishlist.js',
				array( 'jquery' ) ); */
		}

		/**
		 * Rewrite endpoint.
		 */
		public function rewrite_endpoint() {
			$endpoint                     = preg_replace( '!_!', '-', $this->get_downloads_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );

			$endpoint                     = preg_replace( '!_!', '-', $this->get_orders_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );

			$endpoint                     = preg_replace( '!_!', '-', $this->get_address_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );

			$endpoint                     = preg_replace( '!_!', '-', $this->get_address_edit_billing_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );

			$endpoint                     = preg_replace( '!_!', '-', $this->get_address_edit_shipping_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );
		}

		public function profile_tab_endpoints( $endpoints ) {
			$endpoints[] = $this->get_downloads_tab_slug();
			$endpoints[] = $this->get_orders_tab_slug();
			$endpoints[] = $this->get_address_tab_slug();
			$endpoints[] = $this->get_address_edit_billing_tab_slug();
			$endpoints[] = $this->get_address_edit_shipping_tab_slug();

			return $endpoints;
		}

		public function get_downloads_tab_slug() {
			return apply_filters( 'learn_press_course_downloads_tab_slug', $this->_tab_slug_downloads, $this );
		}

		public function get_orders_tab_slug() {
			return apply_filters( 'learn_press_course_orders_tab_slug', $this->_tab_slug_orders, $this );
		}

		public function get_address_tab_slug() {
			return apply_filters( 'learn_press_course_orders_tab_slug', $this->_tab_slug_address, $this );
		}

		public function get_address_edit_billing_tab_slug() {
			return apply_filters( 'learn_press_course_orders_tab_slug', $this->_tab_slug_address_edit_billing, $this );
		}

		public function get_address_edit_shipping_tab_slug() {
			return apply_filters( 'learn_press_course_orders_tab_slug', $this->_tab_slug_address_edit_shipping, $this );
		}

		/**
		 * Add Wishlist tab to user profile.
		 *
		 * @param $tabs
		 *
		 * @return mixed
		 */
		public function download_tab( $tabs ) {
			$tabs[ $this->get_downloads_tab_slug() ] = array(
				'title'    => __( 'Resources', 'learnpress-woodash' ),
				'slug'     => $this->get_downloads_tab_slug(),
				'callback' => array( $this, 'download_tab_content' ),
				'priority' => 21,
				'icon'     => '<i class="fas fa-file-download" aria-hidden="true"></i>',
			);

			return $tabs;
		}

		/**
		 * Display content of tab Downloads.
		 *
		 * @param $tab
		 * @param $tabs
		 * @param $profile
		 */
		public function download_tab_content( $tab, $tabs, $profile ) {
			$viewing_user = $profile->get_user();
			learn_press_woodashboard_template(
				'woo-downloads.php',
				array(
					'downloads' => 'content'
				)
			);
		}

		/**
		 * Add Orders tab to user profile.
		 *
		 * @param $tabs
		 *
		 * @return mixed
		 */
		public function orders_tab( $tabs ) {
			$tabs[ $this->get_orders_tab_slug() ] = array(
				'title'    => __( 'Orders', 'learnpress-woodash' ),
				'slug'     => $this->get_orders_tab_slug(),
				'callback' => array( $this, 'profile_tabs_woo_order_content' ),
				'priority' => 21,
				'icon'     => '<i class="fas fa-shopping-cart" aria-hidden="true"></i>',
			);

			return $tabs;
		}


	/**
	 * Content of profile order woocommerce page.
	 */
	public function profile_tabs_woo_order_content() {
		global $wp;
		$url   = home_url( $wp->request );
		$parts = explode( '/', $url );

		$total_records  = wc_get_customer_order_count( get_current_user_id() );
		$posts_per_page = get_option( 'posts_per_page' );
		$total_pages    = ceil( $total_records / $posts_per_page );

		$paged = ( end( $parts ) ) == 'w-orders' ? 1 : end( $parts );
		$from  = ( $paged - 1 ) * $posts_per_page + 1;
		$to    = $from + $posts_per_page - 1;
		$to    = min( $to, $total_records );
		if ( $total_records < 1 ) {
			$from = 0;
		}

		$offset          = array( $from, $to );
		$customer_orders = get_posts(
			array(
				'meta_key'       => '_customer_user',
				'meta_value'     => get_current_user_id(),
				'post_type'      => wc_get_order_types( 'view-orders' ),
				'posts_per_page' => $posts_per_page,
				'paged'          => $paged,
				'post_status'    => array_keys( wc_get_order_statuses() ),
			)
		);

		$format_text        = __( 'Displaying {{from}} to {{to}} of {{total}} {{item_name}}.', 'learnpress-woo-payment' );
		$output_format_text = str_replace(
			array( '{{from}}', '{{to}}', '{{total}}', '{{item_name}}' ),
			array(
				$offset[0],
				$offset[1],
				$total_records,
				'items',
			),
			$format_text
		);

		global $lp_addon_woo_payment;
		learn_press_woodashboard_template( 'woo-orders.php', compact( 'customer_orders', 'format_text', 'output_format_text', 'total_pages', 'paged' ) );
	}


			/**
		 * Add Wishlist tab to user profile.
		 *
		 * @param $tabs
		 *
		 * @return mixed
		 */
		public function address_tab( $tabs ) {
			$tabs[ $this->get_address_tab_slug() ] = array(
				'title'    => __( 'Addresses', 'learnpress-woodash' ),
				'slug'     => $this->get_address_tab_slug(),
				'callback' => array( $this, 'address_tab_content' ),
				'priority' => 21,
				'icon'     => '<i class="fas fa-home" aria-hidden="true"></i>',
			);

			/* $tabs[ $this->get_address_edit_billing_tab_slug() ] = array(
				'title'    => __( 'Addresses Edit', 'learnpress-woodash' ),
				'slug'     => $this->get_address_edit_billing_tab_slug(),
				'callback' => array( $this, 'address_edit_billing_tab_content' ),
				'priority' => 21,
				'icon'     => '<i class="fas fa-home" aria-hidden="true"></i>',
			);

			$tabs[ $this->get_address_edit_shipping_tab_slug() ] = array(
				'title'    => __( 'Addresses Edit', 'learnpress-woodash' ),
				'slug'     => $this->get_address_edit_shipping_tab_slug(),
				'callback' => array( $this, 'address_edit_billing_tab_content' ),
				'priority' => 21,
				'icon'     => '<i class="fas fa-home" aria-hidden="true"></i>',
			); */

			return $tabs;
		}

		/**
		 * Display content of tab Downloads.
		 *
		 * @param $tab
		 * @param $tabs
		 * @param $profile
		 */
		public function address_tab_content( $tab, $tabs, $profile ) {
			$viewing_user = $profile->get_user();
			learn_press_woodashboard_template(
				'woo-address.php',
				array(
					'downloads' => 'content'
				)
			);
		}

				/**
		 * Display content of tab Downloads.
		 *
		 * @param $tab
		 * @param $tabs
		 * @param $profile
		 */
		public function address_edit_billing_tab_content( $tab, $tabs, $profile ) {
			$viewing_user = $profile->get_user();
			learn_press_woodashboard_template(
				'form-edit-address.php',
				array(
					'downloads' => 'content'
				)
			);
		}


	}
}

add_action( 'plugins_loaded', array( 'LP_Addon_Woo_Dashboard', 'instance' ) );
