<?php
/**
 * LearnPress Wishlist Functions
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'learn_press_woodashboard_template' ) ) {
	/**
	 * Get wishlist template.
	 *
	 * @param      $name
	 * @param null $args
	 */
	function learn_press_woodashboard_template( $name, $args = null ) {
		LP_Addon_Woo_Dashboard::instance()->get_template( $name, $args );
		//learn_press_get_template( $name, $args, learn_press_template_path() . '/addons/wishlist/', LP_ADDON_WISHLIST_TEMPLATE );
	}
}



add_filter( 'learn_press_profile_tabs', 'learn_press_download_tab', 20, 2 );
if ( ! function_exists( 'learn_press_download_tab' ) ) {
	/**
	 *  Add wishlist tab into profile page.
	 *
	 * @param $tabs
	 * @param $user
	 *
	 * @return mixed
	 */
	function learn_press_download_tab( $tabs, $user ) {
		$content = '';

		$tabs[36] = array(
			'tab_id'      => 'user_downlods',
			'tab_name'    => __( 'Downloads', 'learnpress_woodash' ),
			'tab_content' => apply_filters( 'learn_press_user_download_tab_content', $content, $user )
		);
		// Private customize
		if ( $user->ID != get_current_user_id() ) {
			unset ( $tabs[36] );
		}

		return $tabs;
	}
}

add_filter( 'learn_press_profile_tabs', 'learn_press_order_tab', 20, 2 );
if ( ! function_exists( 'learn_press_order_tabs' ) ) {
	/**
	 *  Add wishlist tab into profile page.
	 *
	 * @param $tabs
	 * @param $user
	 *
	 * @return mixed
	 */
	function learn_press_order_tabs( $tabs, $user ) {
		$content = '';

		$tabs[37] = array(
			'tab_id'      => 'user_orders',
			'tab_name'    => __( 'Orders', 'learnpress_woodash' ),
			'tab_content' => apply_filters( 'learn_press_woodashboard_orders_template', $content, $user )
		);
		// Private customize
		if ( $user->ID != get_current_user_id() ) {
			unset ( $tabs[37] );
		}

		return $tabs;
	}
}

add_filter( 'learn_press_profile_tabs', 'learn_press_address_tab', 20, 2 );
if ( ! function_exists( 'learn_press_address_tabs' ) ) {
	/**
	 *  Add wishlist tab into profile page.
	 *
	 * @param $tabs
	 * @param $user
	 *
	 * @return mixed
	 */
	function learn_press_address_tabs( $tabs, $user ) {
		$content = '';

		$tabs[38] = array(
			'tab_id'      => 'user_address',
			'tab_name'    => __( 'Address', 'learnpress_woodash' ),
			'tab_content' => apply_filters( 'learn_press_woodashboard_address_template', $content, $user )
		);
		// Private customize
		if ( $user->ID != get_current_user_id() ) {
			unset ( $tabs[38] );
		}

		return $tabs;
	}
}



//hide tab in page profile
if ( !function_exists( 'thim_remove_tabs_course_profile' ) ) {
	function thim_remove_tabs_course_profile( $defaults ) {
		//Example remove gradebook
		//unset( $defaults['gradebook'] );
		//remove assignment
		//unset( $defaults['assignment'] );
		//remove assignment
		//unset( $defaults['withdrawals'] );
 		unset( $defaults['orders'] );
		unset( $defaults['lp_orders_woocommerce'] );
		//unset( $defaults['wishlist'] );
		//unset( $defaults['settings'] );
		//unset( $defaults['certificates'] );
		//unset( $defaults['quizzes'] );
		//unset( $defaults['instructor'] );
		//unset( $defaults['courses'] );
		return $defaults;
	}
}
add_filter( 'learn-press/profile-tabs', 'thim_remove_tabs_course_profile', 1001 );


if ( ! function_exists( 'super_unique' ) ) {
 function super_unique($array,$key)
    {
       $temp_array = [];
       foreach ($array as &$v) {
           if (!isset($temp_array[$v[$key]]))
           $temp_array[$v[$key]] =& $v;
       }
       $array = array_values($temp_array);
       return $array;

    }
}
