<?php
/**
 * Course review widget class.
 *
 * @author   ThimPress
 * @package  LearnPress/Course-Review/Classes
 * @version  3.0.2
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;


class LP_Widget_Pricing_Link extends WP_Widget {
 
    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
            'pricing_link', // Base ID
            'pricing_link', // Name
            array( 'description' => __( 'Add pricing link', 'text_domain' ), ) // Args
        );
    }
 
    /**s
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {

        $isMember = pmpro_hasMembershipLevel();

		?><div class="<?php 
        echo'top-pricing-link';
        if($isMember){
            echo ' is-member';
        }

        ?>"> <?php 
        extract( $args );
        // $title = apply_filters( 'widget_title', $instance['title'] );
 
        echo $before_widget;
        /* if ( ! empty( $title ) ) {
            echo $before_title . $title . $after_title;
        } */


		//echo $course->get_title();

		//$user_id = get_current_user_id();
        //$membership = $current_user->membership_level = pmpro_getMembershipLevelForUser($user_id);
		//get_membershiplevel =  pmpro_getMembershipLevelForUser($user_id); //will give array of current user level
        
        //$user = learn_press_get_user($user_id);
		//$enrolled = $user->has_enrolled_course($id);
		//$finished = $user->has_finished_course($id);
		//$media_intro = get_post_meta( $course_id, 'thim_course_media_intro', true );

		?>
        <?php if($isMember): ?>
            <a href="/online-training"><span>Unlimited Access</span></a>
        <?php  else: ?>
		<a href="/pricing"><span>Pricing</span></a>
        <?php endif; ?>
		
			<?php


		echo '</div>';

        echo $after_widget;
    }
 
    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'text_domain' );
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
         </p>
    <?php
    }
 
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
 
        return $instance;
    }
 
} // class Foo_Widget
 
?>