<?php
/**
 * Plugin load class.
 *
 * @author   ThimPress
 * @package  LearnPress/PmproAccount/Classes
 * @version  4.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'LP_Addon_Pmpro_Account' ) ) {
	/**
	 * Class LP_Addon_Pmpro_Account.
	 */
	class LP_Addon_Pmpro_Account extends LP_Addon {

		/**
		 * @var string
		 */
		protected $_tab_slug_pmpro_account = '';


		/**
		 * @var string
		 */
		public $version = LP_ADDON_PMPROACCOUNT_VER;

		/**
		 * @var string
		 */
		public $require_version = LP_ADDON_PMPROACCOUNT_REQUIRE_VER;

		/**
		 * Path file addon
		 *
		 * @var string
		 */
		public $plugin_file = LP_ADDON_PMPROACCOUNT_FILE;

		/**
		 * LP_Addon_Wishlist constructor.
		 */
		public function __construct() {
			parent::__construct();
			add_filter( 'learn-press/profile-tabs', array( $this, 'pmpro_account_tab' ), 100, 1 );
			$this->_tab_slug_pmpro_account = sanitize_title( __( 'Membership', 'learnpress-pmproaccount' ) );
			
			add_action( 'widgets_init', array( $this, 'load_widget' ) );
		}

		/**
		 * Defined constants.
		 */
		protected function _define_constants() {
			define( 'LP_ADDON_PMPROACCOUNT_PATH', dirname( LP_ADDON_PMPROACCOUNT_FILE ) );
			define( 'LP_ADDON_PMPROACCOUNT_INC', LP_ADDON_PMPROACCOUNT_PATH . '/inc/' );
			define( 'LP_ADDON_PMPROACCOUNT_TEMPLATE', LP_ADDON_PMPROACCOUNT_PATH . '/templates/' );
		}

		/**
		 * Includes files.
		 */
		protected function _includes() {
			include_once LP_ADDON_PMPROACCOUNT_INC . 'functions.php';
			require_once LP_ADDON_PMPROACCOUNT_INC . 'widgets.php';
			require_once LP_ADDON_PMPROACCOUNT_INC . 'admin/assign_course.php';
		}

		/**
		 * Init hooks.
		 */
		protected function _init_hooks() {
			$this->rewrite_endpoint();
		}


		/**
		 * Wishlist scripts.
		 */
		protected function _enqueue_assets() {
		}

		/**
		 * Rewrite endpoint.
		 */
		public function rewrite_endpoint() {
			$endpoint                     = preg_replace( '!_!', '-', $this->get_pmpro_account_tab_slug() );
			LP()->query_vars[ $endpoint ] = $endpoint;
			add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );
		}

		public function profile_tab_endpoints( $endpoints ) {
			$endpoints[] = $this->get_pmpro_account_tab_slug();

			return $endpoints;
		}

		public function get_pmpro_account_tab_slug() {
			return apply_filters( 'learn_press_pmpro_account_tab_slug', $this->_tab_slug_pmpro_account, $this );
		}


		/**
		 * Add Wishlist tab to user profile.
		 *
		 * @param $tabs
		 *
		 * @return mixed
		 */
		public function pmpro_account_tab( $tabs ) {
			$tabs[ $this->get_pmpro_account_tab_slug() ] = array(
				'title'    => __( 'Membership', 'learnpress-pmproaccount' ),
				'slug'     => $this->get_pmpro_account_tab_slug(),
				'callback' => array( $this, 'pmpro_account_tab_content' ),
				'priority' => 22,
				'icon'     => '<i class="fas fa-award" aria-hidden="true"></i>',
			);

			return $tabs;
		}

		/**
		 * Display content of tab PMPRO Account.
		 *
		 * @param $tab
		 * @param $tabs
		 * @param $profile
		 */
		public function pmpro_account_tab_content( $tab, $tabs, $profile ) {
			$viewing_user = $profile->get_user();
			learn_press_pmproaccount_template(
				'pmpro-account.php',
				array(
					'pmpro_account' => 'content'
				)
			);
		}

		public function load_widget() {
			register_widget( 'LP_Widget_Pricing_Link' );
		}


	}
}

add_action( 'plugins_loaded', array( 'LP_Addon_Pmpro_Account', 'instance' ) );
