<?php

// Prevent loading this file directly
defined('ABSPATH') || exit;

function learndo_pmpro_assign_add_menu_item_courses()
{
    add_submenu_page('learn_press', 'PMPRO Assign Courses', 'PMPRO Assign Courses', 'activate_plugins', 'learndo-pmpro-assign-courses', 'learndo_pmpro_render_assign_course', 100);
}
add_action('admin_menu', 'learndo_pmpro_assign_add_menu_item_courses');


function learndo_pmpro_render_assign_course()
{
?>
    <div class="wrap">

        <h2>LearnDo PMRO Assign Course</h2>

        <?php $course_id = array_key_exists('course_id', $_GET) ? $_GET['course_id'] : ''; 
        $dry_run = array_key_exists('dry_run', $_GET) ? true : false; 
        $batch = array_key_exists('batch', $_GET) ? $_GET['batch'] : 100; ?>

        <?php if($course_id):
        global $wpdb; //This is used only if making any database queries

		// Get subscribers
        $subscriber_ids = array();
		$subscribers = $wpdb->get_results("
			SELECT user_id FROM wp_pmpro_memberships_users
			WHERE status LIKE 'active'");
        foreach($subscribers as $subscriber) {
            $subscriber_ids[] = $subscriber->user_id;
        }
        
        // Get subscribers allready assigned
        $already_assigned_ids = array();
        $already_assigned = $wpdb->get_results("
            SELECT u.user_id AS user_id
            FROM wp_pmpro_memberships_users AS u
            LEFT JOIN wp_learnpress_user_items AS lp ON (u.user_id = lp.user_id)
            WHERE u.status LIKE 'active'
            AND lp.item_id LIKE $course_id");
        foreach($already_assigned as $subscriber) {
            $already_assigned_ids[] = $subscriber->user_id;
        }

        //var_dump( $already_assigned_ids );
        
        $not_assigned = array_diff($subscriber_ids, $already_assigned_ids);
        $not_assigned = get_users( [ 'include' => $not_assigned, 'fields' => 'ID' ] );

        if($dry_run) echo "<h2>Dry Run</h2>";
        echo "Users: " . count($not_assigned) . "<br><br>";

        $count = 0;
        foreach($not_assigned as $user_id){
            $count++;
            if($count > $batch){
                echo "batch end, reloading page in 2 seconds";

                echo "<script type='text/javascript'>
                setTimeout(function(){
                    location.reload();
                }, 2000); // 2000 milliseconds = 2 seconds</script>";
                 break;
            };
            echo $user_id . "<br>";

            if(!$dry_run){
                try {
                    // Learnpress new order
                    $courses = $course_id;
                    $lp_order = array('post_type' => 'lp_order');
                    $post_id = wp_insert_post($lp_order); // Create new order in LearnPress orders
                    $lp_order    = learn_press_get_order($post_id);
                    $order_item_ids = $lp_order->add_items($courses); //add courses to the order
        
                    $lp_order->set_user_id($user_id); // User into the course
                    $lp_order->set_status('lp-completed');
                    // Setorder as paid and complete you can use status based on your requirements
                    $lp_order->save();
                } catch (Exception $e) {
                    csvlpimport_log('course error: ', $user_id,  $e->getMessage());
                }
            }

            if(count($not_assigned) == 0) {
                echo '<br>all assigned';
            }
        }
        
        else: ?>

        <form action="<?= esc_url(admin_url('admin.php')) ?>">
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
            <label for="dry_run">Dry run</label>
            <input type="checkbox" checked name="dry_run" id="dry_run">
            <label for="course_id">Course ID</label>
            <input type="text" name="course_id" value="" />

            <br>
            <label for="batch">Batch</label>
            <input type="text" name="batch" value="20" placeholder="Batch Count" />
				<input type="submit" value="Assign to Members" class="e-button" />

        </form>
        <?php endif; ?>
    </div>

<?php
}

?>